/* WESTERN DEMO DEVELOPMENT DOORS
   by William Bell (All Rights Reserved)
   This is a demo game of HIGH LOW.
   Steps:
      1. Register from TMW to get a doors number.
         Currently there can be 254 outside doors.
         types -   0 is quit program
                   1 means player left TLCF
      2. Add entry into west.cfg for your door.
         Put into your mainbbs.exe directory.
         The command must start with a "." and have no spaces.
         .tl and your executable must be the name (hl.exe) in
         this example.
      3. Compile this door:
         MSC V5.1/ 6.0 or 7.0:
            cl /AL /c /Gs hl.c
            link /ST:10000 hl lmtcc doorutil;
      4. Put this door in your mainbbs.exe directory.
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include "..\structs.h"
#include "..\bbscfg.h"
#include "..\doorutil.h"
#include "door.h"   /* WESTERN DOOR HEADER */

#define HIGHLOW 2
int high(char *str, int line);
int door_send(int line, char *str);
int door_all_send(char *str);
int send_shutdown(int num);

struct msgdoor *door;

extern int     who;                /* which line the user is logged onto */
extern int     inq;                /* message queue west->hl messages */
extern int     outq;               /* message queue hl->west messages */
extern int     numlines;           /* number of lines on this Falken system */
extern acctp   *acct;              /* pointer to array of account structures */
extern userp   *user;              /* pointer to array of user structures */
extern struct  acct_rec *myacct;   /* pointer to THIS users account structure */
extern struct  user_rec *myuser;   /* pointer to THIS users user structure */
extern struct  msg3    *m3;        /* general purpose message queue pointer */
extern struct  msg1    *m1;        /* general purpose message queue pointer */
extern char    workbuf[1024];      /* common area for message transfers */

int numplayers = 0;   /* set number of players */

struct play {
  char handle[uidlen];
} players[33] = {0};

char temp[1000];  /* temp place holder */
char cb[1000];    /* another place holder */

int main (int argc, char **argv)
{
  time_t t1;

  init();

  door  = (struct msgdoor *) workbuf;

  t1 = time(NULL) + 20L;  /* wait 20 seconds for the 1st message */
  for (;;)
  {
    if (testmsg(inq))
    {
      recvmsg(inq, workbuf, sizeof(struct msgdoor));
      if (door->type == HIGHLOW)
        break;
      else if ((door->type < 256) && (door->type > 1))
      {
        send_md_msg(inq, workbuf, sizeof(struct msgdoor));
        relinq();
      }
    }
    else if (t1 < time(NULL))
      exit(0);
    else
      relinq();
    /* get 1st player */
  }

  if (door->type == HIGHLOW)  /* my door */
  {
      who = door->line;
      strncpy(temp, door->text, 1000);
      high(temp, who);
  }

  for (;;)
  {
    if (testmsg(inq))
    {
      recvmsg(inq, workbuf, sizeof(struct msgdoor));
      if (door->type == HIGHLOW)  /* my door */
      {
        who = door->line;
        strncpy(temp, door->text, 1000);
        high(temp, who);
      }
      /* a type == 1 is a logoff/quit from western */
      else if (door->type == 1)
      {
        if (numplayers > 0)
        {
          who = door->line;
          if (players[who].handle[0])
          {
            players[who].handle[0] = '\0';
            numplayers--;
          }
          if (numplayers == 0)
          {
            send_shutdown(HIGHLOW);
            /* this tells western we are leaving memory */
            break;
          }
        }
      }
      else if (door->type == 0)  /* remove the door */
      {
        break;
      }
      else if (door->type < 256)
      {
        /* it is someone elses message */
        send_md_msg(inq, workbuf, sizeof(struct msgdoor));
        delay(1);
      }
    }
    else
       relinq();
  }
}  /* main */

int new_num = -1;

int high(char *str, int line)
{
  if (stricmp(str, "OFF") == 0)
  {
    sprintf(cb, "%s turned TMW High Low game off!\r", (*acct)[line].acctname);
    door_all_send(cb);
    players[line].handle[0] = '\0';
    if (numplayers > 0)
      numplayers--;
    if (numplayers == 0)
    {
        send_shutdown(HIGHLOW);
        /* this tells western we are leaving memory */
        exit(0);
    }
  }
  else if (stricmp(str, "HELP") == 0)
  {
    door_send(line, "Object of game is to be the first person\r");
    door_send(line, "to pick the correct number between 0-100.\r");
    door_send(line, "   .hl <num>  To give a guess on a number\r");
  }
  else if (stricmp(str, "ON") == 0)
  {
    if (players[line].handle[0])
      door_send(line, "Already playing High Low\r");
    else
    {
      /* here you would have more compares */
      sprintf(cb, "%s turned TMW High Low game on!\r", (*acct)[line].acctname);
      strncpy(players[line].handle, (*acct)[line].acctname, uidlen);
      door_all_send(cb);
      numplayers++;
    }
  }
  else if (isdigit(*str))
  {
    if (players[line].handle[0] == '\0')
    {
      /* here you would have more compares */
      sprintf(cb, "%s turned TMW High Low game on!\r", (*acct)[line].acctname);
      strncpy(players[line].handle, (*acct)[line].acctname, uidlen);
      door_all_send(cb);
      numplayers++;
    }
    if (new_num == -1)
    {
      srand( (unsigned) time(NULL));
      new_num = rand() % 100;
      sprintf(cb, "%s is starting new game\r",
              players[line].handle);
      door_all_send(cb);
    }
    if (atoi(str) == new_num)
    {
      sprintf(cb, "%s won high low game with %d!! Congratulations.\r",
                   players[line].handle, new_num);
      door_all_send(cb);
      new_num = -1;
    }
    else if (atoi(str) < new_num)
    {
       sprintf(cb, "You are too low\r");
       door_send(line, cb);
    }
    else
    {
      sprintf(cb, "You are too high\r");
      door_send(line, cb);
    }
  }
  else
  {
    door_send(line, "Invalid HIGH LOW command\r");
  }
}  /* high */

int send_shutdown(int num)
{
    m1->text[0] = '\0';
    m1->type = num;
    m1->count = 2;
    send_md_msg(outq, workbuf, 6);
    delay(1);
} /* send_shutdown */

int door_send(int line, char *str)
{
    strncpy(m1->text, str, 999);
    m1->text[999] = '\0';
    m1->type = 1;
    m1->count = line;
    send_md_msg((*user)[line].door_outq, workbuf, strlen(str) + 6);
} /* door_send */

int door_all_send(char *str)
/* This function will send a message to everyone in the game */
{
  int i;

  for (i = 0; i < numlines; i++)
  {
    if (players[i].handle[0])
      door_send(i, str);
  }
} /* door_all_send */
