/*
	"Generic" Fido driver; all functions go
	through INT 14. Cannot be used with Ptel 
	cuz the screen stuff isnt defined.

*/

/* External variables. */

extern int cd_bit;		/* BBS bit pattern for checking CD */

extern int iodev;		/* chanel # */

init() {
	int14(4,0x83,iodev);			/* set baud/init hardware, */
}

uninit() {
	int14(5,0,iodev);
}
/* Get a character from the modem. This just returns the character, no checking
for ready, etc. That is all done before this is called.  */

_mconin() {
	return(int14(2,0,iodev) & 0xff);	/* Call ROM BIOS, */
}

/* Output a character to the modem. Just output, error checking, ready check,
etc is done before this is called. */

_mconout(c)
char c;
{
	int14(1,c,iodev);
}

/* Return true if the modem is ready to accept a character. */

_mconostat() {
	return(int14(3,0,iodev) & 0x2000);
}

/* Return true if the modem has a character to read. */

_mconstat() {
	return(int14(3,0,iodev) & 0x100);
}

/* Return true if the DSR, or modem ready, line is true. This should return
true whenever the modem is ready and has a carrier detect, and false otherwise.
 */

_cd() {

	return(int14(3,0,iodev) & cd_bit);
}

/* Set the baud rate. */

int baudtbl[] = {
	300,0x43,
	1200,0x83,
	2400,0xa3,
	9600,0xe3,
	0,0
};
baud(r)
int r;
{
int i;

	for (i= 0; baudtbl[i]; i+= 2) 
		if (baudtbl[i] == r) break;
	if (baudtbl[i] == 0) return(0);
	int14(0,baudtbl[i + 1],iodev);
	return(r);
}
/* Raise DTR. Reinitializing the port does it. */

raise_dtr() {
	int14(6,1,iodev);
}
/* Lower DTR. Do the baud set trick to flush the
output buffer. */

lower_dtr() {
	int14(6,0,iodev);
}
