title Timer Tick Allocation
name tickfunc
include model.ash
include lattice.ash
;
; Provides timer tick allocation functions.
;
; h= set_tick(&timer);
; int h;
; long *timer;
;
;    Returns the handle of an allocated
;timer tick; the counter will be continuously
;incremented until the handle is released.
;The timer has a resolution of 1 mS, and
;unknown accuracy. It is generally incremented
;in increments of the system clock. -1 is
;returned if no handles are available.
;
; clr_tick(h);
; int h;
;
; Release a handle.
;
dseg
;
;This is the handle table. 
;
MAXTICK	equ	8

pile dw MAXTICK dup (0)

endd

cseg
;
;Interrupt service routine for
;the timer ticks. AX contains the number
;of milliseconds since the last tick. This
;must preserve all registers.
;
public tickfunc

tickfunc:
	push	si
	push	bx
	xor	bx,bx
tf1:	mov	si,pile[bx]
	or	si,si
	jz	tf2
	add	word ptr [si],ax
	jnc	tf2
	inc	word ptr [si + 2]
tf2:	add	bx,2
	cmp	bx,(MAXTICK * 2)
	jb	tf1
	pop	bx
	pop	si
	ret
;
; h= set_tick(&timer);
;
func set_tick
	mov	cx,MAXTICK
	mov	ax,0	;AX == handle
st1:	mov	bx,ax
	shl	bx,1	;word ptr
	cmp	word ptr pile[bx],0
	jne	st2	;find a zero,
	mov	dx,arg0
	mov	pile[bx],dx ;store pointer
	jmp	st3	;return handle
st2:	inc	ax	;next handle ...
	loop	st1
	mov	ax,-1	;no free handles
st3:
endf set_tick
;
; clr_tick(h);
;
func clr_tick
	mov	ax,-1
	mov	bx,arg0
	cmp	bx,MAXTICK
	jae	ct1
	shl	bx,1
	mov	word ptr pile[bx],0
	mov	ax,0
ct1:
endf clr_tick

endc

	end
