/* $VER AnsiDetect 1.1 (21-Aug-93) */
/*
This will automagically select ANSI for users with a normal ANSI terminal.
It works by sending a cursor position request command to the user's
terminal, and listening for a response. If there is no response in
one second (by default), it will erase its tracks and exit, as 
if it never had been run. The one second has worked well for me, but
if you need to change it, just change the 'delaytime' variable below. If
you arn't using locked bauderates, you should be able to reduce it to .2
seconds or so. When I set it to .5, it worked fine for 9600 baud callers,
but it would time out for 2400 baud callers. It doesn't matter too much if
it has a long delay, since most users (at least on my system) have ANSI
terminals. Don't make it too long, tho, since it busy-waits for the given
time period, and it could degrade performance on slower multi-line 
machines if it is too long (like longer than 5 seconds). If someone can
tell me how to avoid the busy-wait and still respond immediately to an
ANSI reply, please let me know.

I want to thank Gregory Hopkins (Archimedian) for the all-important ANSI
sequence that makes this possible.

Installation is simple. 

1. Copy line 22 of your BBSTEXT file to the 'promptstr' assignment below.
   The default (CNet 2.63) line is alrady there, so unless you have hacked
   on your BBSTEXT, you can skip this. 

2. Change line 22 of BBSTEXT to:

#0pfiles:AnsiDetect.rexx}  

(The first character is a ^Q, of course...)

3. Put this file in your Pfiles: directory.

I tried to comment it so that even the most basic ARexx user should be able
to understand it. I tried to design it to be completely transparant to the
user, although it may screw up some user's auto-logon scripts.

Written  by 

Stefan Hudson (Surak)
VisionSoft BBS (408) 625-6580 v.32bis (8 lines total)
UUCP vsbbs!hudson@hotcity.com (hudson@oc.nps.navy.mil is faster, tho.)

This is in the public domain. You can do what you damn well please with it.
I am in no way responsible for any damage that occures to your equipment
because of this file. 
I have no idea if this will work in any version of CNet other than 2.63.

========= Changes in V1.1 =========
- Put a delay in after detection to allow slower modems to finish transmitting
the cursor position. Previously, this would result in users with 2400 bps
modems and ANSI terminals getting a ";1R" string in the handle prompt.
At least it did on my machine (A 40 Mhz 030), slower machines might not
have the same problem because delay in the ARexx interpreter.

- Added the $VER version string at the top.

==============================================================================
*/

promptstr = 'n1Terminal A=ANSI, C=CBM, I=IBM, S=Sky, [NONE]: '
delaytime = 1.5

/* You shouldn't have to change anything below here  */

options results
result = 0

sendmodem '[6n'   /* The key... ask the terminal for cursor position */

/* Now, wait half a second for the report to come back. This may have
   to be lengthened for slower terminals/baudrates. */

call time('R')
do while result=0
   checkio
   if time('E') >= delaytime then result = 2
end

/* Result = 1 if keys are in buffer, Result = 2 if it timed out */

if result=1 then call checkauto

/* If checkauto returned, it was a bad or no auto-detect, so we just
   backspace and space over our messy position request, print the prompt
   string, and pretend we never were here.  */

sendmodem copies(d2c(8),4); sendmodem '    ' 
sendstring promptstr 
exit

checkauto:    /* Interpret the response */

getchar
if result = '2b'x then return    /* First char in buffer an ESCAPE? */

checkio; if result = 0 then return   /* Any more characters? */

getchar
if result= '['  then do  /* Second character a '[' ? Then we got it! */
                         /* We don't care about cursor position...   */
   sendstring 'n1ANSI Terminal Detected!' 
   call time('R')        /* Now we have to wait a bit, since 2400 bps */
      do while time('E') <= .2  /* and slower modems may still be */
   end                   /* transmitting the cursor pos. */
   bufferflush           /* flush the cursor pos... we don't need it */
   addkeys 'I'           /* Press 'I' (for IBM) on the user's kb...  */
   exit                  /* Then quietly disappear. */
end
return
