
(*
 * dirsum - read multiple outputs of DIRCOUNT and produce a summary report
 *
 *)

(* --------------------------------------------------------- *)
function remove_commas(s: string): string;
var
   i: integer;
   t: string;
begin
   t := '';
   for i := 1 to length(s) do
      case s[i] of
         '0'..'9':
            t := t + s[i];
      end;
   remove_commas := t;
end;


(* --------------------------------------------------------- *)
function atoi(s: string): longint;
var
   i: integer;
   l: longint;
begin
   s := remove_commas(s);
   val(s,l,i);
   atoi := l;
end;


(* --------------------------------------------------------- *)
function insert_commas(s: string): string;
var
   i: integer;
begin
   i := length(s);
   while i > 3 do
   begin
      dec(i,3);
      insert(',',s,i+1);
   end;

   insert_commas := s;
end;


(* --------------------------------------------------------- *)
function itoa (n: longint): string;
var
   tstr:          string;

begin
   str(n, tstr);
   itoa := insert_commas(tstr);
end;


(* --------------------------------------------------------- *)
function itoan(n: longint; width: integer): string;
var
   s: string;
begin
   s := itoa(n);
   while length(s) < width do
      s := ' ' + s;
   itoan := s;
end;


(* --------------------------------------------------------- *)
function ljust(s: string; width: integer): string;
begin
   s := copy(s,1,width);
   while length(s) < width do
      s := s + ' ';
   ljust := s;
end;


(* --------------------------------------------------------- *)
function center(s: string; width: integer): string;
var
   i: integer;
begin
   s := copy(s,1,width);
   i := (width - length(s)) div 2;
   while i > 0 do
   begin
      s := ' ' + s;
      dec(i);
   end;
   center := s;
end;


(* --------------------------------------------------------- *)
function cjust(s: string; width: integer): string;
var
   i: integer;
begin
   s := copy(s,1,width);
   i := (width - length(s)) div 2;
   while i > 0 do
   begin
      s := ' ' + s;
      dec(i);
   end;
   while length(s) < width do
      s := s + ' ';
   cjust := s;
end;


var
   boardname:  string;
   confname:   string;
   line:       string;
   tconfs:     integer;
   areas:      longint;
   tareas:     longint;
   files:      longint;
   tfiles:     longint;
   sizes:      longint;
   tsizes:     longint;
   fd:         text;
   i,j,k:      integer;
   temp:       longint;

begin
   if paramcount < 1 then
   begin
      writeln('usage: DIRSUM file1 file2 ... >outfile');
      writeln('summarizes report files generated by DIRCOUNT');
      halt;
   end;

   tconfs := 0;
   tareas := 0;
   tfiles := 0;
   tsizes := 0;

   for i := 1 to paramcount do
   begin
      assign(fd,paramstr(i));
      reset(fd);

      readln(fd);
      readln(fd,boardname);

      readln(fd,confname);
      while copy(confname,1,1) = ' ' do
         delete(confname,1,1);
      if confname[1] = '[' then
      begin
         delete(confname,1,1);
         dec(confname[0]);
      end;
      while length(confname) < 40 do
         confname := confname + ' ';

      inc(tconfs);
      readln(fd);
      readln(fd);
      readln(fd);
      areas := -2;

      repeat
         readln(fd,line);
         inc(areas);
      until eof(fd) or (pos(' Overall Totals ',line) > 0);
      close(fd);

      tareas := tareas + areas;

      files := atoi(copy(line,50,7));
      tfiles := tfiles + files;

      sizes := atoi(copy(line,60,14));
      tsizes := tsizes + sizes;

      if tconfs = 1 then
      begin
         writeln;
         writeln(boardname);
         writeln(center('Overall Summary of Available Files',79));
         writeln;
         writeln('                Conference                  Areas     Files      File Sizes  ');
         writeln('  --------------------------------------   -------  --------  ----------------');
      end;

      writeln('  ',confname,
               itoan(areas,7),
               itoan(files,10),
               itoan(sizes,18));
   end;

   writeln('                                           -------  --------  ----------------');
   writeln('                          Overall Totals  ',
            itoan(tareas,7),
            itoan(tfiles,10),
            itoan(tsizes,18));
end.

