/*
    $VER: SelectADD VDE 3.0 (8.28.93)
*/

#include <exec/types.h>
#include <stdio.h>
#include <stdlib.h>

#define	 NUM_V 9	/* Number of VDE records */

struct VDEentry {
	char	text[48];

	short	xpos,		/* where to print these things */
		ypos;

	long	min,		/* for numerix */
		max;		/* for numerix */

	short	length,		/* for string entry, field size */
				/* for bit boolean, which bit? */

		type;		/* 0 = UBYTE 0/1
				   1 = ULONG BIT 0/1
				   2 = Text
				   3 = BYTE numeric
				   4 = short numeric
				   5 = USHORT numeric
				   6 = long numeric 		*/

	long	offset;		/* position in structure */

	short	screen0,	/* belongs-to screen */
		screen2;	/* goes-to screen, -1 for exit */

	short	goup,		/* VDEentry for movement */
		godown,
		goleft,
		goright;

	short	ghost;		/* ghost for uz[] flags set */
};

struct VDEentry sendit[NUM_V] = {

        /* SCREEN 0 */

        {">> Exit       ",		/* 0 */
        	1, 2,
        	0, 0,
        	0,
        	-1, 0,
        	0, 2,
        	0, 1, 1, 0,
        	0
        },
        
        {">> Post File  ",		/* 1 */
        	1, 3,
        	0, 0,
        	0,
        	-1, 0,
        	0, -1,
        	0, 3, 0, 3,
        	0
        },
        
        {"Filename     :",		/* 2 */
        	1, 7,
        	0, 0,
        	31,
        	2, 4,
        	0, 0,
        	3, 4, 3, 4,
        	0
        },
        
        {"Pathname     :",		/* 3 */
        	1, 6,
        	0, 0,
        	60,
        	2, 36,
        	0, 0,
        	1, 2, 1, 2,
        	0
        },

        {"File Credits :",		/* 4 */
        	1, 9,
        	0, 100,
        	3,
        	4, 144,
        	0, 0,
        	2, 5, 2, 5,
        	0
        },

        {"Byte Credits :",		/* 5 */
        	1, 10,
        	-1, 1000000,
        	7,
        	6, 140,
        	0, 0,
        	4, 6, 4, 6,
        	0
        },

        {"AutoKill     :",		/* 6 */
        	1, 12,
        	0, 0,
        	0,
        	0, 139,
        	0, 0,
        	5, 6, 5, 6,
        	0
        },

        {"    To subtract 100% byte",		/* 7 */
        	33, 9,
        	0, 0,
        	0,
        	-1, 0,
        	0, 0,
        	0, 0, 0, 0,
        	0
        },

        {"<-- credit, enter -1.    ",		/* 8 */
        	33, 10,
        	0, 0,
        	0,
        	-1, 0,
        	0, 0,
        	0, 0, 0, 0,
        	0
        }

};




void main( void )
{
	FILE	*fp;


	if( fp = fopen( "postfile", "w" ) ) {
		fwrite( (char*)&sendit, sizeof( struct VDEentry ), NUM_V, fp );
		fclose( fp );

		printf( "----- postfile VDE written successfully!\n" );
	}
	else	printf( "Problems writing postfile VDE\n" );
}
