/*

                           Upchek 1.0
                           August 22, 1993
                           Kim Bergman

*/
"@echo off"
taboos=""
configpath=directory()||"\upchek.cfg"
j=lines(configpath)
if j=0 then do
   say "Aborting: Can't open Upchek.cfg"
   exit
end 
else do until lines(configpath)=0
   do until left(inline,1)<>"%"
      inline=translate(strip(linein(configpath)))
   end                              /* do until left(strip(inline),1)<>"%" */

   select
      when lastpos("BADACT",inline)=1    then badact=translate(subword(inline,2,1))
      when lastpos("LISTSCAND",inline)=1  then listscand=translate(subword(inline,2,1))
      when lastpos("MAXDIR",inline)=1    then maxdir=translate(subword(inline,2,1))
      when lastpos("WORKDIR",inline)=1   then workdir=translate(subword(inline,2,1))
      when lastpos("TEMPFIL1",inline)=1   then tempfil1=translate(subword(inline,2,1))
      when lastpos("TEMPFIL2",inline)=1   then tempfil2=translate(subword(inline,2,1))
      when lastpos("LOGFILE",inline)=1     then hisfile=translate(subword(inline,2,1))
      when lastpos("OPTSFILE",inline)=1     then optsfile=translate(subword(inline,2,1))
      when lastpos("BADPATH",inline)=1    then badpath=translate(subword(inline,2,1))
      when lastpos("FULLBADPATH",inline)=1 then fullbadpath=translate(subword(inline,2,1))
      when lastpos("DOORFILE",inline)=1    then doorfile=translate(subword(inline,2,1))
      when lastpos("DISCOURAGE",inline)=1 then discourage=translate(subword(inline,2,1))
      when lastpos("RESTRICTED",inline)=1  then taboos=translate(subword(inline,2,1))
      otherwise nop
   end                            /* select */
end  /* Do until lines(configpath)=0 */
j=stream(configpath,c,'close')

/*
say"badact =      ["||badact"]"
say"listscand=    ["||listscand"]"
say"maxdir =      ["||maxdir||"]"
say"workdir =     ["||workdir||"]"
say"tempfil1 =    ["||tempfil1||"]"
say"tempfil2 =    ["||tempfil2||"]"
say"hisfile =     ["||hisfile||"]"
say"optsfile =    ["||optsfile||"]"
say"badpath =     ["||badpath||"]"
say"fullbadpath = ["||fullbadpath||"]"
say"doorfile =    ["||doorfile||"]"
say"taboos =      ["||taboos||"]"

 pull usin */


/* The first 3 args expected are:
    1. Path to file to be processed with trailing \
    2. Filename stem of file to be processed
    3. Filename extension of file to be processed

The fourth arg will be path to Max's miscellaneous directory when Upchek.cmd
is called by Max.  If invoked on the command line then fourth arg must be "/L".
*/

parse arg ulpath filnam ext mecpath           /* get args au naturel */
arg uculpath ufilnam uext mode           /* get args converted to uppercase */
                                       /* to facilitate comparisons later*/
/* check if parms valid */
if ulpath="?" | uculpath="HELP" then signal usage
if ulpath="" | filnam="" | ext="" | mecpath="" then signal noparms

/* build some strings */ 
fullnam = filnam||ext
fullpath = ulpath||fullnam
stars = "***************************************************************************"

/* Check see if file to be processed exists */
a = lines(fullpath)
if a=0 then do
       say "Upchek.cmd Error:  Can't find "||fullpath
       r = lineout(hisfile, "Upchek.cmd Error:  Can't find "||fullpath)
       r = lineout(hisfile,stars)
       a = stream(hisfile,c,close)
       exit                  /* Bogus path or filename, exit. */
    end
else a = stream(fullpath,c,close)  /* File exists so close it and go to work */

/*  If mode is not Local then prepare .... */
if mode<>"/L" & mode<>"L" then do
     badmec=mecpath||"file_bad.mec"                     /* delete old mecca files that have previous report */
     okmec=mecpath||"file_ok.mec"                        /* see Max_ref.prn for more info on how Max uses these 2 files */
     del badmec
     del okmec
     a=lineout(badmec," ")                               /* initialize caller reports with blank line */
     a=lineout(okmec," ")
     a=lines(doorfile)                                       /* read the door file */
     if a<>0 then do
           nodenum=linein(doorfile)
           usernam=linein(doorfile)
         end
     else do                                               /* abort if can't find door file */
          r=lineout(hisfile,"Can't read the doorfile from "||doorfile||".  Upchek.cmd aborted.")
          r=lineout(hisfile,stars)
          exit
       end 
   end
else do
     mode="L"
     nodenum="00"
   end


/* initialize some variables */
arcount = 0    /* counts archives found, good and grunged ones */
filcount = 0    /* counts normal files scanned */
workdir=workdir||nodenum
tempfil1=tempfil1||nodenum
tempfil2=tempfil2||nodenum
note="blank"

/* build some commands */  
getfile = "copy "||fullpath||" "||workdir
beinworkdir = "cd "||workdir 
makworkdir = "mkdir "||workdir
cleardir = "del "||workdir||"\*.* /N"
erasedir = "rd "||workdir
scanfiles = "os2scan "||workdir||" @"||optsfile

makworkdir
beinworkdir
getfile

/* Write sysop report header to log file */
r = lineout(hisfile,date("N")||" processing "||fullpath||".")
if mode="L" then r=lineout(hisfile,"Local mode.")
  else  r=lineout(hisfile,"Uploaded by "||usernam)

/* initialize some flags, accumulators */
badcount=0                    /* counts corrupted archives */
badarcnames=""               /* accumulates names of bad archives */
clean="TRUE"                 /* goes FALSE and stays FALSE if scanner finds a virus */
scanaborted="FALSE"         /* goes TRUE and stays TRUE if scanner aborts */
abnormal="FALSE"            /* goes TRUE and stays TRUE if scanner exits with abnormal errorlevel */
hastaboos="FALSE"           /* goes TRUE and stays TRUE if restrict finds taboo file extensions */

/* sniff the file, if it's archive then call the archive handler */
instrg=charin(fullnam,,5)
a=stream(fullnam,c,"close")

if left(instrg,3)="ZOO" then call arhand
  else if substr(instrg,3,3)="-lh" then call arhand
    else if c2d(left(instrg,1))=26 then call arhand
      else if left(instrg,2)="PK" & c2d(substr(instrg,3,1))=3 & c2d(substr(instrg,4,1))=4 then call arhand
        else if left(instrg,1)="`" & c2d(substr(instrg,2,1))=234 then call arhand
          else do                               /* file is not an archive we can handle */
              call restrict                      /* see if it's a restricted file */
              scanfiles                         /* may as well scan it */
              if RC=1 then clean="FALSE"    /* check return code from scanner, RC=0 means no virus found */
               else if RC=2 then scanaborted="TRUE"
                 else if RC<0 | RC>4 then abnormal="TRUE"
             end                                 /* file is not an archive we can handle */

/* process all those flags and decide what to do if file is bad */
  if badcount>0|clean="FALSE"|scanaborted="TRUE"|abnormal="TRUE"|hastaboos="TRUE" then do
      if badact="MOVE"|badact="RENAME" then do
            a=lines(fullbadpath||fullnam)             /* check if file already exists at destination */
            if a=0 then do                           /* file not there yet */
                if badact="MOVE" then do
                     "move "||fullpath||" "||badpath
                      note="Moved "||fullpath||" to "||badpath||"."
                end  /* if badact=move */
                else do
                      note="Renamed "||fullpath||" to bad"||fullnam"."
                      ren fullpath "bad"||fullnam
                end  /* else */
             end   /* if a=0 */
              else do                                 /* file is there already */
                  del fullpath
                  note="Deleted "||fullpath||" because "||fullnam||" exists at "||badpath||"."
                 end
            end    /* if badact=move or badact=rename  */
           else if badact="DELETE" then do
                 note="Deleted "||fullpath||"."
                 del fullpath
               end    /* if badact=delete */
    end /* if badcount>0|clean="FALSE"|scanaborted="TRUE"|abnormal="TRUE"  */

/* finish writing user report  */
if mode<>"L" then do 
   if clean="FALSE"  then do
       r=lineout(badmec,"[white]")
       r=lineout(badmec,"Scanned "||fullnam||" with McAfee's OS2Scan 1.06.")
       r=lineout(badmec,"We suspect that it is [lightred blink]infected [white]by a virus.")
       r=lineout(badmec,"Please examine "||fullnam||" with your own scanner.")
       r=lineout(badmec,"If you feel an error has occurred then please contact the sysop.")
      end
 
    if scanaborted="TRUE" then do
       r=lineout(badmec,"[white]")
       r=lineout(badmec,"The virus scanner crashed while processing "||fullnam||".")
       r=lineout(badmec,"Please examine your "||fullnam||".")
     end
    if clean="TRUE" & scanaborted="FALSE" then do
       r=lineout(okmec,"[white]")
       r=lineout(okmec,"Scanned "||fullnam||" with McAfee's OS2Scan 1.06.")
       r=lineout(okmec,"Found no viruses.")
     end
     if hastaboos="TRUE" & discourage="TRUE" then do
         r=lineout(badmec,"[white]")
         r=lineout(badmec,"You have uploaded a file with an extension that appears in the following list:")
         r=lineout(badmec,taboos)
         r=lineout(badmec,"Those kinds of files are not accepted here.")
      end               /* if hastaboos="TRUE" */
    r=lineout(badmec,"[yellow]")
    r=lineout(badmec,"Hit <ENTER> to continue ......")
    r=lineout(badmec,"[readln]")

    r=lineout(okmec,"[yellow]")
    r=lineout(okmec,"Hit <ENTER> to continue ......")
    r=lineout(okmec,"[readln]")

 end
/* finish writing sysop report */
"dir /B /L > "||tempfil1
if listscand="TRUE" then a=lineout(hisfile,"Scanned the following normal files:")
j=lines(tempfil1)  
r=0 
filcount=0
do while (j<>0) & (r=0)
     a=linein(tempfil1)
     if listscand="TRUE" then r=lineout(hisfile," "||a)
     filcount = filcount+1
     j=lines(tempfil1)
end 
r = lineout(hisfile,"Counted "||filcount||" file(s) in "||arcount||" archive(s).")
if clean="TRUE" then r=lineout(hisfile,"Found no viruses.")
  else r=lineout(hisfile,"Found one or more viruses.")
r=lineout(hisfile,"Detected "||badcount||" bad archive(s): "||badarcnames)
if hastaboos="TRUE" then r=lineout(hisfile,"Is or has restricted file(s).")
if note<>"blank" then a=lineout(hisfile,note)
r = lineout(hisfile,stars)

a=stream(tempfil1,c,"close")
a=stream(tempfil2,c,"close")
a=stream(hisfile,c,"close")
a=stream(okmec,c,"close")
a=stream(badmec,c,"close")

if mode<>"L" then do
    meccap badmec           /* recompile the new user report file */
    meccap okmec
  end

cd maxdir
cleardir                       /* delete *.* from work directory */
erasedir                       /* delete work directory */
say "Upchek.cmd done."
exit

noparms:
say '' ''
say "Error:  Upchek.cmd received insufficient number of parameters."
usage:
say " "
say "Usage: upchek [path or ? or help] [filename] [.extension] /L"
say "        eg.  upchek ? - displays help"
say "        eg.  upchek d:\max\uncheck\ testfile .arj /L"
say "        Extension must be preceeded by a period."
say "        Path must end with a \."
say "        /L = local mode, required when run from command line."
say "  "
exit

arhand: procedure expose badcount scanaborted clean abnormal filnam fullnam mode tempfil1 tempfil2 arcount scanfiles taboos hastaboos badarcnames badmec

do until alldone="TRUE"        /* do until no more archives are found in the work directory */
 alldone="TRUE"                /* finding another archive makes alldone="FALSE" */
"dir /B /L > "||tempfil1      /* write a directory listing of the working directory to the tempfil1 */
 j=lines(tempfil1)              /* see if any files are in the directory */
 do while j<>0                /* while there are more files we haven't looked at */
  filnam=linein(tempfil1)      /* sniff the next file, determine archive type and build the dearchive command (burst) */


  instrg=charin(filnam,,5)    /* get a string from the file certain to have the ID bytes if there are any */
  a=stream(filnam,c,"close")  /* close the file and search the string for bytes indicating an archive we can handle */
  IF left(instrg,1)="`" & c2d(substr(instrg,2,1))=234 THEN  burst = "unarj e "||filnam
     ELSE if substr(instrg,3,3)="-lh" THEN burst = "lh x /io "||filnam
        ELSE IF left(instrg,2)="PK" & c2d(substr(instrg,3,1))=3 & c2d(substr(instrg,4,1))=4 THEN  burst = "unzip -joqq "||filnam
           ELSE IF c2d(left(instrg,1))=26 THEN burst = "arc2 xno "||filnam
              ELSE IF left(instrg,3)="ZOO" THEN burst = "zoo xq "||filnam
                 ELSE burst = ""       /* file is either not an archive or an archive format we don't know about */

  if burst<>"" then do                 /* need to dearchive */
       alldone="FALSE"                  /* make sure we sift the directory one more time */
       arcount = arcount+1
       burst
       if RC<>0 then do                     /* if error occurred while dearchiving */
           del filnam
           badcount=badcount+1
           badarcnames=badarcnames||filnam||" "
           if mode<>"L" then do          /* if not in local mode write to caller report */
               r=lineout(badmec," ")
               a=lineout(badmec,"[white]Unable to dearchive "||filnam||".")
               if filnam<>fullnam then do   /* if the bad archive is not the archive he uploaded */
                    a=lineout(badmec,filnam||" is an archive inside of "||fullnam||".")
                   end
               a=lineout(badmec,"Please examine your "||fullnam||".")
              end                           /* end if not local mode */
          end                               /* end of dearchiving error routine */

       else do                             /* no error occurred while dearchiving  */
         del filnam                        /* delete archive so it won't be found in the directory listing again */
         scanfiles                         /* call the scanner */
                                           /* check return code from scanner, RC=0 means no virus found */
         if RC=1 then clean="FALSE"
           else if RC=2 then scanaborted="TRUE"
             else if RC<0 | RC>4 then abnormal="TRUE"

         call restrict                        /* see if any restricted files in directory */
        end                                  /* end of else do no error occurred while dearchiving  */

               /* at end of directory listing yet? */
    end                                      /* need to dearchive */
    j=lines(tempfil1)
   end                                       /* do while j<>0, j=0=more files in dir list */
 a=stream(tempfil1,c,"close")
 end                                         /* do until alldone=TRUE */

return

restrict: procedure expose hastaboos tempfil2 taboos

"dir /B /L > "||tempfil2
/* say "Tempfil2 is:"
type tempfil2
pull usin */

do while lines(tempfil2)<>0
    filnam=translate(linein(tempfil2))
    charpos=lastpos(".",filnam)
    extension=substr(filnam,charpos+1)
    j=lastpos(extension,taboos)
    if j>0 then hastaboos="TRUE"
end                                 /* while lines(tempfil2)<>0 */
j=stream(tempfil2,c,"close")
"del "||tempfil2

return


