/* Virexx.cmd
   
    Rexx program for virus checking uploaded files for Maximus 2.01wb
              Doug Cullen  1:157/603.52@fidonet 12 Oct. 92

I wrote ViREXX for two reasons.  One, to try out REXX as a programming language. 
Two, I wanted an equivalent to ZIPLAB for MAX/2.  So how did it work out?  
ViREXX currently provides services equal to the last version of ZIPLABGEN I had
running.  BUT NO NIFTY screen for the user to watch. It appears that MAX/2 
doesn't pass the port handle when spawning VIRCHECK. On the positive side, that
means I don't have to bother with checking for carrier drops and users 
attempting to break out of the door.  So running ViREXX shouldn't create any 
security problems.        

FEATURES:
                1. Checks for valid archives by extracting all files
                2. Checks for nested archives down 2 levels.  Checks 
                   for all types of nested archives (i.e .zip file 
                   inside a .lzh file, etc...)
                3. Runs your virus scanner to check for virii.  I use
                   McAffees Scan for OS/2 beta.  It works here, your 
                   milage may differ 
                4. Checks dates of all files within archives. Can reject 
                   files older than SYSOP selectable date.
                5. Logs all actions to Virexx.log.  Can add minimal log
                   info to your Max.log (uses CBCS type log)
                6. Moves rejected files to a badfiles dir.  Enters error
                   message in files.bbs for rejected files.
                7. Informs user of file stats for accepted files via 
                   file_ok.bbs 
                8. Informs user of reason for rejections via file_bad.bbs
                9. <OPTIONAL> can strip and/or add comment to .zip files
               10. <OPTIONAL> can add file descriptions found in 
                   FILE_ID.DIZ or DESC.SDI to your files.bbs.  THIS IS A
                   KLUDGE all the way.  Since MAX limit descriptions to 
                   3 lines and most of these descriptions are longer, I 
                   use a slightly messy approach.  I add the first line
                   of the description to the fileentry and then add the
                   remainder to the lines as text below that.  This is a
                   pain when you try to hurl the file.  Also, Max doesn't
                   recognize that a description has been added to files.bbs
                   and prompts the user for a description.  So you get two
                   descriptions.  Neither of these is a real big problem 
                   for SYSOPS who sequester files from users until they 
                   have inspected them.  If you allow users immediate access
                   to new uploads it's probably best to disable this option.
               
                        
PRECAUTIONS
              
                1. Make sure all defined directories exist.  I can't predict 
                   what will happen if they don't ( but I got to use 
                   UNDELETE here) Slotted for fixing REAL-SOON-NOW
                2. There is not currently any support for GIF, FLI or the
                   like.  If you want them treated as ok then you need to 
                   make some changes.  The easiest if to add some more
                   extensions to the TEXT status line in Subroutine UnArchive.
                   Alternately you could add additonal when statements to the
                   select statement in the same place.



FUTURE ENHANCEMENTS (maybe, no promises here)
                 
                1. Abilty to convert archives ( i.e. .zip, .arc to .lzh)
                   and properly maintain files.bbs
                2. file database so users can see more info on each file
                   (filedate, date uploaded, size extracted, # of files
                   in archive, name of uploader)



WARRANTY and LIMITATIONS

                1. Ain't none.  I can assure you that ViREXX will take up
                   space on the storage media of your choice.  I can't 
                   guaranty that it won't cause mayhem on your system. 
                   It does work here on 2.01 beta and on 2.0 GA 
                2. You've got the source, if you don't like the way it 
                   works, change it! but do not distribute once modified.
                3. This is FreeWare, there is no charge and I assume no 
                   responsibility for nay damage it may do.  Have Fun.
                


ASSUMPTIONS (do it different and you'll probably have to re-code something)

                1. All the archivers can be found in one directory
                   defined as arcpath
                2. If your NOT using 4OS2 then be sure to change the 
                   don't ask entry to '/N'
                3. .ZIP files will be extracted with PKZIP 1.02 for
                   OS/2 or the family mode version
                4. .ARJ file will be extracted with Robert Jungs Unarj 
                   2.10
                5. .LZH files will be extracted with LH2 2.14
                6. .ARC files will be extracted with ARC2 6.00p
                7. Virus scanner will be McAfees SCAN for OS/2 beta 97
                8. Using exetweak to mark all the programs as windowable
                   to avoid the screen flashing 

*/
'@echo off'

/* -----  Set these variables for your System ------------------------- */

bbsname = 'The Point of Confusion'      /* Your BBS name                */
maxpath = 'd:\vrexx\'                   /* Path to Maximus              */
badfiledir = 'd:\max\badfile'           /* path to copy bad files to    */
testfiledir  = 'd:\max\filetest'       /* dir for testing              */
testfiledir2 = 'd:\max\filetes2 '      /* dir for nested archive test  */
miscpath = 'D:\MAX\MISC'                /* Path to misc *.bbs files     */
                                        /* NO FOLLOWING BACKSLASH       */
                                        /* Must be UPPER case !!!!      */
arcpath = 'c:\arctools'                 /* Path to archiver's           */
logname = 'd:\max\virexx.log'           /* Virexx Log                   */
dontask = '/Y'                          /* use /Y for 4OS2, /N for OS2  */
                                        /* turns off "delete *.*? (Y/N)"*/
mlog = 1                                /* set to 1 to add Virexx entry */
                                        /*  to Maxlog                   */
maxlog = '\max\max.log'                 /* path to max log file         */
logfile = '\max\virexx.log'             /* path and name of Virexx log  */
flagfile = '\max\scan.flg'              /* scanner flag file            */
oldest = 8001                           /* date for oldest file YYMM    */
                                        /* 8001 = jan 80 use 0000 to    */
                                        /* disable                      */
sdi='ON'                                /* enter FILE_ID.DIZ or         */
                                        /* DESC.SDI into files.bbs if   */
                                        /* found                        */
descblanks = 45

scancmd='scan_os2 d:\max\filetest\*.* d:\max\filetes2\*.* /a /d' 
                                        /* command line for your      */
                                        /* virus scanner                */
file_bad='d:\max\misc\file_bad.bbs'     /* path to bad file message     */
file_ok='d:\max\misc\file_ok.bbs'       /* path to good file message    */
zipcomment = 'ON'
commentfile = 'd:\os2\comment.fil'      /* bbs add file for zip comment */
dbase = 1
database = 'd:\max\filedata.fil'        /* database of additional file info */
userfile='d:\max\lastus01.bbs'          /* name of lastuser file        */
/* -------------------------------------------------------------------- */

/* ------------- Main Program ------------------------- */

parse upper arg path file ext dummy  /* grab file name, convert to uppercase */
   call initialize                   /* initialize program                   */
   call unarchive                    /* unarchive file to test directory     */
                                     /* test for valid archive               */
if status = GOOD | status = EXE then do
     if oldest <> 0000 then call checkdate      /* check for old files       */
                                                /* unless turned off         */
     if sdi = 'ON' then call checkdesc  /* check for file descriptions       */
                                        /* packed inside archive             */
     call scanner                   /* scan for virii if the file unpacks OK */
     end /* do */                    

call filestats
call sendmsg                              /* send appropriate msg to user   */
if dbase then call databaseout                 /* add fileinfo to data base      */
if zipcomment = ON & ext = .ZIP then do
     if status = GOOD then do                
       'pkzip -z ' fullname '< 'commentfile
       end /* do */
     end /* do */
call cleanupdir                  /* clean up test directory               */
cleanup:
say 'cleaning up ViREXX'
call RxFuncDrop 'SysFileTree'
exit

/* ------------ end -  main program ------------------ */

/*     Possible Status Values

        GOOD     = No problems
        BAD      = Failed to Unarchive 
        INFECTED = Failed Virus Scan 
        UNKNOWN  = File extension was not of any type defined
        EXE      = File was .exe or .com (I treat these with a great 
                    deal of suspicion! )
        TEXT     = .ext was .txt, .doc, .prn, .bat, or .cmd
        NOEXT    = file had no extension i.e. 'filename.'
        OLD      = archive contained files older than oldest date               
*/

/* ----- Subroutine Initialize ----------------------- */
initialize:
 if ext = '' then call USAGE
 filename=file||ext                              /* file name                 */
 fullname=path||file||ext                        /* full pathname to file     */
 del testfiledir dontask                      /* cleanup test dir          */
 del testfiledir2 dontask                     /* cleanup 2nd test dir      */
 parse value DATE('N') with dd mmm yyyy      /* dd   = day
                                                mmm  = month
                                                yyyy = year          */
 if dd = 1 then dd =01
 if dd = 2 then dd =02
 if dd = 3 then dd =03
 if dd = 4 then dd =04
 if dd = 5 then dd =05
 if dd = 6 then dd =06
 if dd = 7 then dd =07
 if dd = 8 then dd =08
 if dd = 9 then dd =09
 archsize = 0
 logdate = ' 'dd' 'mmm' 'TIME()' VIRX'
 uldate = dd'-'mmm'-'yyyy
 logentry = '+'logdate' checking 'filename    /* build up log entry          */
 call LINEOUT logfile,logentry                /* and write log entry         */  
 nested = NO                                  /* clear nested                */
 
   if RxFuncQuery('SysFileTree') then
        Call RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree' 
        CAll RxFuncAdd 'SysMkDir','RexxUtil','SysMkDir'
                                              /* make sure Rexxutils loaded */
 /* get user name from lastuser file */
 tempname=STRIP(CHARIN(userfile,1,36),,'00'x)
 username=tempname
 if \(SUBWORD(tempname,3,1)='') then
   username=SUBWORD(tempname,1,1)' 'SUBWORD(tempname,2,1)SUBWORD(tempname,3,1)
/* check that dirs exist - if not make them */
call SysFileTree testfiledir,'dir','DO'
 if dir.0 = 0 then call SysMkDir testfiledir
call SysFileTree testfiledir2,'dir','DO'
 if dir.0 = 0 then call SysMkDir testfiledir2
call SysFileTree badfiledir,'dir','DO'
 if if dir.0 = 0 then call SysMkDir badfiledir

return

/* ----- End - Initialize ---------------------------- */

/* ----- Subroutine Unarchive ------------------------ */

unarchive:
 ffname = fullname
 fname = filename
 testdir = testfiledir
 Select
   when ext = .ZIP then  call unzip
   when ext = .ARJ then  call unarj
   when ext = .LZH then  call unlzh 
   when ext = .ARC then  call unarc
   when ext =  miscpath then do                 /* file had no extension  */
       move fullname badfiledir                 /* move to badfile dir    */
       status = NOEXT
       end   /* do */
   when ext = .TXT | ext = .DOC | ext = .PRN then status = TEXT
   when ext = .EXE | ext = .COM then do 
     status = 'EXE'
     copy fullname testfiledir
     move fullname badfiledir
     end /* do */
   otherwise 
     status = 'UNKNOWN'
     move fullname badfiledir
 end  /* select */
if status = BAD then do
        move fullname badfiledir
        return
        end /* do */

if status = GOOD then call checknested

return

/* ----------- End - unarchive -----------------------------*/

/* ------- look for description files ---------------------- */
/* ------- (FILE_ID.DIZ or DESC.SDI)inside archive --------- */

checkdesc:
fileinfo = 'd:\max\filetest\file_id.diz'
if stream(fileinfo,'c','query exist') <> '' then do 
   i = 0
   do until lines(fileinfo)=0
     i = i + 1
     mytext.i = LINEIN(fileinfo)
     mytext.1 = STRIP(mytext.i)
     bbsfile = path||files.bbs
     if i = 1 then call LINEOUT bbsfile,filename' 'mytext.i
     else call LINEOUT bbsfile,COPIES(' ',descblanks)||mytext.i
     desc = DONE
     end /* do */
  fstat=stream(fileinfo,'c','close')
  end /* do */
  if desc <> DONE then do
  fileinfo = 'd:\max\filetest\desc.sdi'
  if stream(fileinfo,'c','query exist') <> ''then do 
    i = 0
    do until lines(fileinfo)=0
       i = i + 1
       mytext.i = LINEIN(fileinfo)
       mytext.i = STRIP(mytext.i)
       bbsfile = path||files.bbs
       if i = 1 then call LINEOUT bbsfile,filename' 'mytext.i
       else call LINEOUT bbsfile,COPIES(' ',descblanks)||mytext.i
    end /* do */
    fstat=stream(fileinfo,'c','close')
   end /* do */
end 
return
/* ------ end of checkdesc ------------- */

/* - Run McAffees Scan on testfiledir - */

scanner:
  scancmd
  if rc>1 then status = ERROR
  if rc=1 then status = INFECTED
  if rc=0 & status= GOOD then status = GOOD
  if rc=0 & status= EXE then status = EXE
return
/* ----------end --  scanner ------------- */

/* -  clean up testfile dir when we're done - */

cleanupdir:
   del testfiledir dontask                     /* cleanup test dir      */
   del testfiledir2 dontask
return
/* ------- end -- cleanupdir ---------------- */  

/*  ----------- Subroutine SendMsg --------------------------- */
/*  enter appropriate messages to log(s) and bbs user          */

sendmsg:
   fileentry =''
   select 
    when status = BAD then do
        logentry = '!'logdate filename' failed extract - moved to badfiles'
        fileentry =  filename" failed to extract from archive - uploaded by: "username
        end /* do */
    when status = EXE then do
        logentry = '!'logdate filename' suspicious  - moved to badfiles'
        fileentry = filename" exec, moved to prevent trojan, virii ...-uploaded by: "username
        end /* do */
    when status = TEXT then logentry = '+'logdate filename' ok - credit given (TEXT file)'
    when status = UNKNOWN then do 
        logentry = '!'logdate filename' UNKNOWN type - moved to badfiles'
        fileentry = filename" of unknown type, moved - uploaded by: "username
        end /* do */
    when status = INFECTED then do
        logentry = '!'logdate filename' INFECTED!!! - moved to badfiles'
        fileentry = filename" INFECTED - triggered scanner -uploaded by: "username
        end /* do */
    when status = GOOD then logentry = '+'logdate filename' OK credit given' 
    when status = NOEXT then do
        logentry = '!'logdate filename' had no .ext - moved to badfiles'
        fileentry = filename" had no extension, moved - uploaded by:"username
        end /* do */
    when status = OLD then do
        logentry = '!'logdate filename' was too old - moved to badfiles'
        fileentry = filename" was older than allowed - uploaded by: "username
        end /* do */
  otherwise do
        logentry = '!'logdate' ERROR running ViREXX'
        fileentry = filename "ERROR running ViREXX"
        end /* do */
end /* select */

call LINEOUT logfile,logentry                /* write entry to Virexx log   */
if status = GOOD then do
     call LINEOUT logfile,'                       Filesize: 'fsize' bytes, dated: 'fildate
     call LINEOUT logfile,'                       'numfiles' files, Newest: 'newdate' - Oldest: 'olddate
     call LINEOUT logfile,'                       Uploaded by: 'username
     end /* do */
if Mlog then call LINEOUT maxlog,logentry    /* write to Max log if enabled */

if status \= GOOD then do 
   if status \= TEXT then do 
     badfilebbs=badfiledir'\files.bbs'
     call LINEOUT badfilebbs,fileentry
     fstat= stream(badfilebbs,'c','close')
   end /* do */
end /* do */

call tokens                         /* load mecca tokens for .bbs output  */
call bbsmsg                         /* write file_ok.bbs or file_bad.bbs  */ 
return


/* ----- check date - move to badfilesarchive if it contains ----- */
/* ----- files older than oldest ----------------------------------*/

checkdate:
datelist=''
SrchFile = testfiledir'\*.*'
call SysFileTree SrchFile,'files','FO'
do i = 1 to files.0
   filedate=stream(files.i,'c','query datetime')
   parse value filedate with cm'-'cd'-'cy hours
   testdate  = cy||cm
   if i = 1 then do
     oldestfile = testdate
     newestfile = testdate
     end /* do */
   if i \= 1 then do
     if testdate>newestfile then newestfile=testdate
     if testdate<oldestfile then oldestfile=testdate
     end /* do */
   if testdate<oldest then do 
      status = OLD
      move fullname badfiledir
   end /* do */
end  /* do */
SrchFile = testfiledir2'\*.*'
call SysFileTree SrchFile,'files','FO'
do i = 1 to files.0
   filedate=stream(files.i,'c','query datetime')
   parse value filedate with cm '-' cd '-' cy hours
   testdate  = cy||cm
   if testdate>newestfile then newestfile=testdate
   if testdate<oldestfile then oldestfile=testdate
   if testdate<oldest then do 
      status = OLD
      move fullname badfiledir
   end /* do */
end  /* do */
return   /* checkdate */

/* ----- end -- checkdate ---- */

/* ------ Unzip - run pkunzip on filename ------- */
unzip:
     /* written for PKUNZIP  (I use the family mode version 1.02)           */

     pkunzip ffname testdir           /* unzip file to testdir */
     if RC = 0 then do                             /* unzipped OK           */
       status = 'GOOD'
   end
   else do                                       /* failed to unzip       */
       status = 'BAD'
     end  /* do */
   return  

/* end unzip */

/* ---------  unarj -- run unarj on filename --------------- */
unarj:
     /* written for Robert Jung's Unarj 2.10                                */
     /* this section will copy the file to the test file dir and also copy  */
     /* unarj to the same directory, run unarj and cleanup afterwards. If   */
     /* your test dir is on a different drive be sure to fix this section   */

     copy ffname testdir                          /* copy file to test dir  */
     copy arcpath'\unarj.exe' testdir
     cd testdir
     unarj e fname                                     /* unarj file        */
     if RC = 0 then do                                 /* unarjed OK       */
       status = 'GOOD'
       del fname
       del unarj.exe

     end
     else do          
       status = 'BAD'                              /* failed to unarj   */
     end  /* do */
   cd maxpath
   return

/* end unarj */

/* ----------- unlzh -- unlzh filename ----------- */
         
unlzh:
     /* written for LH2  2.14    */
     lh2 x ffname testdir                          /* unlzh file to testdir */
     if RC = 0 then do                             /* unlzh'd OK           */
       status = 'GOOD'
     end
     else do                                       /* failed to unlzh       */
       status = 'BAD'
     end  /* do */
   return

/* end unlzh */

/* ----- unarc -- unarc filename using ARC2 ---- */

unarc:
     /* written for ARC2 6.00p                                              */
     /* this section will copy the file to the test file dir and also copy  */
     /* arc2 to the same directory, run arc2 and cleanup afterwards. If     */
     /* your test dir is on a different drive be sure to fix this section   */

     copy ffname testdir                          /* copy file to test dir  */
     copy arcpath'\arc2.exe' testdir
     cd testdir
     arc2 e fname                                      /* unarc file        */
     if RC = 0 then do                                 /* unarced OK        */
       status = 'GOOD'
       del fname
       del 'arc2.exe'
     end
     else do                                          /* failed to unarc   */
       status = 'BAD'
     end  /* do */
    cd maxpath
   return

/* end unarc  */

/* ---- checknested -- look for nested archives ------ */ 

checknested:

testdir = testfiledir2              /* search 1st level for archives        */
call searchnest
  if nested = YES then do         /* check for 2nd level of nested archives */
    testdir = testfiledir
    testfiledir = testfiledir2
    call searchnest
    testfiledir = testdir
    end /* do */
return /* checknested */

  /*     searchnest -- does the actual searching for files with   */
  /*     archive type extensions                                  */

searchnest:
   SrchFile = testfiledir'\*.zip'             /* look for .zip files       */
     call SysFileTree SrchFile,'files','FO'
       if file.0 >> 0 then do i = 1 to files.0
         ffname = files.i
         fname = FILESPEC("name",ffname)
         call unzip
         del ffname
         nested = YES
       end /* do */

   SrchFile = testfiledir'\*.arc'           /* look for .arc files         */
     call SysFileTree SrchFile,'files','FO'
       if file.0 >> 0 then do i = 1 to files.0
         ffname = files.i
         fname = FILESPEC("name",ffname)
         call unarc
         del ffname
        nested = YES
       end /* do */

   SrchFile = testfiledir'\*.arj'           /* look for .arj files          */
     call SysFileTree SrchFile,'files','FO'
       if file.0 >> 0 then do i = 1 to files.0
         ffname = files.i
         fname = FILESPEC("name",ffname)
         call unarj
         del ffname
        nested = YES
       end /* do */

   SrchFile = testfiledir'\*.lzh'          /* look for .lzh files           */
     call SysFileTree SrchFile,'files','FO'
       if file.0 >> 0 then do i = 1 to files.0
         ffname = files.i
         fname = FILESPEC("name",ffname)
         call unlzh
        nested = YES
       end /* do */

return

/* --- end checknested ---------- */
tokens:
cls=''
firstname=''
blue=''
lightblue=''
cyan=''
lightcyan=''
green=''
lightgreen=''
brown=''
yellow=''
grey=''
gray=''
white=''
red=''
lightred=''
magenta=''
lightmagenta=''
blink=''
steady=''
enter=''
return



bbsmsg:     

do i = 7 to 25    /* clear msg */
  msg.i = ''
end /* do */

 msg.1=cls   
 msg.2="      "blue"ͻ"
 msg.3="      "blue"             "lightcyan"ViREXX "yellow"Scan Report                  "blue"" 
 msg.4="      "blue"Ķ"
 msg.5="      "blue"  "lightcyan"ViREXX "yellow"Archive verifier/Virus Checker "white"[beta]   "blue""
 msg.6="      "blue" "lightcyan"(c) Doug Cullen, 1992 "blue"ͼ"

select
   when status = GOOD | status = TEXT then do
   file_out = file_ok

   msg.8=green"  ͸"
   msg.9=green"  "lightcyan" FileName: "yellow||CENTER(filename,14)||green" "lightcyan"Dated :"yellow||fildate"              "green""
  msg.10=green"  Ĵ"
  msg.11=green"   "lightcyan"FileSize:"yellow||CENTER(filesize,8)"bytes  "green" "lightcyan"Extracted Size: "yellow||CENTER(archsize,8)"bytes"green""
  msg.12=green"  Ĵ"
  msg.13=green"   "lightcyan"Archive contains: "yellow||CENTER(numfiles,3)" files                            "green""
  msg.14=green"  Ĵ"
  msg.15=green"   "lightcyan"Oldest file :"yellow||CENTER(olddate,8)"   "green" "lightcyan"Newest file :"yellow||CENTER(newdate,8)"        "green""
  msg.16=green"  ;"
  msg.18=lightcyan "Thanks for the upload, 'firstname' Everything checks out OK"
  msg.20=lightcyan "Full credit given for your upload"grey

   end /* GOOD */

  when status = BAD then do
   file_out = file_bad
   msg.7=""
   msg.8="     "lightcyan"ViREXX "yellow"has scanned your file:"white filename       
  msg.10="     "yellow"and was unable to extract any files from the archive"
  msg.12="     "yellow"You may want to check your file for errors. (Please "lightred"DONT "yellow"use"
  msg.14="     "yellow"PKZIP 1.93a)   You won't receive any credit for the file at"
  msg.16="     "yellow"this time, but the file has been moved for SYSOP inspection"grey
  msg.18=enter
   end /* BAD */

  when status = INFECTED then do
   file_out = file_bad
   msg.7=""
   msg.8="     "blink red"WARNING "white"WARNING "red"WARNING "white"WARNING - "steady yellow"Your file :"white filename
  msg.10="     "yellow"has caused a "red"VIRUS "yellow"warning from our system.  You won't"
  msg.12="     "yellow"receive any credit for you upload at this time, but the"
  msg.14="     "yellow"file has been moved for SYSOP inspection."grey
  msg.16=""
  msg.18=enter
   end /* infected */

  when status = UNKNOWN then do
   file_out = file_bad
   msg.7=""
   msg.8="     "lightcyan"ViREXX "yellow"was unsure what to do with your file:"white filename
  msg.10="     "yellow"since it was not one of the kind we accept.  Please"
  msg.12="     "yellow"limit your uploads to .ZIP, .ARC, .ARJ or .LZH files."
  msg.14="     "yellow"You won't recieve any credit for your upload at this" 
  msg.16="     "yellow"time, but the file has been moved for SYSOP inspection"grey
  msg.18=enter
  end /* UNKNOWN */

  when status = EXE then do
   file_out = file_bad
   msg.7=""
   msg.8="     "lightcyan"ViREXX "yellow"has moved your file:"white filename yellow"for "white"SYSOP "yellow"inspection."
  msg.10="     "yellow"Since "lightgreen"virii "yellow"are most often transmitted by "lightred".exe "yellow"and "lightred".com "
  msg.12="     "yellow"files, they are treated as possible infections. Please limit "
  msg.14="     "yellow"future uploads to .ZIP .ARC .ARJ or .LZH files and Thanks"
  msg.16="     "yellow"for supporting"lightmagenta bbsname grey
  msg.18=enter
   end /* EXE */

  when status = NOEXT then do
   file_out = file_bad
   msg.7=""
   msg.8="     "lightcyan"ViREXX "yellow"was unsure what to do with your file: "file
  msg.10="     "yellow"since it had no file extension.  Please limit your"
  msg.12="     "yellow"uploads to "lightgreen".ZIP, .ARC, .ARJ "yellow"or "lightgreen".LZH "yellow"files.  You won't"
  msg.14="     "yellow"recieve any credit for your upload at this time, but" 
  msg.16="     "yellow"the file has been moved for "white"SYSOP "yellow"inspection"grey
  msg.18=enter
   end /* NOEXT */

  when status = OLD then do
   file_out = file_bad
   msg.7=""
   msg.8="     "lightcyan"ViREXX "yellow"has found that some of the files in "filename
  msg.10="     "yellow"are older than we normally accept.  Sorry, but you"
  msg.12="     "yellow"won't receive credit for your upload.  The file has"
  msg.14="     "yellow"been moved for SYSOP inspection"
  msg.18="     "grey
  msg.20=enter
   end /* OLD */

otherwise
  nop
end /* select */


del file_out

do i = 1 to 20
   call LINEOUT file_out,msg.i
   end /* do */

fstat=stream(file_out,'C','close')

return

filestats:
numfiles=0
oldmonth = ''
oldyear  = ''
newyear = ''
newmonth= ''
SrchFile = fullname
filesize = stream(SrchFile,'c','query size')
fdate=stream(SrchFile,'c','query datetime')
parse value fdate with fm'-'fd'-'fy  hours
select 
  when fm = '01' then fildate = fd'-Jan-'fy
  when fm = '02' then fildate = fd'-Feb-'fy
  when fm = '03' then fildate = fd'-Mar-'fy
  when fm = '04' then fildate = fd'-Apr-'fy
  when fm = '05' then fildate = fd'-May-'fy
  when fm = '06' then fildate = fd'-Jun-'fy
  when fm = '07' then fildate = fd'-Jul-'fy
  when fm = '08' then fildate = fd'-Aug-'fy
  when fm = '09' then fildate = fd'-Sep-'fy
  when fm = '10' then fildate = fd'-Oct-'fy
  when fm = '11' then fildate = fd'-Nov-'fy
  otherwise fildate = fd'-Dec-'fy
  end /* select*/
SrchFile = testfiledir'\*.*'
call SysFileTree SrchFile,'files','FO'
do i = 1 to files.0
   fsize=stream(files.i,'c','query size')
   archsize=archsize+fsize
   numfiles=numfiles+1
end /* do */
SrchFile = testfiledir2'\*.*'
call SysFileTree SrchFile,'files','FO'
do i = 1 to files.0
   fsize=stream(files.i,'c','query size')
   archsize=archsize+fsize
   numfiles=numfiles+1
end /* do */
oldmonth =SUBSTR(oldestfile,3,2)
oldyear =SUBSTR(oldestfile,1,2)
newyear =SUBSTR(newestfile,1,2)
newmonth=SUBSTR(newestfile,3,2)
select 
 when oldmonth = 01 then oldmonth = 'Jan'
 when oldmonth = 02 then oldmonth = 'Feb'
 when oldmonth = 03 then oldmonth = 'Mar'
 when oldmonth = 04 then oldmonth = 'Apr'
 when oldmonth = 05 then oldmonth = 'May'
 when oldmonth = 06 then oldmonth = 'Jun'
 when oldmonth = 07 then oldmonth = 'Jul'
 when oldmonth = 08 then oldmonth = 'Aug'
 when oldmonth = 09 then oldmonth = 'Sep'
 when oldmonth = 010 then oldmonth = 'Oct'
 when oldmonth = 011 then oldmonth = 'Nov'
otherwise oldmonth = 'Dec'
end /* select */
select 
 when newmonth = 01 then newmonth = 'Jan'
 when newmonth = 02 then newmonth = 'Feb'
 when newmonth = 03 then newmonth = 'Mar'
 when newmonth = 04 then newmonth = 'Apr'
 when newmonth = 05 then newmonth = 'May'
 when newmonth = 06 then newmonth = 'Jun'
 when newmonth = 07 then newmonth = 'Jul'
 when newmonth = 08 then newmonth = 'Aug'
 when newmonth = 09 then newmonth = 'Sep'
 when newmonth = 010 then newmonth = 'Oct'
 when newmonth = 011 then newmonth = 'Nov'
otherwise newmonth = 'Dec'
end /* select */
olddate=oldmonth'-'oldyear
newdate=newmonth'-'newyear
return

databaseout:
databaseentry=filename','fildate','uldate','filesize','archsize','numfiles','olddate','newdate','username
call LINEOUT database,databaseentry
return

USAGE:
say ' '
say ' ViREXX.CMD - Maximus File Integrety Tester written in REXX '
say ' '
say ' USAGE: Virexx d:\path\ filename .ext d:\max\misc '
say ' '
say ' d:\path\   = path to file to be checked INCLUDING trailing \'
say ' '
say ' filename   = the name of the file with no path or extension'
say ' '
say ' .ext       = the file extension including the . '
say ' '
say 'd:\max\misc =  path to MAXIMUS misc dir withOUT trailing \'
say ' '
say ' This is the form in which max passes the parameters '
signal CLEANUP
return
