/*
 *	BBSPLAN.EXE  - Source code released into public domain.
 *
 *	Make a plan report for WILDCAT 3.55
 *
 *	Provides a list of file areas and message confernces.
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <mem.h>

/******************************************************************************/
/*  Here are the internal option switches for this program.                   */
/******************************************************************************/
char	fdata = 'Y' ;		/* Do you want FILE library listing ?         Y/N */
char	cdata = 'Y' ;		/* Do you want CONFERENCE listing ?           Y/N */
char    hdata = 'N' ;		/* Do you want to display hidden data?        Y/N */
char	fullconf = 'N' ;	/* Do you want the full conference display ?  Y/N */
char	fullfile = 'N' ;	/* Do you want all of the library directorys? Y/N */
/******************************************************************************/



FILE * sourcefile ;
FILE * reportfile ;

struct CONFDATA
{
	char namelength ;
	char name[25];
	char confoplength;
	char confop[25];
	int  mailtype ;
	char fa_length ;
	char filearea[124];
	char bull_len ;
	char bullpath[67];
	char ques_len ;
	char quespath[67];
	char menu_len ;
	char menupath[67];
	char help_len;
	char helppath[67];
	char disp_len;
	char disppath[67];
	char msg_len ;
	char msgpath[67];
	unsigned char lines ;
	int  flags;
	int  number;
	int  questions;
	int  bull;
	char nametype ;
	char reserved ;
	unsigned maxmsg ;
} ;

struct FILEAREA
{
	char namelength ;
	char name[30] ;
	char dirlen1 ;
	char directory1[53] ;
	char dirlen2 ;
	char directory2[53] ;
	char dirlen3 ;
	char directory3[53] ;
	char dirlen4 ;
	char directory4[53] ;
	char dirlen5 ;
	char directory5[53] ;
} ;

int    recordcount = 0 ;

struct FILEAREA filerec ;
struct CONFDATA confrec ;

char workstring1[68];

char workstring2[68];


void writeconfareas( void )
{
	sourcefile = fopen( "CONFDESC.DAT", "rb" );
	if( sourcefile == NULL )
	{
		printf( "Unable to open CONFDESC.DAT for reading.\n" );
		exit(1);
	};

	fseek(sourcefile, SEEK_SET, 0);

	fprintf( reportfile, "Conference listing.\n\nConf   Name                             Directory\n====   =============================    ==============================\n" ) ;

	recordcount = 0 ;

	while(feof( sourcefile ) == 0)
	{
		/* read the data and display it */
		if(	(fread(&confrec, sizeof(CONFDATA), 1, sourcefile) == 1) &&
			(feof( sourcefile ) == 0) )
			if(confrec.namelength != 0 )
			{
				memset( workstring1, ' ', 67 );
				workstring1[27] = '\0' ;
				memcpy( workstring1, confrec.name, confrec.namelength );

				memset( workstring2, '\0', 67 );
				workstring2[67] = '\0' ;
				memcpy( workstring2, confrec.menupath, confrec.menu_len );

				fprintf( reportfile, "%4d   %16s       MENU: %s\n", confrec.number, workstring1, workstring2) ;

				if(fullconf== 'Y')
				{
					memset( workstring1, '\0', 67 );
					memcpy( workstring1, confrec.bullpath, confrec.bull_len );
					fprintf( reportfile, "                                    %3d  BULL: %s\n", confrec.bull, workstring1);

					memset( workstring1, '\0', 67 );
					memcpy( workstring1, confrec.quespath, confrec.ques_len );
					fprintf( reportfile, "                                    %3d  QUES: %s\n", confrec.questions, workstring1);

					memset( workstring1, '\0', 67 );
					memcpy( workstring1, confrec.helppath, confrec.help_len );
					fprintf( reportfile, "                                         HELP: %s\n", workstring1);

					memset( workstring1, '\0', 67 );
					memcpy( workstring1, confrec.msgpath, confrec.msg_len );
					fprintf( reportfile, "                                 %6d  MSG:  %s\n", confrec.maxmsg, workstring1);

					fprintf( reportfile, "----   -----------------------------    ------------------------------\n" ) ;

				};

			};
	};
	fclose(sourcefile);
};

void writefileareas( void )
{
	sourcefile = fopen( "FILEAREA.DAT", "rb" );
	if( sourcefile == NULL )
	{
		printf( "Unable to open FILEAREA.DAT for reading.\n" );
		exit(1);
	};

	fseek(sourcefile, SEEK_SET, 0);

	fprintf( reportfile, "File Library Configuration Listing\n\nAREA   Name                             Directory\n====   =============================    ==============================\n" ) ;

	recordcount = 0 ;

	while(feof( sourcefile ) == 0)
	{
		recordcount++ ;

		/* read the data and display it */
		if(	(fread(&filerec, 303, 1, sourcefile) == 1) &&
			(filerec.name[0] != '\0' ) &&
			(feof( sourcefile ) == 0) )
		{
			memset( workstring1, ' ', 67 );
			workstring1[32] = '\0' ;
			if(filerec.namelength != 0 )

			memset( workstring2, '\0', 67 );
			if(filerec.namelength != 0 )
			{
				memcpy( workstring1, filerec.name, filerec.namelength );
				memcpy( workstring2, filerec.directory1, filerec.dirlen1 );
				fprintf( reportfile, "%4d   %32s %s\n", recordcount, workstring1, workstring2 );
			}
			else if(hdata=='Y' )
			{
				memcpy( workstring1, filerec.name, 31 );
				fprintf( reportfile, "(%3d)- %32s %s\n", recordcount, workstring1, filerec.directory1 );
			};

			if( (fullfile == 'Y') &&
				(	(filerec.namelength !=0) || (hdata=='Y')) )
			{
				memset( workstring2, '\0', 67 );
				if( filerec.dirlen2 > 0 ) memcpy( workstring2, filerec.directory2, filerec.dirlen2 );
				if( filerec.dirlen2 > 0 ) fprintf( reportfile, "                      %s\n", workstring2 );

				memset( workstring2, '\0', 67 );
				if( filerec.dirlen3 > 0 ) memcpy( workstring2, filerec.directory3, filerec.dirlen3 );
				if( filerec.dirlen3 > 0 ) fprintf( reportfile, "                      %s\n", workstring2 );

				memset( workstring2, '\0', 67 );
				if( filerec.dirlen4 > 0 ) memcpy( workstring2, filerec.directory4, filerec.dirlen4 );
				if( filerec.dirlen4 > 0 ) fprintf( reportfile, "                      %s\n", workstring2 );

				memset( workstring2, '\0', 67 );
				if( filerec.dirlen5 > 0 ) memcpy( workstring2, filerec.directory5, filerec.dirlen5 );
				if( filerec.dirlen5 > 0 ) fprintf( reportfile, "                      %s\n", workstring2 );

				fprintf( reportfile, "----   -----------------------------    ------------------------------\n" ) ;
			};
		};
	};
	fclose(sourcefile);
}

void main( void )
{
	printf("BBSPLAN - Version 1.00.a\nA utility to display WILDCAT conference configurations.\n");


	reportfile = fopen( "bbsplan.txt" , "wt" );
	if( reportfile == NULL )
	{
		printf( "Unable to open BBSPLAN.TXT for writing.\n" );
		exit(2);
	};

	if(cdata=='Y') writeconfareas() ;

	if(fdata=='Y' && cdata=='Y') fprintf( reportfile, "\014\n" );

	if(fdata=='Y') writefileareas() ;

	fclose(reportfile);
}