Unit AdoptIns;
{========================================================================}
Interface
  Procedure AdoptAbandon(Display : Byte);
  Procedure AdoptAllOrphans;
  Procedure InsertBlank(BeforeOrAfter : Char);
{========================================================================}
Implementation
  Uses
    Display, MfmDefs, MfmStr;
{========================================================================}
Procedure AdoptAbandon(Display : Byte);
  Begin
    Altered := True;
    Case CurrentEntry^.TypeOfRecord Of
      Orphan :
      Begin
        CurrentEntry^.TypeOfRecord := FileRecord;
        NextPrintEntry := CurrentEntry;
        If Display = 1 Then
        Begin
          DisplayRecord(Row); DisplayCurrentLocation;
        End;
      End;
      FileRecord :
      Begin
        CurrentEntry^.TypeOfRecord := Orphan;
        NextPrintEntry := CurrentEntry;
        DisplayRecord(Row); DisplayCurrentLocation;
      End;
      Comment :
      Begin
        CurrentEntry^.TypeOfRecord := Offline;
        CurrentEntry^.Description := AllTrim(CurrentEntry^.Description);
        CurrentEntry^.FileName := Copy(CurrentEntry^.Description,1,Pos(' ',CurrentEntry^.Description)-1);
        CurrentEntry^.Description := Copy(CurrentEntry^.Description,Pos(' ',CurrentEntry^.Description)+1,79);
        NextPrintEntry := CurrentEntry;
        DisplayRecord(Row); DisplayCurrentLocation;
      End;
      Offline :
      Begin
        CurrentEntry^.TypeOfRecord := Comment;
        CurrentEntry^.Description := CurrentEntry^.FileName+' '+CurrentEntry^.Description;
        CurrentEntry^.FileName := '';
        NextPrintEntry := CurrentEntry;
        DisplayRecord(Row); DisplayCurrentLocation;
      End;
    End;
  End;
{========================================================================}
Procedure AdoptAllOrphans;
  Begin
    OldEntry := CurrentEntry;
    CurrentEntry := FirstEntry;
    Repeat
      If (CurrentEntry^.FileName <> 'FILES.BBS') And
         (CurrentEntry^.FileName <> 'FILES.BAK') And
         (CurrentEntry^.TypeOfRecord = Orphan) Then AdoptAbandon(0);
      CurrentEntry := CurrentEntry^.NextEntry;
    Until CurrentEntry = NIL;
    CurrentEntry := OldEntry;
    DisplayScreen;
  End;
{========================================================================}
Procedure InsertBlank(BeforeOrAfter : Char);
  Begin
    If MaxAvail > SizeOf(ListRecord) Then
    Begin
      Altered := True;
      New(NewEntry);
      If BeforeOrAfter = 'B' Then
      Begin
        NewEntry^.PrevEntry := CurrentEntry^.PrevEntry;
        NewEntry^.NextEntry := CurrentEntry;
        CurrentEntry^.PrevEntry^.NextEntry := NewEntry;
        CurrentEntry^.PrevEntry := NewEntry;
        If CurrentEntry = TopEntry Then TopEntry := NewEntry;
        If CurrentEntry = FirstEntry Then FirstEntry := NewEntry;
      End
      Else
      Begin
        NewEntry^.PrevEntry := CurrentEntry;
        NewEntry^.NextEntry := CurrentEntry^.NextEntry;
        CurrentEntry^.NextEntry^.PrevEntry := NewEntry;
        CurrentEntry^.NextEntry := NewEntry;
      End;
      CurrentEntry := NewEntry;
      CurrentEntry^.TypeOfRecord := Comment;
      CurrentEntry^.Description := ' ';
      CurrentEntry^.FileSize := 0;
      CurrentEntry^.Tagged := False;
      If BeforeOrAfter = 'A' Then CurrentEntry := CurrentEntry^.PrevEntry;
      Inc(NumberOfEntries);
      DisplayScreen;
    End;
  End;
{========================================================================}
Begin
End.
{========================================================================}
