PROGRAM ExtractDescs;
USES Dos;
CONST
     ProgData = 'XDESC- Free DOS utility: PCBoard filelist multi-line description extractor.';
     ProgDat2 = 'V1.00: July 14, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';

     Usage = 'Usage: XDESC [/v | /q] <filename.ext to scan for> [file(s) to scan]';
VAR
   IsList,
   Verbose, Quiet      : Boolean;
   TextToScanFor,
   FilesToScan,
   FileSeeking         : String;

   List_File           : Text;

procedure showhelp;
begin
   writeln;
   Writeln(ProgData);
   Writeln(ProgDat2);
   Writeln;
   writeln(usage);
   halt;
end;

FUNCTION ConvertToUpper(w : String) : String;
VAR
   cp  : Integer;        {The position of the character to change.}
BEGIN
     FOR cp := 1 TO Length(w) DO
         w[cp] := UpCase(w[cp]);
     ConvertToUpper := w;
END;

PROCEDURE GetCmdLnParms(VAR Verb, Q : Boolean; VAR ScanText, Files : String);
BEGIN
     IF ((ParamStr(1) = '/v') OR (ParamStr(1) = '/q')) THEN
     BEGIN
         IF (ParamStr(1) = '/v') THEN
         BEGIN
            Verb := True;
            Q := False;
            ScanText := ParamStr(2);
            Files := ParamStr(3);
         END
         ELSE IF (ParamStr(1) = '/q') THEN
         BEGIN
            Verb := False;
            Q := True;
            ScanText := ParamStr(2);
            Files := ParamStr(3);
         END;
     END
     ELSE BEGIN
        Verb := False;
        Q := False;
        ScanText := ParamStr(1);
        Files := ParamStr(2);
     END;

     IF (ScanText = '') THEN      {Quit with help if no arguments.}
         showhelp;

     IF (Files = '') THEN        {  If Files is undefined, }
         Files := '*.*';         {     scan all files.     }
END;

FUNCTION IsFile ( filespec : string ) : boolean;
VAR   IFDirInfo : SearchRec;
BEGIN
     FindFirst(filespec, Archive, IFDirInfo);
     IsFile := (DosError = 0);
END;

PROCEDURE ScanAFile (VAR done, vbose : boolean; seeking, newname : string );
VAR
     testline        : String[100];
     scanfile         : text;
BEGIN
     seeking := copy(seeking,1,12);
     Assign(scanfile,newname);
     Reset(scanfile);

     WHILE ((NOT Eof(scanfile)) AND (NOT done)) DO
     BEGIN
           ReadLn(scanfile,testline);

           IF (Pos(seeking,testline) = 1) THEN
           BEGIN
                done := True;
                IF vbose THEN
                   WriteLn ('Found in file: ',newname);
                WriteLn(testline);

                ReadLn(scanfile,testline);

                WHILE (testline[1] = ' ') DO
                BEGIN
                     WriteLn(testline);
                     ReadLn(scanfile,testline);
                END;
           END;
     END;
     Close(scanfile);
END;

PROCEDURE ScanTheFiles (VAR chatty : boolean;
                        VAR textseeking, textfiles : string;
                            listf : boolean );
VAR  DirInfo : SearchRec;
     found   : boolean;
BEGIN
     TextToScanFor := ConvertToUpper(TextToScanFor);
     found := False;
     IF chatty THEN
        WriteLn ('Scanning for:  ',textseeking);

     FindFirst( textfiles, Archive, DirInfo);
     IF listf THEN
     IF DirInfo.Name = TextToScanFor THEN
        FindNext(DirInfo);
     WHILE (DosError = 0) AND (NOT found) DO
     BEGIN
          IF chatty THEN
             WriteLn ('Scanning file:  ',DirInfo.Name);
          ScanAFile(found,chatty,textseeking,DirInfo.Name);

          FindNext(DirInfo);
          IF listf THEN
          IF DirInfo.Name = TextToScanFor THEN
             FindNext(DirInfo);
     END;
     IF (NOT found) THEN
        WriteLn('- Not found: ',textseeking);
END;


BEGIN
     GetCmdLnParms(Verbose, Quiet, TextToScanFor, FilesToScan);

     IF (NOT Quiet) THEN
     BEGIN
          Writeln(ProgData);
          Writeln(ProgDat2);
          Writeln;
     END;

     IsList := IsFile(TextToScanFor);
     IF IsList THEN           {If first arg is a file, scan its contents.}
     BEGIN
          Assign(List_File,TextToScanFor);
          Reset(List_File);
          WHILE NOT Eof(List_File) DO
          BEGIN
               ReadLn(List_File,FileSeeking);
               FileSeeking := ConvertToUpper(FileSeeking);
               ScanTheFiles(Verbose,FileSeeking,FilesToScan,IsList);
          END;
          Close(List_File);
     END
     ELSE BEGIN
          FileSeeking := TextToScanFor;  {Scan for the text on command line.}
          FileSeeking := ConvertToUpper(FileSeeking);
          ScanTheFiles(Verbose,FileSeeking,FilesToScan,IsList);
     END;
END.
