@echo off
cd\bt
bt

if errorlevel 255 goto recover       ;system failure
if errorlevel 254 goto noaddr        ;address not in nodelist
if errorlevel 192 bbsbatch           ;19.2 BBS callers
if errorlevel 168 bbsbatch           ;16.8 BBS callers
if errorlevel 144 bbsbatch           ;14.4 BBS callers
if errorlevel 120 bbsbatch           ;12.0 BBS callers
if errorlevel 100 goto f10           ;Goto WIMM
if errorlevel  96 bbsbatch           ;9600 BBS callers
if errorlevel  90 goto f9            ;Goto Yabom
if errorlevel  80 goto f8            ;Goto Telix
if errorlevel  70 goto f7            ;Goto MsgDel
if errorlevel  72 bbsbatch           ;7200 BBS callers
if errorlevel  65 goto mailin        ;when mail received
if errorlevel  60 goto f6            ;Goto Pageoff
if errorlevel  55 goto event         ;not used
if errorlevel  50 goto f5            ;Goto Pageon
if errorlevel  48 bbsbatch           ;4800 BBS callers
if errorlevel  45 goto reboot        ;reboot system
if errorlevel  40 goto f4            ;Run Tridog
if errorlevel  35 goto night         ;Run BBS night events
if errorlevel  32 goto outmail       ;Export mail from Tridog
if errorlevel  31 bbsbatch           ;not used
if errorlevel  30 goto f3            ;Goto Bonk 
if errorlevel  24 bbsbatch           ;2400 BBS callers
if errorlevel  22 goto event         ;not used
if errorlevel  20 goto f2            ;Goto Showlog
if errorlevel  12 bbsbatch           ;1200 BBS callers
if errorlevel  10 goto f1            ;Goto BBS
if errorlevel   8 goto reset         ;not used
if errorlevel   3 bbsbatch           ;300 BBS callers
goto end

REM *** REGULARLY SCHEDULED EXTERNAL EVENTS ***

:mailin
cd\bt
gotmail
cd\bt
runbink

:night
cd\tribbs
night
cd\bt
runbink

:outmail
cd\tribbs\tridog
tridog
cd\bt
squish out squash -fechotoss.log
if exist echotoss.log del echotoss.log
runbink

:tridog
cd\tribbs
tridog
cd\bt
runbink

:reboot
cd\bt
reboot

REM *** ON-DEMAND EXITS ***

:f1
cd\tribbs
if exist c:\tribbs\nwork\doors.tmp del c:\tribbs\nwork\doors.tmp
board.bat /F0 /H /T9999
cd\bt
runbink
:f2
goto showlog
:f3
goto bonk
:f4
goto mail
:f5
goto pageon
:f6
goto pageoff
:f7
goto msgdel
:f8
goto telix
:f9
goto yabom
:f10
goto wimm

:showlog
cd\bt
list
cd\bt
runbink

:mail
cd\tribbs
tridog.bat
cd\bt
runbink

:telix
cd\telix
telix
cd\bt
runbink

:yabom
cd\bt
yabom
cd\bt
runbink

:bonk
cd\bt
bonk
cd\bt
runbink

:pageon
cd\tribbs
pageon
cd\bt
runbink

:pageoff
cd\tribbs
pageoff
cd\bt
runbink

:wimm
cd\bt
wimm
cd\bt
runbink

:msgdel
cd\bt
msgdel
cd\bt
runbink

REM *** ERROR HANDLING ***

:noaddr
echo ADDRESS NOT IN NODELIST!
goto end

:recover
set t=%t%x
if %t%==xxxxxxxxxx goto baderror
echo Recoverable error - Trying again.
runbink

:baderror
set t=
echo SERIOUS ERROR - BINKLEY HALTED

:alarm
echo Serious error - Binkley halted.
goto alarm

:end
autoboot /unl
cd\bt
VFOS_DEL
BNU /U
:exit
