; FUNCOLRS.COM by Duane Paulson 08/06/91
;  Based on RANDGEN.ASM by CompuServe member 72210,17, who wrote it and
;  placed it in the public domain. I don't know your name, but thank you.
;  Code from RANDGEN.ASM is indicated by the ;* notation. Lines that I
;  changed so the routine would work with my code are marked with ;+
;
; PURPOSE: Writes a file called GCOLORS.T containing color parameters for
;  the ZCOMM and PRO-YAM graphics file transfer display. A different set
;  of colors is generated each time, and no two colors are ever repeated
;  within a single set.
;
; ASSEMBLE: masm funcolrs;
; LINK:	    link funcolrs;
;	    exe2bin funcolrs funcolrs.com
;
; CALL:	funcolrs


rt		equ	0dh		;*
lf		equ	0ah		;*
of		equ	offset		;*
sh		equ	short		;*

code	segment				;*
	assume	cs:code, ds:code	;*
	org	100h			;*


begin:	jmp	start

writes	MACRO	string,lstring,handle	; Writes a string to a file or device
	mov	ah,40h			;; write to file or device
	mov	bx,handle		;; file handle
	mov	cx,lstring		;; length of string
	mov	dx,OFFSET string	;; pointer to string
	int	21h			;; call dos
	ENDM

;*Note:  24 and 55 are not arbitrary.  They have been chosen so that the least
;*significant bits in the sequence of pseudorandom integers have a period of
;*length 2^55 - 1.  The sequence of pseudorandom numbers themselves have period
;*2^f*(2^55 - 1) where 0 <= f <= 16.  See Knuth's Volume 2 "Seminumerical
;*Algorithms" of the second edition of the three volume set THE ART OF COMPUTER
;*PROGRAMMING (pages 26 & 27).

j		dw	24 * 2		;*multiply by 2 for word offsets
k		dw	55 * 2		;*

;*Array of 55 seed elements for the additive pseudorandom number generator.

add_array	dw	?	;*this location (offset 0 word) is not used
	dw	7952,	42720,	56941,	47825,	52353,	4829,	32133	;*
	dw	29787,	7028,	62292,	46128,	34856,	63646,	21032	;*
	dw	62660,	61244,	35057,	36989,	43989,	46043,	48547	;*
	dw	43704,	29749,	21898,	10279,	48252,	35578,	27916	;*
	dw	3633,	50349,	33655,	36965,	48566,	43375,	15168	;*
	dw	30425,	8425,	31783,	3625,	23789,	37438,	64887	;*
	dw	19015,	43108,	61545,	24901,	58349,	52290,	62047	;*
	dw	21173,	27055,	27851,	47955,	14377,	14434		;*

fname	db	"GCOLORS.T",0
fhand	dw	?
emsg1	db	"Error creating file. No handles available or access denied."
gcolor	db	9,"gcolors "
endstr	db	"0,0",13,10,26
table	db	15 dup (0)
onedig	db	?

randomize	proc	near		;*randomize the random number generator
	push	ax			;*save
	push	bx			;*
	mov	ax,40h			;*set ds to BIOS data area
	mov	ds,ax			;*
	mov	bx,6ch			;*location of low word of 4-byte count
	mov	ax,[bx]			;*get low word of 4-byte clock count
	push	cs			;*reset ds for code addressing
	pop	ds			;*
	mov	bx,of add_array		;*address array of seed elements
	add	bx,2			;*offset 0 is not used
	mov	cx,55			;*shall adjust all 55 seeds
set_seed:
	add	[bx],ax			;*randomize seed value with current time
	add	bx,2			;*move to next one
	loop	set_seed		;*
	pop	bx			;*
	pop	ax			;*
	ret				;*
randomize	endp			;*

random		proc	near		;*generate pseudorandom number in ax
	push	bx			;*save
	push	cx			;*
	mov	bx,j			;*get j index
	mov	cx,add_array[bx]	;*and load array element into cx
	mov	bx,k			;*get k index
	mov	ax,add_array[bx]	;*and load array element into ax
	add	ax,cx			;*new element and return value to ax
	mov	add_array[bx],ax	;*store new element at location k
	sub	j,2			;*move down one element
	sub	k,2			;*move down one element
	cmp	j,0			;*is j down to 0?
	jne	check_k			;*no, check k
	mov	j,55 * 2		;*set i to end of array
check_k:
	cmp	k,0			;*is k down to 0?
	jne	random_out		;*no, leave
	mov	k,55 * 2		;*set k to end of array
random_out:
	pop	cx			;*restore
	pop	bx			;*
	ret				;*
random		endp			;*

number		db	3 dup(?)	;%reserve memory for output number
					; originally was 5
;new_line	db	rt,lf,'$'	;%new line and DOS terminator
					; following line replaces above line
new_line	equ	this byte	; we dont need the crlf (yet)
initial		db	' 0,'		;%initialization value for number
					; originally, '    0'

write_dec_ax	proc	near		;%write decimal of ax to gcolors.t
					; origianlly went to Standard Out
	cmp	ax,10			; are we dealing with 1 digit or 2?
	jb	@F
	mov	onedig,0		; here we're dealing with two
	jmp	short go1
@@:	mov	onedig,-1		; here we're dealing with two
	
go1:	push	ax			;*save
	push	bx			;*
	push	cx			;*
	push	dx			;*
	push	si			;*
	push	di			;*
	pushf				;*save direction flag
	mov	si,of initial		;*initialize output area
	mov	di,of number		;*
	mov	cx,2			;%
					; changed output from five digits to two
	cld				;*
	rep	movsb			;*
	mov	bx,10			;*base 10 divisor
	mov	di,of new_line-1	;*point to last digit position
	std				;*backward now

	push	ax
	mov	al,","			; place comma in last output position
	stosb
	pop	ax

next_digit:
	or	ax,ax			;*are we through?
	je	wda_out			;*yes, output result
	xor	dx,dx			;*clear high order end
	div	bx			;*next digit in result to dl
	xchg	ax,dx			;*place digit in al
	add	al,30h			;*convert to ascii digit
	stosb				;*store it in output area
	xchg	ax,dx			;*quotient back to ax
	jmp	sh next_digit		;*loop
wda_out:
	mov	ah,40h			;*let DOS output the number
					; originally function 9
	mov	bx,fhand		; write to GCOLORS.T
	mov	cx,3			; number of bytes to write
	mov	dx,of number		;*
	cmp	onedig,0		; are we dealing with 1 digit or 2?
	je	@F
	inc	dx			; here we're dealing with one
	dec	cx
@@:	int	21h			;*  here we rejoin with 2
	popf				;*restore
	pop	di			;*
	pop	si			;*
	pop	dx			;*
	pop	cx			;*
	pop	bx			;*

	pop	ax			;*
	ret				;*
write_dec_ax	endp			;*

	
start:	call	randomize		;*randomize the generator

	mov	ah,3Ch			; create file (open for overwrite)
	mov	cx,0			; normal attribute (not hidden, etc.)
	mov	dx,OFFSET fname		; pointer to filename
	int	21h			; call dos

	jnc	@F			; jump over error routine

	writes	emsg1,59,2		; display message to Standard Error

	jmp	short endit		;  and exit

@@:	mov	fhand,ax		; save the file handle

	writes	gcolor,9,fhand		; write header material to file


	mov	cx,15			;%number of randoms to write
next:	call	random			;*get a random number to ax

	shr	ax,1
	and	ax,0Fh			; use low nibble only
	jz	next			; discard return of zero
	push	di			; save registers
	push	bx
	push	cx
	mov	cx,15			; number of positions in 'used' table
check:	mov	di,cx
	mov	bl,BYTE PTR table[di]
	cmp	bl,al
	jne	@F			; check if we have duplicate values
	pop	cx			;  if we do, restore registers...
	pop	bx
	pop	di
	jmp	short	next		;  ... and do it again
@@:	loop	check			;   else continue checking
	pop	cx			; Good value!
	pop	bx			; restore registers
	mov	di,cx
	mov	BYTE PTR table [di],al	;  and make a note that we have used it
	pop	di
	
	call	write_dec_ax		;%write decimal of ax to file
					; originally it went to CON
	loop	next			;*

	writes	endstr,6,fhand		; write ending material to file

	mov	ah,3Eh			; close file
	mov	bx,fhand		; handle
	int	21h			; call dos

endit:	mov	ax,4C00h		; exit with zero exit code
	int	21h			;*end (originally int 20)

code	ends				;*
	end	begin			;*
