:: GEnie IBM PC RoundTable message upload script for YAM TurboDial 2.18+
::
:: Author:  Rahul Dhesi
:: Date:    1986/10/25
:: Version: 2.0 CAF Rev 10-17-88
::
:: Ideas were borrowed from Paul Homchick's file uploading script.  This 
:: script may be freely copied and modified by all.  I accept no liability 
:: should you go insane trying to figure out YAM's script commands.
::
::
::                               MESSAGE FORMAT
::
:: Each message to be uploaded is kept in a separate file.  Each message file
:: must begin with the prefix "msg" and must not have any extension.  Good
:: names to use are "msg1", "msg2", ..., "msg10", "msg11", and so on.  Each 
:: message file has one of the the following formats:
::  Old format:
::
::      line 1:  category number
::      line 2:  topic number
::      rest:    message text
::
::  New format:
::	line 1: Category 5,  Topic 36
::      rest:    message text
::
:: See the sample message files provided.
::
:: This script is invoked after you are already logged in to GEnie and
:: are at any GEnie menu.  It is invoked from your phones.t file and
:: a sample phones.t file is supplied to show how this is done.
:: This script simply returns to its caller.  The portion of phones.t
:: that invokes this script is responsible for logging you out.
::
::                         ADJUSTABLE PARAMETERS
::
:: This script assumes that your system-wide prompt character is ">".  If
:: your prompt character is different, e.g. "?", see items I and II. If your 
:: GENie break character is not control C, make a change in item III.  

::I.  SET PROMPT CHARACTER.  Here we set the system-wide prompt character 
:: to ">".  If your prompt character is different, change the following 
:: line, e.g.:  set pr "?"   (set in phone directory)
:	set pr "\006"
:       set pr "?"      : not currently in use

::II.  SET ASCII CODE FOR PROMPT CHARACTER.  Here we set the decimal ASCII 
:: code for your system-wide prompt character.  For example, if your prompt 
:: character is "?", the next line will become:  set code "63"
	set code "62"
:       set code "63"   : not currently in use

::III. SET BREAK CHARACTER.  Now, make sure that our break character is 
:: known to the script.  If it is control C, the value is "\003". Otherwise, 
:: change the following line.
:	set intr "\003"   (set in phone directory)

::IV.  Set page number in s7
:	set s7 "615"


::*******************************************************************
::The script itself starts here.  Some patterns are initialized and we
::try to reach the RoundTable Bulletin Board first.
	echof ""
        echoc "MSGUP:  Beginning upload of file %1"
        set blankfill "  "              : convert null lines to blanks
        pattern
        pat 1v "P %s7%pr"		: e.g. "P 615>"
	pat 3v "1 %pr"			: e.g. "1 >"
	pat 7v "<H>elp"

::Send a carriage return and see what GEnie does
        put "\r"				: hit return
        wait -f20  				: wait for any pattern
	if 7 put "m%s7:1\r" wait -f20
	while 7&&L<2 put "c\r" wait -f20
        while !1&&!3&&L<2 put "c\r" wait -f20
        while !3&&L<3 put "m%s7:1\r" wait -f20  : try to go to RT BBS

::If nothing happened, send our break character to wake GEnie & try again
	if !3 put "%intr" wait -f20		: send break
	if !1&&!3&&!5 goto failed		: no pattern still? give up
	if 3 goto foundrt			: if found "1 >", go on...
	while !3&&L<3 put "m%s7;1\r" wait -f20    : else try to go to RT BBS
	if !3 goto failed			: not reached BBS?  fail

::If we reach the bulletin board and see the prompt for category 1
::(e.g. "1 >"), we find the next message and select category and topic.
foundrt:
        open -!tg %1			: open message file
					: !t = no throttle (full speed)
					: !g = don't send file yet
	set s0 ""			: get 1st two lines (cat & topic)
	while "t&&!%s0"  grab s0
	if !ps0,Category goto oldf
	ss s0 "([0-9]+)(,[^0-9]*)([0-9]+)"
	sets s0 %z1
	sets s1 %z3
	: set
	: abort
	goto newf
oldf:	grab s1				: get 1st two lines (cat & topic)
        if !t goto nullmsg
newf:	if "as0<1" goto nonumber	: category must be nonzero
	if "as1<1" goto nonumber	: topic must nonzero
	pat 2 "ot \256vailable"         : \256 is wildcard for pattern match
	pat 3i "%s0 %pr" 	        : e.g. pat 3 "5 >"

::Select the desired category
        put "set %s0\r"			: e.g. "set 5<cr>", 5 being category
        wait -f30			: wait for cat to be chosen
	if 2 goto nosuchcat
        if !3 goto nocat               : give up if not chosen cat

::Select the desired topic
	pattern
	pat 2 "is closed"
	pat 3 "ot \256vailable"
	pat 4 "annot \256eply"
	pat 5 "# of topic"
	pat 6l "nter \256emo \256ext"
	put "reply %s1\r"		: e.g. "reply 22<cr>", 22 being topic
        wait -f30
	while n&&L<2 put "reply %s1\r" wait -f20 : Give GEnie two chances

::If GEnie says, "Enter # of topic..." something must have gone wrong.
:: We escape from there with a break character and give up on this one.
	if 5 put "%intr" goto nosuchtop : escape from prompt & give up

::Closed topic, or no such topic, or no "Enter memo text" prompt
	if 2||4 goto closed		: topic is closed, can't reply to it
	if 3 goto nosuchtop		: No such topic
        if !6 goto noreply             : no reply prompt
	pat 7 ">"
	wait

::We reach here if we saw a string asking us to reply to the topic

::Following lines from Paul Homchick's file upload script.  No idea what they
:: do but we'll let them stay there since they don't cause any harm.
	if !dP ena -p			: Ask Paul
	if dP ena -r			: Ask Paul

	pp2
	put "*u\r"			: Shift gears, no echo upload
	pat 6l INPUT
	wait; pat; sleep 10
::Upload the message, waiting for the prompt character after each line has
::been sent
        t -Hgx				: send file, continue script when done
	ena -ht!p			: enable throttle, disable wait for ">"
	: pp250				: disable prompt character
	pattern
	pat 1 "entered"
	put "%intr"
	pat 6 ">"
	wait
        put "*s\r"                      : send "*s<cr>"
	wait -f20
	if !1 put "*s\r" wait -f20
	if !1 goto doubtful
	: put "set 1\r"
	goto goodret

goodret:
        obey "!mv %1 Z%1.tmp" : ren original to Z*.tmp
	echof ""
        echoc "MSGUP:  Message %1 transmitted."	: record successful transmission
        return
failed:
	echof ""
	echoc "MSGUP:  Could not find RoundTable BBS."
	goto badret
closed:
	echof ""
	echoc "MSGUP:  Category %s0 topic %s1 is closed.  Cannot reply."
        goto badret
nosuchtop:
	echof ""
	echoc "MSGUP:  Category %s0 has no topic %s1.  Cannot reply."
        goto badret
nosuchcat:
	echof ""
	echoc "MSGUP:  Category %s0 is not available.  Cannot reply."
	goto badret
nullmsg:
	echof ""
	echoc "MSGUP:  Message null, not sent."
	goto badret
nocat:
	echof ""
	echoc "MSGUP:  Could not set category %s0."
	goto badret
noreply:
	echof ""
	echoc "MSGUP:  Did not receive Reply prompt."
        goto badret
nonumber:
	echof ""
	echoc "MSGUP:  Category or topic not nonzero."
	goto badret

::Reach here if something went wrong.  Rename file to Y*.tmp.
:: Send a "set 1" for good measure and return.
badret:
	obey "!mv %1 Y%1.tmp"
	goto restore

::Reach here if we thought we sent the message OK but GEnie didn't seem
:: notice.  Rename to W*.tmp
doubtful:
	echof ""
	echoc "MSGUP:  Message may or may not have been entered"
	obey "!mv %1 W%1.tmp"
	goto restore

restore:
	pattern
	pattern 1 "%pr"
        while !1&&L<2 put "\r" wait -f20
	pattern 1 "1 %pr"
	closetx
        return
