
;                         AceComm & Utilities (Tm)
;                              Version 1.8
;
;                       AceComm Ascii Control File
;                  Use ACTL.EXE to compile into ACE.PRM
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;              ACE.CTL is
;                          A  Plain  Ascii  Text  File...
;                          Use  a  Plain  Ascii  Text  Editor...
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; ============
;;;  Port Setup 
;;; ============
Port 1
;   o Connect speeds such as 12000, 14400 etc. are not actual
;     data rates that the UART (serial port)  can be set to.
;   o Setting the Baud rate to 19200 for a 9600 baud modem will
;     allow better performance when down loading data.
;   o Locking the port means selecting a baud rate higher than the
;     highest connect speed the modem is capable of, and telling the
;     communications software to lock it there.
;   o Modems capable of connecting at 9600 and above can usually be
;     used with a "Locked port"
;   o Using a locked port requires your modem be in full handshake
;     mode.
Baud 19200
LockBaud 
RBuff 8192
RBuff 256
FIFO_Trigger 8
;TX 
CTS/RTS 
XON/XOFF 
;Strip_HighBIT 
DropDTR 
;;; =================
;;;  Dialing Options 
;;; =================
InterByteDelay 1
DialTimeout 60
TimeBetweenRedial 1
;DTR_BetweenRedial 
DialConnectBell 1
;DCD_VerifyConnect 
;;; ===========================
;;;  Internal Protocol Options 
;;; ===========================
AutoEngage 
FileResume 
;XfrTimeSlice 
XfrBell 
;;; =================
;;;  General Options 
;;; =================
StatusLine 
LogFile 
;LogModemRes 
AutoSave 
;SnowCheck 
ScrnBlank 4
SwapSpawn 
SwapShell 
EnhancedKBD 
KeyRef 
;MailDialer 
ScrlBakBuf 64
VideoRows 0
;;; =================
;;;  Pointer Options 
;;; =================
MouseX 6
MouseY 4
MouseDetect 
;;; ======================
;;;  Colors, Menu Options 
;;; ======================
BorderAttr 7
BorderType 0
LeftFieldAttr 3
RightFieldAttr 7
DisplayATTR 48
TitleAttr 120
ITitleAttr 10
SelectorAttr 2
;BurstMenu 
;ChatterMenu 
;WhistleMenu 
TermColor 7
CurtainColor 22
CurtainChar 176
HelpLineColor 112
HelpScreenColor 7
HelpScreenTitleColor 26
HelpScreenKeyWordColor 122
HelpScreenSelectorColor 30
HelpScreenLastErrorColor 28
FonBorderAttr 7
FonBorderType 0
FonLeftFieldAttr 3
FonRightFieldAttr 7
FonDisplayAttr 48
FonTitleAttr 120
FonITitleAttr 10
FonSelectorAttr 2
;FonBurstMenu 
;FonChatterMenu 
;FonWhistleMenu 
DialBorderAttr 3
DialBorderType 3
DialLeftFieldAttr 3
DialRightFieldAttr 7
DialDisplayAttr 7
DialTitleAttr 15
DialITitleAttr 14
DialSelectorAttr 3
;DialBurstMenu 
;DialChatterMenu 
;DialWhistleMenu 
;;; =================
;;;  Sub Directories 
;;; =================
FonDir   FON
Captures CAP
Scripts  SCR
TermKey  KTS
DnldDir  FIL
Nodelist FIL
MailIn   MAIL
MailOut  MAIL
;;; =============
;;;  Modem Setup 
;;; =============
;
; - Modem command strings
;   Note: Mdm commands are automaticaly appended with
;         Mdm_Cmd_Line_Terminator at time the command string
;         is sent to the modem.
;         The `^` character is recognized as a Control character.
;         The byte following a `^` will become (byte - 64d)
;   Examples:
;             ^M translates to CR
;             ^A translates to 1, ^M translates to 13 (CR_CHAR)
;             ~ translates to a 250 milisecond delay
Mdm_Init ATZ^M~~~~ATE0M0&C1&D2
Mdm_Dial_Prefix ATEQ0X4DT
Mdm_Dial_Sufix 
Mdm_Answer ATA
Mdm_Hangup +++~~~~~ATH0
Mdm_OffHook ATH1
Mdm_Abort ^M
Mdm_Reset ATZ
Mdm_Echo ATE1
Mdm_Host_Init ATE
;
; Mdm_Cmd_Line_Terminator is automaticaly appended to all modem commands
Mdm_Cmd_Line_Terminator ^M
;
;
; - Modem Responce Strings
;   Note: The following strings are probably case sensitive
;                                   (see your modem manual)
Mdm_Res_OK OK^M
Mdm_Res_Ring RING^M
Mdm_Res_NoCarrier NO CARRIER
Mdm_Res_Error ERROR
Mdm_Res_NoDialTone NO DIAL TONE
Mdm_Res_Busy BUSY
Mdm_Res_NoAnswer NO ANSWER
Mdm_Res_Ringing RINGING^M
Mdm_Res_Voice VOICE
;
; - The following connect strings may be tailored any way you wish.
;   No particular order, refer to your modem manual for case and format.
; Note: ACECOMM will detect a carrier anyway, the connect strings
;       may speed things up, and will also allow automatic baud adjustments
;       when connecting at a speed not dialed out on, and port not locked.
;       With Lockbaud SET, the UART baud rate remains fixed, translation
;       is made by your modem.
Mdm_Res_Connect_a CONNECT 
Mdm_Res_Connect_b CARRIER
Mdm_Res_Connect_c FAX
;;; ========================
;;;  Interactive EMSI Setup 
;;; ========================
IEMSI_Name
IEMSI_Alias Michael Phelps/(AceComm)
IEMSI_Location Phoenix, AZ  USA
IEMSI_Data_Pnum (602) 846-2940
IEMSI_Voice_Pnum, 
IEMSI_Password password
IEMSI_CRTDEF ANSI,24,80,0
IEMSI_Protocols Zap,ZMO
IEMSI_Capabilities CHT,TAB,ASCII8
IEMSI_Requests NEWS,MAIL,FILE,HOT,CLR,HUSH,MORE,FSED
;;; ============
;;;  EMSI Setup 
;;; ============
EMSI_System_Address 1:114/35
EMSI_System_Name AceComm Software Support
EMSI_City Phoenix, AZ
EMSI_Phone_Number (602) 846-2940
EMSI_Baud_Rate 19200
EMSI_Flags v32
PassWord0 
PassWord1 
PassWord2 
PassWord3 
PassWord4 
DialTrans0
DialTrans1 
DialTrans2 
DialTrans3 
DialTrans4 
BossAddress 1:114/35
BossName Acecomm Software Support BBS
BossPhone 1-602-846-2940
BossPwd mailman
BossBaud 19200
;;; ========================================================
;;;  Auto Engage Sequence Triggers, Associated Macro Stacks 
;;; ========================================================
PreAutoM 
PostAutoM 
AutoDnld0 rz^M**^X
AutoDnld1 HS*^B
AutoDnld2 ^H ^H ^H ^H ^H ^H 
AutoDnld3 MPt ^V^H
AutoDnld4 
AutoDnld5 
AutoDnld6 
AutoDnld7 
AutoDnld8 **EMSI_REQA77E
AutoDnld9 **EMSI_IRQ8E08
AutoMacro0 <RecvZmo>
AutoMacro1 <RunProg>HSLINK -P%P -U[DIR_DNLDS] @UPLDS.LST
AutoMacro2 <RunProg>BIMODEM /L%P /R[DIR_DNLDS] Bimodem.Pth
AutoMacro3 <RunProg>MPT P%P N+ F+ R+ R [DIR_DNLDS]
AutoMacro4 
AutoMacro5 
AutoMacro6 
AutoMacro7 
AutoMacro8 <SendEMSI_CLI>
AutoMacro9 <SendEMSI_ICI>
;;; ========================================================
;;;  Auto Log On Sequence Triggers, Associated Macro Stacks 
;;; ========================================================
AutoLogOn0 is your name:
AutoLogOn1 Your FIRST name:
AutoLogOn2 Host Name:
AutoLogOn3 first name ?
AutoLogOn4 and LAST name:
AutoLogOn5 last name?
AutoLogOn6 first name?
AutoLogOn7 (First and Last)
AutoLogOn8 
AutoLogOn9 
AutoLogOna 
AutoLogOnb 
AutoLogOnc 
AutoLogOnd 
AutoLogOne 
AutoLogOnf 
AutoLMacro0 <SendStr>[USER_NAME]^M~Y^M~[FON_PWD]^M
AutoLMacro1 <SendStr>[USER_NAME]^MY^M~[FON_PWD]^M
AutoLMacro2 <SendStr>CIS^M~~~~[FON_ID]^M~~~~~~[FON_PWD]^M
AutoLMacro3 <SendStr>[USER_NAME]^MY^M[FON_PWD]^M
AutoLMacro4 <SendStr>[USER_NAME]^M~^M~[FON_PWD]^M
AutoLMacro5 <SendStr>[USER_NAME]^M~~[FON_PWD]^M
AutoLMacro6 <SendStr>[USER_NAME]^M~~[FON_PWD]^M
AutoLMacro7 <SendStr>[USER_NAME]^M~~[FON_PWD]^M
AutoLMacro8 
AutoLMacro9 
AutoLMacroa 
AutoLMacrob 
AutoLMacroc 
AutoLMacrod 
AutoLMacroe 
AutoLMacrof 
;;; ========================================================
;;;  Event Schedules, Associated Macro Stacks 
;;; ========================================================
;;    Sample Event an associated macro stack:
;; (Allow a mail event from midnight to 3am)
; Schedule_0    0:0-3:0,MAIL
;; (The macro stack will be run at beginning of event)
; SchedMacro_0  <ChgDir>c:\mail <RunProgram>QM <ChgDir>[DIR_START]
Schedule_0 00:00-03:00,Mail
Schedule_1 8:30-9:0,Mail,Host
Schedule_2 
Schedule_3 12:00-13:00,Mail
Schedule_4 
SchedMacro_0 <ChgDir>c:\mail\qm <RunProg>QM scan <ChgDir>[DIR_START] <PollBoss>
SchedMacro_1 <ChgDir>c:\mail\qm <RunProg>QM toss <ChgDir>[DIR_START] <PollBoss>
SchedMacro_2 
SchedMacro_3 <PollBoss>
SchedMacro_4 
;;; =========================================================
;;;  Auto Answer Connect Sub-string, Associated Macro Stacks 
;;; =========================================================
;;    Sub_string  - String to match in modem Answer/Connect string
;;    Macro stack - Macro stack to process on Answer/Connect
;;    Sample Sub-string and associated macro stack:
;AutoAnsSub-str_1 CONNECT
;AutoAnsMac_1 <RunProgram>TRIBBS port %P baud %B
;;    Sample Sub-string and associated macro stack:
;AutoAnsSub-str_2 FAX
;AutoAnsMac_2 <RunProgram>BGFAX /FAX %P Q
AutoAnsSub-str_1 CONNECT
AutoAnsMac_1 <HostEcho> <SendStr>^M^L[ACE_ID]^M^JSysop [USER_NAME], [LOCATION]^M^J^J^J^J
AutoAnsSub-str_2 FAX
AutoAnsMac_2 <RunProg>BGFAX /FAX %P Z
AutoAnsSub-str_3 CARRIER
AutoAnsMac_3 <ChgDir>C:\BBS <RunProg>BBS %P %B <ChgDir>[DIR_START]
DefaultMac <RunProg>BGFAX /FAX %P Z
;;; ===================
;;;  Mondo Menus (Tm)
;;; ===================
Mondo_1_Title CIS Functions
Mondo1_desc_a CIS Forums Script
Mondo1_macro_a <RunScript>cisforum.scr
Mondo1_desc_b CIS Bill Script
Mondo1_macro_b <RunScript>cisbill.scr
Mondo1_desc_c Compose Message
Mondo1_macro_c <SendAscii>%P
Mondo1_desc_d IBMPRO Forum 2 File
Mondo1_macro_d <SendStr>go IbmPro^M <OpenCapture>ibmpro <SendStr>~~~~~~~~Read New^M
Mondo1_desc_e IBMCOM Forum 2 File
Mondo1_macro_e <SendStr>go IbmCom^M <OpenCapture>ibmcom <SendStr>~~~~~~~~Read New^M
Mondo1_desc_f 
Mondo1_macro_f 
Mondo1_desc_g CIS Msg Reference
Mondo1_macro_g <RunProg>List cis_msg.ref
Mondo_2_Title OffLine Reader
Mondo2_desc_a Read Off-line Mail
Mondo2_macro_a <ChgDir>\mail\reader <RunProg>BlueWave <ChgDir>[DIR_START]
Mondo2_desc_b Run Mail Script
Mondo2_macro_b <RunScript>offline.scr
Mondo2_desc_c 
Mondo2_macro_c 
Mondo2_desc_d 
Mondo2_macro_d 
Mondo2_desc_e 
Mondo2_macro_e 
Mondo2_desc_f 
Mondo2_macro_f 
Mondo2_desc_g Delete old .QWK
Mondo2_macro_g <FileDel>c:\mail\114-35.qwk
Mondo_3_Title Mondo Menu #3
Mondo3_desc_a Description
Mondo3_macro_a Macro Stack
Mondo3_desc_b Description 
Mondo3_macro_b Macro Stack
Mondo3_desc_c Description
Mondo3_macro_c Macro Stack
Mondo3_desc_d 
Mondo3_macro_d 
Mondo3_desc_e 
Mondo3_macro_e 
Mondo3_desc_f 
Mondo3_macro_f 
Mondo3_desc_g 
Mondo3_macro_g 
Mondo_4_Title Mondo Menu #4
Mondo4_desc_a 
Mondo4_macro_a 
Mondo4_desc_b 
Mondo4_macro_b 
Mondo4_desc_c 
Mondo4_macro_c 
Mondo4_desc_d 
Mondo4_macro_d 
Mondo4_desc_e 
Mondo4_macro_e 
Mondo4_desc_f 
Mondo4_macro_f 
Mondo4_desc_g 
Mondo4_macro_g 
Mondo_5_Title Mondo Menu #5
Mondo5_desc_a 
Mondo5_macro_a 
Mondo5_desc_b 
Mondo5_macro_b 
Mondo5_desc_c 
Mondo5_macro_c 
Mondo5_desc_d 
Mondo5_macro_d 
Mondo5_desc_e 
Mondo5_macro_e 
Mondo5_desc_f 
Mondo5_macro_f 
Mondo5_desc_g 
Mondo5_macro_g 
;;; ==============
;;;  ALT A-Z, 1-0 
;;; ==============
;
; AceComm`s MACRO driven keyboard provides for easy key re-def
;
; You may define the keys any way you like, should you forget to
; assign an exit key, CTRL-BREAK from terminal mode will force the
; <EndACEComm> MACRO to be executed, CTRL-BREAK is an acceptable
; key-combo permanantly assigned to the <EndACEComm> MACRO
;
; Functions which end with `_` are not suited for scripts as they
; require local keyboard input.
ALT-A <AutoScrGen_>
ALT-B <BackBuffer_>
ALT-C <CaptureFile_>
ALT-D <FonListDialer_>
ALT-E <SendStr> ATE^M <HostEcho>
ALT-F <FileLister_>[DIR_DNLDS]
ALT-G <FileRequest_>
ALT-H <MdmHangUp_> 
ALT-I 
ALT-J <CommandShell_>
ALT-K 
ALT-L <RunProg> list
ALT-M <SendStr>ath1^M <ChgDir>mail\ged <RunProg>GOLDED <ChgDir>[DIR_START]
ALT-N <ChgDir>c:\mail\qm <RunProg>QM toss <ChgDir>[DIR_START]
ALT-O <PrmDataMenus_>
ALT-P <PrmDataMenus_>
ALT-Q 
ALT-R <RunScript_>
ALT-S <ScrnSnapshot_>
ALT-T <ScrnTag_>
ALT-U 
ALT-V <ViewKeyCombos_>
ALT-W 
ALT-X <EndAceComm> 0
ALT-Y <AutoAnswer>
ALT-Z <ClearWindow>
ALT-1 <SendZmo> %PF
ALT-2 <RunProg>DSZ sz %PF %WK <SendStr> ^M
ALT-3 <SendAscii> %PF
ALT-4 <RunProg>BiPath 
ALT-5 
ALT-6 <RunProg> dsz rz -rm
ALT-7 <RunProg>bimodem bimodem.pth <SendStr>^M
ALT-8 
ALT-9 
ALT-10 
ALT-- 
ALT-= <DoorWayMode>
;;; ==========
;;;  CTRL A-Z 
;;; ==========
CTRL-A 
CTRL-B 
CTRL-C 
CTRL-D 
CTRL-E 
CTRL-F 
CTRL-G 
CTRL-H 
CTRL-I 
CTRL-J 
CTRL-K 
CTRL-L 
CTRL-M 
CTRL-N 
CTRL-O 
CTRL-P 
CTRL-Q 
CTRL-R 
CTRL-S 
CTRL-T 
CTRL-U 
CTRL-V 
CTRL-W 
CTRL-X 
CTRL-Y 
CTRL-Z 
CTRL-2 
CTRL-6 
CTRL-- 
CTRL-BkSp 
CTRL-[ 
CTRL-] 
CTRL-Enter 
CTRL-\ 
CTRL-PrtSc 
CTRL-Home 
CTRL-PgUp 
CTRL-Left 
CTRL-Right 
CTRL-End 
CTRL-PgDn 
;;; ============
;;;  Other Keys 
;;; ============
Home 
Up 
PgUp <SProtocols_>
GreyMinus 
Left 
Right 
GreyPlus 
End 
Down 
PgDn <RProtocols_>
Ins 
Del 
;;; =========
;;;  Fn Keys 
;;; =========
F1 <SendStr>[USER_NAME]^M
F2 <SendStr>[FON_REC_PWD]^M
F3 <SendStr>[LOCATION]^M
F4 <SendStr>[VOICE_PNUM]^M
F5 <SendStr>[PASSWORD]^M
F6 <SetDTR> ON
F7 <SendAscii> %PF
F8 <Mondos>
F9 <HelpMenu>
F10 <TopBar>
F11 <Mondo1>
F12 <SendStr>75120,3306^M
SHIFT-F1 <SendStr>bpcsrc.zip
SHIFT-F2 <SendStr>USRGDE.DOC
SHIFT-F3 <SendStr>REFCRD.DOC
SHIFT-F4 <SendStr>HELP.DOC
SHIFT-F5 <SendStr>MPT110.ARJ
SHIFT-F6 <SendStr>RTGRAF.ZIP
SHIFT-F7 
SHIFT-F8 
SHIFT-F9 
SHIFT-F10 
SHIFT-F11 
SHIFT-F12 
CTRL-F1 <LocalEcho> ON <DIALNUM> 846-2940 <LocalEcho> OFF
CTRL-F2 <SetDTR> Off <Delay> 5 <SetDTR> ON
CTRL-F3 
CTRL-F4 
CTRL-F5 
CTRL-F6 
CTRL-F7 
CTRL-F8 
CTRL-F9 
CTRL-F10 
CTRL-F11 
CTRL-F12 
ALT-F1 <RunProg> list
ALT-F2 <RunProg> bb
ALT-F3 <RunProg> QEDIT %PF
ALT-F4 <RunProg> COMMAND /C dir /w %WK
ALT-F5 
ALT-F6 
ALT-F7 
ALT-F8 
ALT-F9 
ALT-F10 
ALT-F11 
ALT-F12 
