PROC MAIN
;*************************************************************************
;* BOCA.ASP SETUP FILE                                                   *
;*                                                                       *
;* An ASPECT script file for initializing the BOCA 14.400                *
;* modem for proper use with PROCOMM PLUS.                               *
;*                                                                       *
;*************************************************************************

CLEAR
CUROFF
BOX 0 0 9 58 14
ATSAY 2 2 14 "PROCOMM PLUS is designed to work efficiently with the"
ATSAY 3 2 14 "BOCA 14.4k modem in all its operational modes, but the"
ATSAY 4 2 14 "initial setup differs from the setup for ordinary non-"
ATSAY 5 2 14 "error-correcting modems."
ATSAY 7 2 14 "        <press ENTER repeatedly to continue>"
WAIT1:
IF NOT HITKEY
   GOTO WAIT1
ENDIF
CLEAR
BOX 0 0 17 59 14
ATSAY 2 2 14 "The basic principle is that the computer-to-modem baud-"
ATSAY 3 2 14 "rate is fixed at 57600 (thus your status line will"
ATSAY 4 2 14 "*always* read 57600) and the modem itself adjusts to"
ATSAY 5 2 14 "the actual speed of the connection."
ATSAY 7 2 14 "This ASPECT file sends to the modem all the commands"
ATSAY 8 2 14 "necessary for efficient automatic use of its error-"
ATSAY 9 2 14 "correcting features. You only need to run it one time,"
ATSAY 10 2 14 "since it tells the modem to write these settings to"
ATSAY 11 2 14 "non-volatile RAM. It is also very important to follow"
ATSAY 12 2 14 "*exactly* the instructions that appear on the screen"
ATSAY 13 2 14 "as you run this file."
ATSAY 15 2 14 "                 <press ENTER to continue>"
WAIT2:
IF NOT HITKEY
   GOTO WAIT2
ENDIF
CLEAR
SET TXPACE 100
SOUND 440 50
BOX 0 0 4 56 14
ATSAY 2 2 14 "BOCA 14.4k modem initialization... WORKING..."
SET PARITY NONE
SET DATABITS 8
SET STOPBITS 1
SET BAUD 57600
CURON
LOCATE 5 0
TRANSMIT "AT&F^M"                  ; Get factory defaults
PAUSE 1
TRANSMIT "ATE1^M"                  ; Echo Commands
PAUSE 1
TRANSMIT "ATL1^M"                  ; Low Speaker Volume
PAUSE 1
TRANSMIT "ATS0=0^M"                ; auto answer off
PAUSE 1
TRANSMIT "ATX4^M"                  ; Response set and calling characteristics
PAUSE 1
TRANSMIT "AT&C1^M"                 ; Data Carrier Detect (data sensitive)
PAUSE 1
TRANSMIT "AT&D2^M"                 ; DTR processing
PAUSE 1
TRANSMIT "ATS7=60^M"               ; wait 60 seconds for CD
PAUSE 1
TRANSMIT "AT&S1^M"                 ; DSR to CCITT
PAUSE 1
TRANSMIT "ATS95=46^M"              ; Control Selection of Compression
SET TXPACE 0
CLEAR
CUROFF
SOUND 440 50
BOX 0 0 17 60 14
ATSAY 2 2 14 "BOCA 14.4k modem initialization - COMPLETED!"
ATSAY 4 2 14 "Your modem will now power up with the proper"
ATSAY 5 2 14 "defaults for PROCOMM PLUS.  You should now use the"
ATSAY 6 2 14 "Setup Facility (Alt-S) MODEM OPTIONS to make your"
ATSAY 7 2 14 "INITIALIZATION COMMAND `"ATZ^M`" (without the quotes)."
ATSAY 8 2 14 "Also set AUTOBAUD DETECT to OFF in both MODEM & HOST MODE"
ATSAY 9 2 14 "OPTIONS.  In TERMINAL OPTIONS Hardware Flow Control"
ATSAY 10 2 14 "(RTS/CTS) should be turned ON. All dialing directory"
ATSAY 11 2 14 "entries should be should be set to 57600 baud, as well"
ATSAY 12 2 14 "as your Alt-P line setting. Make sure to save your"
ATSAY 13 2 14 "changes. One last thing: your CONNECT MESSAGES in MODEM"
ATSAY 14 2 14 "OPTIONS should all read simply `"CONNECT`" (without"
ATSAY 15 2 14 "quotes). Now type: AT&W to save these changes."
CURON
LOCATE 18 0
ENDPROC
