Uses Dos;

Var Key:Char;
    Parameter:String;
    Regs:Registers;

Function CD (Comport:Byte) : Boolean; (** Carrier Detected (CD) **)
 Begin
  With Regs do
  Begin
    AH := 3;                      {Interrupt 14H - Serial communication}
    DX:=Comport-1;                {Function 3 - Detect carrier         }
    Intr ($14, Regs);
    CD := ((AL AND 128) = 128);
  end;
end;

Procedure Help;
  Begin
   Writeln ('Batch file Carrier Detector v1.0 - (c) Copyright 1993 Lavi Tidhar');
   Writeln;
   Writeln ('Usage: Carrier [Comport number]');
   Writeln;
   Writeln ('Com ports supported : 1-4');
   Writeln ('Errorevels:');
   Writeln ('~~~~~~~~~~~');
   Writeln ('10 = error in execution, will result in this help screen');
   Writeln (' 1 = Carrier Detected');
   Writeln (' 0 = NO CARRIER');
   Writeln;
   Writeln ('May the force be with you!');
   Halt (10);
  End;

Begin (** Main **)

 If ParamCount<>1 then help; {If number of parameters isn't 1 then run the}
 Parameter:=Paramstr(1);     {Help screen                                 }
 Key:=Parameter[1];
 Case key of
 '1': If CD (1) then halt (1) else Halt (0);
 '2': If CD (2) then halt (1) else Halt (0);
 '3': If CD (3) then halt (1) else Halt (0);
 '4': If CD (4) then halt (1) else Halt (0);
 End;

End.
