% ------------
% PROTOCOL.CTL   ..a replacement to include various new protocols.
% ------------     from the archive NEWPROT2.ARJ, by Gary M. Gilmore
%                  FidoNet: 1:2410/400 - Internet: afcgaryg@aol.com
%
% This file is used to define external protocols usable with Max 2.1wb.
%
% Be SURE that the comment "Include Protocol.Ctl" is in the bottom of
% your MAX.CTL file, or this file will NOT be processed when you re-Silt!
% D/GSZ must be in your \MAX directory.
%
% If you're using a locked baud rate other than 38400, THESE PROTOCOL ENTRIES 
% WILL NEED TO BE MODIFIED.  You should replace all "38400"'s in this file
% with your locked baud rate (such as 19200 or 38400).
% If you are _NOT_ running with locked baud rate, replace the "38400"'s 
% with "%W"'s.  Failure to do so will not only cause these protocols to barf,
% it'll make you look like a boob.
%
% Also, if you're running 4DOS (or any other alternate shell), you
% should replace all occurences of "command.com" with the name of
% your shell (such as 4dos.com).  Failure to do this may cause erratic
% results when calling external protocols.
%
% NOTE!  You must create the following RDSZ.BAT in your Max directory
% to ensure that DSZ (or GSZ.EXE renamed to "DSZ.EXE") handles transfers
% correctly:
%
%       @echo off
%       set dszlog=%1
%       dsz port %2 speed %3 %4 %5 %6 %7 %8 %9
%       set dszlog=
%
% Without this batch file, protocol logging will not be enabled.
%
% WARNING!  A registered copy of DSZ is required to properly handle
% uploads.  Without a registered copy, uploads will be placed into
% your \MAX directory!

% DSZ "Standard" Xmodem.  See the DSZ/GSZ Docs on how to turn on the 
% OverThruster if desired.  I have not tested this feature on my system.

Protocol 2Xmodem/DSZ
% ;       Type            Batch
% ;       Type            Errorlevel
% ;       Type            Bi
% ;       Type            Opus
 
          LogFile         DSZ%K.Log
          ControlFile     DSZ%K.Ctl
          DownloadCmd     command.com /c rdsz DSZ%K.Log %P 38400 sx %m
          UploadCmd       command.com /c rdsz DSZ%K.Log %P 38400 rx %m
          DownloadString  %s
          UploadString
          DownloadKeyword S
          UploadKeyword   R
          FilenameWord    10
          DescriptWord    0
End Protocol

% Regular Y-Modem, using D/GSZ.  You'll want to offer this for users that 
% don't have Zmodem, and don't have an error-correcting modem.

Protocol Ymodem
          Type            Batch
          LogFile         DSZ%K.Log
          ControlFile     DSZ%K.Ctl
          DownloadCmd     command.com /c rdsz DSZ%K.Log %P 38400 ha on sb  @%x:DSZ%K.Ctl
          UploadCmd       command.com /c rdsz DSZ%K.Log %P 38400 ha on rb  %v
          DownloadString  %s
          UploadString
          DownloadKeyword S
          UploadKeyword   R
          FilenameWord    10
          DescriptWord    0
End Protocol

Protocol GYmodem-G
          Type            Batch
          LogFile         DSZ%K.Log
          ControlFile     DSZ%K.Ctl
          DownloadCmd     command.com /c rdsz DSZ%K.Log %P 38400 ha on sb -g @%x:DSZ%K.Ctl
          UploadCmd       command.com /c rdsz DSZ%K.Log %P 38400 ha on rb -g %v
          DownloadString  %s
          UploadString
          DownloadKeyword S
          UploadKeyword   R
          FilenameWord    10
          DescriptWord    0
End Protocol

% Zmodem-90 MobyTurbo protocol.  To use, place DSZ.EXE or DSZ.COM in your 
% \MAX directory.

Protocol DSZ/MobyTurbo
         Type            Batch
%;       Type            Errorlevel
%;       Type            Bi
%;       Type            Opus

         LogFile         DSZ%K.Log
         ControlFile     DSZ%K.Ctl
         DownloadCmd     command.com /c rdsz DSZ%K.Log %P 38400 ha both sz -m -Z @%x:DSZ%K.Ctl
         UploadCmd       command.com /c rdsz DSZ%K.Log %P 38400 ha both rz %v
         DownloadString  %s
         UploadString
         DownloadKeyword z
         UploadKeyword   Z
         FilenameWord    10
         DescriptWord    0
End Protocol

Protocol Zmodem
          Type            Batch
% ;       Type            Errorlevel
% ;       Type            Bi
% ;       Type            Opus
 
          LogFile         DSZ%K.Log
          ControlFile     DSZ%K.Ctl
          DownloadCmd     command.com /c rdsz DSZ%K.Log %P 38400 ha both sz -m -Z @%x:DSZ%K.Ctl
          UploadCmd       command.com /c rdsz DSZ%K.Log %P 38400 ha both rz %v
          DownloadString  %s
          UploadString
          DownloadKeyword z
          UploadKeyword   Z
          FilenameWord    10
          DescriptWord    0
End Protocol

% MPt protocol. (Formerly known as "Puma".)  To use, simply place MPT.EXE
% in your \MAX directory.

Protocol MPt/Puma
         Type            Batch
 ;       Type            Errorlevel
 ;       Type            Bi
 ;       Type            Opus
         LogFile         Mpt.Log
         ControlFile     Mpt.Ctl
         DownloadCmd     mpt A+ B- D+ F+ N+ P%P S0 M- W- HF Lmpt.log s @mpt.ctl
         UploadCmd       mpt A+ B- D+ F+ N+ P%P S0 M- W- HF Lmpt.log r %v
         DownloadString  %s
         UploadString
         DownloadKeyword S
         UploadKeyword   R
         FilenameWord    10
         DescriptWord    0
End Protocol

% HS/Link, a fast bi-directional protocol.  If you are NOT using DesqView,
% remove the "-I2" and "-NV" switches from both the Up and DownloadCmd lines.
% Put the file HSLINK.EXE into your \MAX directory.

Protocol HS/Link
         Type            Batch
%;       Type            Errorlevel
         Type            Bi
%;       Type            Opus

         LogFile         c:\max\HSK%K.log
         ControlFile     c:\max\HSK%K.Ctl
         DownloadCmd     command.com /c rhsl C:\Max\HSK%K.log -P%P -b38400 -I2 -NV -E%b -U%V @C:\Max\HSK%K.Ctl
         UploadCmd       command.com /c rhsl C:\Max\HSK%K.Log -P%P -b38400 -I2 -NV -E%b -U%V
         DownloadString  %s
         UploadString
         DownloadKeyword h
         UploadKeyword   H
         FilenameWord    10
         DescriptWord    0
End Protocol

%You will also need a batch file called RHSL.BAT in your \MAX directory.
%
%  @echo off
%  c:
%  cd\max
%  set dszlog=%1
%  Hslink %2 %3 %4 %5 %6 %7 %8 %9
%  set Dszlog=

% HydraCom Version 1.00 Bi-Directional File Transfer Protocol by
% Arjen G. Lentz, LENTZ SOFTWARE-DEVELOPMENT and Joaquim H. Homrighausen
% Copy the Hydracom.Exe file into your \MAX directory.

Protocol -Hydra
    Type            Batch
    Type            Bi

    LogFile         Hydra%K.Log
    ControlFile     Hydra%K.Ctl
%   NOTE: Put NOS (nostamp) in the lines below to NOT 
%         retain date/time on received files.
    DownloadCmd     HydraCom.Exe por %P spe %W lin %b dro nor nob res %x:Hydra%K.Log rec %v sen @%x:Hydra%K.Ctl
    UploadCmd       HydraCom.Exe por %P spe %W lin %b dro nor nob res %x:Hydra%K.Log rec %v get
    DownloadString  %s
    UploadString
    DownloadKeyword H
    UploadKeyword   R
    FilenameWord    10
    DescriptWord    0
End Protocol

%  Remember!  If *you* have any working protocol setups that are not included 
%  here, please send it to me!  I need:
%
%  - The portion of your PROTOCOL.CTL that contains the protocol's settings.
%  - Any batch files needed to use it.  (or SET commands used)
%  - A copy of the protocol's original archive, including docs.
%
%  I will either include it in a new release of NEWPROTO, or keep it on
%  file here to aid other MAX sysops, should they want the info.  Thanks!
