CLEAR              ; Clear the screen for opening message
LOCATE 4 0
MESSAGE "ͻ"
MESSAGE "                                                           "
MESSAGE "            This is the FASTDOC Aspect Script.             "
MESSAGE "                                                           "
MESSAGE " It will send one or more messages (and delete messages)   "
MESSAGE " to a forum of your choice.  The messages should be in a   "
MESSAGE " file on disk prepared according to the instructions in    "
MESSAGE " FAST.DOC.                                                 "
MESSAGE "                                                           "
MESSAGE " If the file is not in the current directory, precede the  "
MESSAGE " filename with the drive and path.                         "
MESSAGE "                                                           "
MESSAGE " To proceed, wait 5 seconds.                               "
MESSAGE "                                                           "
MESSAGE " To stop this command file, hit the ESC key at any time.   "
MESSAGE "                                                           "
MESSAGE "                                                           "
MESSAGE "ͼ"
PAUSE 5            ; Wait 5 seconds before moving on

EMULATE ANSI       ; Emulate ANSI terminal 
SET ATIME 1        ; When this file sounds a beep, do it for only
                   ; 1 second at a time
ASSIGN S0 "1"      ; Use S0 to keep track of loops--set counter at 1. 

CLEAR              ; Clear the screen 
LOOP_0:            ; Return here to include first instruction box
MESSAGE "    Ŀ"
MESSAGE "     You may select up to 3 forums, one at a time."
MESSAGE "    "

LOOP_1:      ; Come back here for 2d and 3d rounds

MESSAGE "  "
MESSAGE "  "
MESSAGE "     ͻ"
MESSAGE "                                                 "
MESSAGE "       1. Practice        6. IBMBBS              "
MESSAGE "       2. DSTORM          7. LOTUS A             "
MESSAGE "       3. IBMNEW          8. WPSG                "
MESSAGE "       4. IBMCOM          9. RPGAMES             "
MESSAGE "       5. IBMAPP          0. None of the above   "
MESSAGE "                                                 "
MESSAGE "     ͹"
MESSAGE "                                                 "
MESSAGE "      Enter the # of the forum to which          "
MESSAGE "      you wish to send a message:                "
MESSAGE "      Then press ENTER                           "
MESSAGE "     ͼ"

FIND S0 "1"        ; See what the counter is at
  IF FOUND         ; If counter is still at 1, 
    MESSAGE "  "   ; Then display this message:
    MESSAGE "         Ŀ"
    MESSAGE "          This is your first choice.  "
    MESSAGE "         "
  ELSE             ; Otherwise, look again at the counter
    FIND S0 "2"    ; Is it at 2?
      IF FOUND     ; If so, then display this message:
        MESSAGE "  "
        MESSAGE "     Ŀ"
        MESSAGE "             This is your second choice.         "
        MESSAGE "                                                 "
        MESSAGE "     To proceed with the choices already made,   "
        MESSAGE "     press ENTER without first pressing a number."
        MESSAGE "     "
      ELSE         ; Otherwise, display this message:
        MESSAGE "  "
        MESSAGE "     Ŀ"
        MESSAGE "             This is your third choice.          "
        MESSAGE "                                                 "
        MESSAGE "     To proceed with the choices already made,   "
        MESSAGE "     press ENTER without first pressing a number."
        MESSAGE "     "
      ENDIF 
  ENDIF
FIND S0 "1"        ; See if the counter is still at 1
  IF FOUND         ; If so, allow 3 extra lines (first instruction box)
    LOCATE 16 35   ; Position cursor at end of forum query line 
  ELSE             ; Otherwise, 
    LOCATE 13 35   ; Put cursor here
  ENDIF
GET S1 1           ; Get the number of target forum from user input 
                   ; Beep if more than 1 character is entered 
SWITCH S1          ; Switch on choice 

  CASE "1"              ;chose # 1 
    ASSIGN S2 "PRACTICE";assign to string 2 forum # 1 
  ENDCASE 

  CASE "2"              ;chose # 2 
    ASSIGN S2 "DSTORM"  ;assign to string 2 forum # 2 
  ENDCASE 

  CASE "3"              ;chose # 3 
    ASSIGN S2 "IBMNEW"  ;assign to string 2 forum # 3 
  ENDCASE 

  CASE "4"              ;chose # 4 
    ASSIGN S2 "IBMCOM"  ;assign to string 2 forum # 4 
  ENDCASE 

  CASE "5"              ;chose # 5 
    ASSIGN S2 "IBMAPP"  ;assign to string 2 forum # 5 
  ENDCASE 

  CASE "6"              ;chose # 6 
    ASSIGN S2 "IBMBBS"  ;assign to string 2 forum # 6 
  ENDCASE 

  CASE "7"              ;chose # 7 
    ASSIGN S2 "LOTUSA"  ;assign to string 2 forum # 7 
  ENDCASE 

  CASE "8"              ;chose # 8 
    ASSIGN S2 "WPSG"    ;assign to string 2 forum # 8 
  ENDCASE 

  CASE "9"              ;chose # 9 
    ASSIGN S2 "RPGAMES"  ;assign to string 2 forum # 9
  ENDCASE 

  CASE "0"              ;chose # 0 
    CLEAR
    LOCATE 12 5
    MESSAGE "You may type the name of a forum not shown above:"
    LOCATE 14 5
    MESSAGE "Then press ENTER."
    LOCATE 12 56
    GET S2
  ENDCASE 

  CASE "_NULL"     ; If user hits only <CR> 
    GOTO DO_IT     ; Execute the file with the choices made 
  ENDCASE 

  DEFAULT          ; If user selects something not on menu
    ALARM 1        ; Beep to get attention
    CLEAR          ; Clear the screen
    LOCATE 12, 29  ; Put cursor in middle of blank screen
    MESSAGE "Not a valid selection. " 
    LOCATE 14 35
    MESSAGE "Try again."
    PAUSE 2        ; Wait 2 seconds before proceeding
    CLEAR          ; Clear the screen before returning to menu
    FIND S0 "1"    ; See if counter still set at 1
      IF FOUND     ; If so, must be first go-round
        GOTO LOOP_0; Include the first instruction box
      ELSE         ; If counter set at 2 or 3
        GOTO LOOP_1; Return to menu (skip first instruction box)
      ENDIF
  ENDCASE 

ENDSWITCH 

CLEAR
LOOP_2:            ; Get the file name (and path)
MESSAGE "  "       
MESSAGE "  " 
MESSAGE "  ͻ"
MESSAGE "                                                          "
MESSAGE "   What is the name of the file on disk that has the      "
MESSAGE "                                                          "
MESSAGE "   message(s)?                                            "
MESSAGE "                                                          "
MESSAGE "  ͼ"
MESSAGE " "
MESSAGE " "
LOCATE 6 16        ; Position cursor at end of filename query
GET S3             ; Get name of file to send from user input
ISFILE S3          ; Test to see if that file exists
  IF NOT SUCCESS   ; If that file is not on disk, then
    GOTO ERROR_1   ; Jump to error message to giv'em another chance
  ENDIF
CLEAR

FIND S0 "1"        ; See if counter still set at 1
  IF FOUND         ; If it is,
    GOTO ROUND_1   ; Jump to this label
  ENDIF 

FIND S0 "2"        ; See if counter set is at 2
  IF FOUND         ; If it is,
    GOTO ROUND_2   ; Jump to this label
  ENDIF 

FIND S0 "3"        ; See if counter is set at 3
  IF FOUND         ; If it is,
    GOTO ROUND_3   ; Jump to this label
  ENDIF 

                   ; Storing the forum selections contained in S2 and
                   ; the filename selections contained in S3 in new 
                   ; variables allows S2 and S3 to be re-used
ROUND_1:           ; Label for this go-round
ASSIGN S4 S2       ; Store first forum selection in S4
ASSIGN S5 S3       ; Store first filename selection in S5
ASSIGN S0 "2"      ; Set the counter at 2
  GOTO LOOP_1      ; Return to menu for second go-round

ROUND_2: 
ASSIGN S6 S2       ; Store second forum selection in S6 
ASSIGN S7 S3       ; Store second filename selection in S7
ASSIGN S0 "3"      ; Set the counter at 3
  GOTO LOOP_1      ; Return to menu for last go-round

ROUND_3: 
ASSIGN S8 S2       ; Store third forum selection in S8
ASSIGN S9 S3       ; Store third filename selection in S9
ASSIGN S0 "4"     ; Set the counter at 4 
                   ; N.B. the third time is the last time
DO_IT:             ; The label for when user is done with selections
CLEAR              ; Clear the screen 

FIND S0 "1"        ; See if counter still set at 1
  IF FOUND         ; If so, then no forum was selected
                   ; User must have hit <CR> with no entry from menu
  MESSAGE "  ^M^J NO SELECTION MADE. COMMAND FILE TERMINATED."
  EXIT             ; End command file
  ENDIF

IF NOT LINKED      ; If this command file called by dialing from 
                   ; the dialing directory, then skip the dial command
   DIAL "#"        ; Dial directory entry for CIS 
                   ; **REPLACE NUMBER WITH CORRECT NUMBER FROM** 
                   ; ** YOUR DIALING DIRECTORY** 
ENDIF 
IF CONNECTED       ; See if connected, and if so, do this 
   TRANSMIT "^C"   ; Transmit Ctrl-C to ask for CompuServe  
   WAITFOR "User ID:"  ; Wait for "User ID:" to come in COM port 
   TRANSMIT "####,###^M"   ; Send user ID <CR>  
                   ; ** REPLACE WITH **
                   ; ** YOUR NUMBER** 
                   ; Note that the ^M is the symbol PCPLUS uses  
                   ; for <CR> and is not part of the user ID. 
   WAITFOR "Password:"         ; Wait for this to come in COM port 
   TRANSMIT "PPPPPPPPPP^M"   ; Send password and <CR> 
                   ; ** REPLACE WITH  ** 
                   ; ** YOUR PASSWORD ** 
                   ; Note that the ^M is the symbol PCPLUS uses 
                   ; for <CR> and is not part of the password. 
   ALARM           ; Sound alarm to let you know log-on completed 
ELSE 
   MESSAGE "^M^J  Did not connect--Try again."
   MESSAGE "^M^J  Command file terminated."
   EXIT 
ENDIF 
WAITFOR "!"       ; Wait for the prompt. 
                   ; Note that ! tells ProComm you want an 
                   ; exclamation mark and not a <CR>  
TRANSMIT "GO "     ; Start to tell CIS to go to target forum 
TRANSMIT S4        ; Now tell CIS the first target forum name 
TRANSMIT "^M"       ; Now send a carriage return 
WAITFOR "<CR> !"  ; Wait for the prompt 
SET SOFTFLOW ON    ; Set the terminal for xon/xoff flow control
                   ; to keep from choking the CIS computer
SENDFILE ASCII S5  ; Send the first file you picked 
ALARM 1            ; Beep for 1 second to signal that messages sent 
WAITFOR "!"       ; Wait for the prompt. 
FIND S0 "2"        ; See if counter still set at 2
  IF FOUND         ; If so, then no more forums selected
    MESSAGE "^M^J NO MORE FORUMS SELECTED. COMMAND FILE TERMINATED."
    EXIT           ; End command file
  ENDIF

TRANSMIT "GO "     ; Start to tell CIS to go to a forum 
TRANSMIT S6        ; Now tell CIS the second target forum name 
TRANSMIT "^M"       ; Now send a carriage return 
WAITFOR "<CR> !"  ; Wait for the prompt 
SENDFILE ASCII S7  ; Send the second file you picked 
ALARM 1            ; Beep for 1 second to signal that messages sent 
WAITFOR "!"       ; Wait for the prompt. 
FIND S0 "3"        ; See if counter still at 3
  IF FOUND         ; If so, then no more forums selected
    MESSAGE "^M^J THIS WAS SECOND AND LAST FORUM SELECTED."
    MESSAGE "^M^J        COMMAND FILE TERMINATED."
    EXIT           ; End command file
  ENDIF

TRANSMIT "GO "     ; Start to tell CIS to go to a forum 
TRANSMIT S8        ; Now tell CIS the third target forum name 
TRANSMIT "^M"       ; Now send a carriage return 
WAITFOR "<CR> !"  ; Wait for the prompt 
SENDFILE ASCII S9  ; Send the third file you picked 
ALARM 1            ; Beep for 1 second to signal that messages sent 
MESSAGE "^M^J THIS WAS THIRD AND LAST FORUM SELECTED."
MESSAGE "^M^J        COMMAND FILE TERMINATED."
EXIT               ; End command file
 
;  ***  SUBROUTINE AREA  *** 
; 
ERROR_1:     ; Jump here if file to be sent is not found on disk
     LOCATE 13 10 
     ALARM 1
     MESSAGE "            FILE NOT FOUND." 
     MESSAGE "  " 
     MESSAGE " (If the file is not in your current directory," 
     MESSAGE " precede the file name with the drive and path " 
     MESSAGE "            (e.g., b:\doc\msg.1)" 
     MESSAGE "  " 
     MESSAGE " To try again, press the Y key and then press ENTER: " 
     MESSAGE "  "
     MESSAGE " To end this command file, hit any other key now." 
     LOCATE 19 53
     GET S9 1      ; Get the response to the error message 
                   ; Beep if more than 1 character long 
     FIND S9 "y"   ; Look for a Y 
       IF FOUND    ; If got a Y, 
          CLEAR    ; Clear the screen 
          GOTO LOOP_2    ; And go back to loop_2 for another chance 
       ELSE        ; If any other key hit, do this 
          ALARM 1  ; Beep for one second
       CLEAR    ; Clear the screen
          LOCATE 12, 21  ; Put message in middle of blank screen
          MESSAGE "^M^J Y key not hit--COMMAND FILE TERMINATED"
          EXIT     ; End command file
       ENDIF 
; 
;AUTHOR:  Richard Burt, 71511, 3655
;Edited for PROCOMM PLUS version 1.1x by Holly Henry, 73727,406