proc main
ASSIGN S0 "1"                  ; Dialing directory entry for EXEC-PC
ASSIGN S1 "GEORGE"             ; first name
ASSIGN S2 "WASHINGTON"         ; Last name
ASSIGN S3 "PRESIDENT"          ; password
ASSIGN S4 "C:\PCPLUS\LOG\"     ; Drive:\path\ of where to create .LOG file.
                               ; Creating a C:\PCPLUS\LOG\ subdirectory
                               ; is a good idea to keep all log files in 
                               ; one place.  The log file will be
                               ; C:\TEMP\EXyymmdd.hhm
                               ; if this entry reads ASSIGN S4 "C:\TEMP\"

;*** IF NOT LINKED
if not fromddir
   DIAL S0                    ; Dial EXEC PC
ENDIF


GOSUB LOG_ON                    ; Get logged on (hopefully)
                                ; Note: doesn't wait for main menu.

GOSUB OPEN_LOG                  ; Open the log (capture buffer)

WAITFOR "SECURITY LEVEL" 300    ; Make sure we are at the top menu

EXIT

; -------------------------------------------------------------------------

endproc

;*** LOG_ON:                     ; Log onto EXEC-PC
proc LOG_ON

SEND_CR:
  WAITFOR "y/N) -> "
  TRANSMIT "Y^M"
   WAITFOR "name -> " 40
  IF NOT WAITFOR
     GOTO SEND_CR
  ENDIF

SET DISPLAY OFF     ; Turn OFF screen display so password won't be seen
TRANSMIT S1         ; Send first name
TRANSMIT ";"
TRANSMIT S2         ; Send last name
TRANSMIT ";"
TRANSMIT S3         ; Send password
TRANSMIT ";"
TRANSMIT "Q"        ; Bypass bulletin menus
TRANSMIT "^M"
RETURN

; -------------------------------------------------------------------------

endproc

;*** OPEN_LOG:
proc OPEN_LOG

LOG CLOSE             ; Take no chances--close the log in case it is open.


DATE S9               ; get date in MM/DD/YY format
TIME S8 1             ; Get time in HH:MM:SS 24-hour format

SUBSTR S0 S8 0 2      ; Copy hour to S0
SUBSTR S1 S8 3 1      ; Copy tens of minutes to S1
STRCAT S0 S1          ; Convert to HHT (Hours & tens of minutes)
ATOI   S0 N5          ; Convert HHT to an integer

SUBSTR S0 S9 6 2              ; Get year
SUBSTR S1 S9 0 2              ; Get month
STRCAT S0 S1                  ; S0 now has yymm
SUBSTR S1 S9 3 2              ; get day
STRCAT S0 S1                  ; S0 now has yymmdd

LOG_LOOP:
   STRFMT S5 "%sGW%s.%03d" S4 S0 N5  ; Build file name. (GW) Can be your
                                     ; initials in case you have several
                                     ; Accounts on Exec-Pc
   ISFILE S5                  ; Check to see if this file already exists
   IF SUCCESS                 ; I.e., if file already exists
      STRFMT S1 "FILE %s EXISTS!!! - Try next name." S5
      MESSAGE S1
      INC N5                  ; Increment counter
      GOTO LOG_LOOP           ; And try again
   ENDIF

WAITFOR "[ That name" 40
SET DISPLAY ON                ; Turn screen display back ON
LOG OPEN S5                   ; Open a log file
MESSAGE " "
STRFMT S1 "LogFile: %s On: %s %s O'Clock" S5 S9 S8
MESSAGE S1
MESSAGE " "

RETURN

; -------------------------------------------------------------------------


endproc
