DECLARE SUB MovCont ()
DECLARE SUB GetDir ()
DECLARE SUB DoOneConf ()
DECLARE SUB InConvNdx ()
DECLARE SUB OutConvNdx ()
DECLARE SUB StoreOneConf ()
DECLARE SUB SetNewFlag ()
DECLARE SUB GetNewConfNos ()
DECLARE SUB GetOldConfNos ()
DECLARE SUB OpenDatFile ()
DIM SHARED PointerList%(4000)

DIM SHARED OldConfNos$(50)
DIM SHARED NewConfNos$(50)

DIM SHARED CountNewConf%
DIM SHARED CountOldConf%
DIM SHARED MsgCount%
DIM SHARED NewFlag%
DIM SHARED MsgsInThisConf%

DIM SHARED OutConfStart&
DIM SHARED ConfNo$
DIM SHARED Boilerplate$
DIM SHARED DirName$

'Note:

'This program uses an environment variable QM1 to permit the ultimate user
'to specify the name of a directory where the various files used by this
'program will be located.  The user will create the directory specified by
'the environment variable QM1, will create under this directory two
'subdirectories WORK1 and HIST, and will specify the directory name by a
'SET statement in his autoexec.bat file.  In the annotation of this program
'the two subdirectories are referred to as \WORK1\ and \HIST\.

'At program start, \WORK1\ will contain all of the files created by
'unzipping the .QWK download packet to be processed by this program.
'\HIST\ will contain a pair of cumulatively increasing files for each
'conference number to be found in the various download packets which have
'already been processed by this program.  If a pair for a conference does
'not exist, the program will created a new pair.  The files are xxx.dat and
'xxx.ndx, the former being a cumulative history of all of the message data
'for conference xxx, xxx being a 3-digit number for the conference number
'as assigned by the BBS from which the .QWK packets have been downloaded.
'The second file xxx.ndx is a small file which contains pointers to the
'first block of each message in conference xxx.

'In the subdirectory \WORK1\ the file Messages.dat will contain (not in
'ASCII format) the text of the messages associated with the new unzipped
'download.  This information, in binary format, is in fixed blocks 128
'bytes long.  All of the messages for an individual conference follow one
'another in chronological sequence.  At the end of the group of messages
'for an individual conference a new message group for the next conference
'is appended, continuing until all conferences have been accommodated.

'This program separates the conference message groups and appends them to
'the end of the corresponding conference message files \HIST\xxx.dat.  It
'then appends the \HIST\xxx.ndx files to provide additional pointers for
'the new messages appended to \HIST\xxx.dat files.  These pointers will be
'numerically the same as the \WORK1\ xxx/ndx pointers in the newly unzipped
'new .QWK packet being processed by this program, but are numerically
'offset by a single additive constant to reflect the fact that the appended
'messages are added at the end of an already existing historic message base
'in \HIST\xxx.dat.

'The pointer numbers themselves are stored in MKS$ BASIC format (this is a
'.QWK standard) so the procedure in this program for manipulating these
'numbers is by no means obvious.

'The first 128 bytes of \WORK1\MESSAGES.DAT contains boilerplate text
'which must be present, although it contains no useful control information.
'This string, known as Boilerplate$ in this program, is abstracted from
'\WORK\MESSAGES.DAT and placed at the beginning of a new (but NOT and
'existing) \HIST\xxx.dat file so that the .QWK packet which ultimately will
'be created from \HIST\xxx.dat will have this boiler plate string at the
'beginning.

'In the following xxx=Conference number.
'#1=messages.dat from unzip of original .QWK packet.  It is in \WORK1\
'#2=old cumulative xxx.dat file.  It is in \HIST\
'#3=xxx.ndx file from unzip of original .QWK packet.  It is in \WORK1\
'#4=old cumulative xxx.ndx file   It is in \HIST\
'Files 2,3,and 4 are one per conference--they are opened and closed with a
'new xxx number in the filename during each conference pass ot the program.

CALL GetDir
CALL MovCont
CALL GetNewConfNos
CALL GetOldConfNos
CALL OpenDatFile
FOR Count% = 1 TO CountNewConf%
     ConfNo$ = NewConfNos$(Count%)
     CALL DoOneConf
NEXT Count%
CLOSE #1
z1$ = DirName$ + "\WORK1\*.*"
KILL z1$                                    'Delete all files in \WORK1\

END

SUB DoOneConf

'This sub, for each conference, appends the new conference data and new
'pointer list to the ends of the cumulative xxx.dat and xxx.ndx files.

CALL SetNewFlag     'Check if there is an existing conference .dat file
CALL InConvNdx      'Create the message start pointer array

z$ = DirName$ + "\HIST\" + ConfNo$ + ".dat"
OPEN z$ FOR BINARY AS #2
IF NewFlag% = 1 THEN PUT #2, , Boilerplate$
CALL StoreOneConf   'Append new messages to old conference message file
CALL OutConvNdx     'Append new pointer to old xxx.ndx pointer file

END SUB

SUB GetDir

'This sub obtains from the DOS Environment the location of the directory
'into which the program is loaded.  DirName$ is used by the various subs
'to create the names of the files for manipulation.

DirName$ = ENVIRON$("QM1")
a1% = LEN(DirName$)
IF a1% = 0 THEN
    PRINT "No QM1 environment variable found"
    END
END IF
z1$ = RIGHT$(DirName$, 1)
IF z1$ = "\" THEN
    DirName$ = LEFT$(DirName$, a1% - 1)     'Remove \ from end of DirName$
END IF

END SUB

SUB GetNewConfNos

'Run once per program execution to fill an array of three-digit integers
'(in text string) form NewConfNos$().  This array represents the numbers
'of the conferences in the .QWK download packet being processed.

'Read file names having .ndx extension in subdirectory \WORK1\. These are
'the pointer files for the various conferences that have been created by
'unzipping the new .QWK download packet.  Save the conference number
'for each .ndx file found as a three byte string (with leading zeroes if
'necessary).  Place these string identifiers in array NewConfNos$()
'Save the total number of conferences found as CountNewConf%.

CountNewConf% = 1
FileName$ = DirName$ + "\WORK1\*.ndx"
z$ = DIR$(FileName$)
IF LEN(z$) = 0 THEN
    CLS
    PRINT "No .NDX files from download packet found.  These files should"
    PRINT "have been in \WORK1\ after unzipping the new .QWK download packet"
    END
END IF

IF LEN(z$) < 8 THEN NewConfNos$(1) = LEFT$(z$, 3)

DO
    z$ = DIR$       'Note: DIR$ repeats without requiring the info in ()
    IF LEN(z$) = 0 THEN EXIT DO
    IF LEN(z$) < 8 THEN
        CountNewConf% = CountNewConf% + 1
        NewConfNos$(CountNewConf%) = LEFT$(z$, 3)
    ELSE
    END IF

LOOP WHILE LEN(z$) > 0
            
END SUB

SUB GetOldConfNos

'Read file names having .ndx extension in \HIST\ subdirectory.  These are
'the pointer lists for the conferences which have been accumulated in
'the \HIST subdirectory.  Save the conference number for each .ndx file
'as a three-byte string (with leading zeroes if necessary) in the array
'OldConfNos$()
'Save the total number of conferences found as CountOldConf%.
'This sub is executed only once, the resultant data being reused by each
'conference pass.  It is not necessary that an .ndx file be found for any
'particular conference, and indeed there may be no xxx.ndx files in \HIST\

CountOldConf% = 0

FileName$ = DirName$ + "\HIST\*.ndx"
z$ = DIR$(FileName$)
SELECT CASE LEN(z$)
    CASE 0                                  'do nothing
    CASE 1
        OldConfNos$(1) = LEFT$(z$, 3)
        CountOldConf% = 1
        DO
            z$ = DIR$
            IF LEN(z$) = 0 THEN EXIT DO
            CountOldConf% = CountOldConf% + 1
            OldConfNos$(CountOldConf%) = LEFT$(z$, 3)
        LOOP WHILE LEN(z$) > 0
END SELECT

END SUB

SUB InConvNdx

'This sub is run once for each conference present in the new .QWK packet
'being processed by this program

'This sub fills the array PointerList%() with pointers to the start of each
'message in the new packet for a particular conference number.  For example,
'the pointers for conference number 465 are derived from 465.ndx in the
'\WORK1\ subdirectory, which was one of the files created by unzipping the
'new download packet.

'The first entry in PointerList% is always 1--in the actual 465.ndx file the
'pointers are, except for the first conference in the download, offset to
'represent the conference message position part way dow a list of many
'conferences

'Input: The various xxx.ndx (xxx being a three digit representation of
'       the conference number) files created by simple unzipping of the
'       new .QWK packet.  These files are expected to be in \WORK1\
'       prior to executing this program.

'Output:PointerList%() for the conference now being processed.

'The pointers created are simple integers.  They are derived from the xxx.ndx
'files where they are represented numerically in MSK$ format, hence the
'weird looking instructions in this sub.


DIM MsStringIn AS STRING * 5

z3$ = DirName$ + "\WORK1\" + ConfNo$ + ".ndx"
OPEN z3$ FOR BINARY AS #3
MsgsInThisConf% = LOF(3) \ 5

GET #3, , MsStringIn
z1$ = LEFT$(MsStringIn, 4)
FirstPointer% = CVSMBF(z1$) - 1
PointerList%(1) = 1

FOR i% = 2 TO MsgsInThisConf%
    GET #3, , MsStringIn
    z1$ = LEFT$(MsStringIn, 4)
    PointerList%(i%) = CVSMBF(z1$) - FirstPointer%
NEXT i%

CLOSE #3

END SUB

SUB MovCont

'This sub moves the file Control.dat from \WORK1\ to \HIST\.  It will be
'needed when the files are re-zipped to form a conference .QWK packet, but
'is not used in this program. The most recent version of this file (it is
'an ASCII list of the conference numbers and names and changes only when the
'BBS adds new conferences) is always present in the unzipped .QWK packet
'information that exists in \WORK1\ at program start.

FileName$ = DirName$ + "\WORK1\control.dat"
x$ = DIR$(FileName$)
IF LEN(x$) = 0 THEN
    CLS
    PRINT "No control.dat file found in \WORK1\ subdirectory."
    PRINT "This file should be in \WORK\ subdirectory, along with the"
    PRINT "remainder of files created by unzipping th .QWK download packet."
    END
ELSE
    z1$ = DirName$ + "\WORK1\control.dat"
    z2$ = DirName$ + "\HIST\control.dat"
    z3$ = DIR$(z2$)
    IF z3$ = "CONTROL.DAT" THEN KILL z2$    'PB7.1 won't copy over existing
    NAME z1$ AS z2$

END IF

END SUB

SUB OpenDatFile

'This sub, run only once, opens the messages.dat file which was created by
'unzipping the new download .QWK packet before this program executes, and
'should be found in \WORK1\
'It then leaves it open as #1 throughout the entire program execution as
'a source of the message  data for the various conferences processed.
'It also reads the first record (128 bytes) of messages.dat. as Boilerplate$
'for use by sub DoOneConf to place the required header at the beginning
'of any new cumulative .dat file created.

FileName$ = DirName$ + "\WORK1\messages.dat"
z2$ = DIR$(FileName$)
IF LEN(z2$) = 0 THEN
    CLS
    PRINT "messages.dat file was not found in \WORK1\ subdirectory"
    PRINT "This file should have been placed in \WORK1\ after unzipping"
    PRINT "the new .QWK download packet before executing this program"
    END
ELSE
    OPEN FileName$ FOR BINARY AS #1
    Boilerplate$ = INPUT$(128, #1)
END IF

END SUB

SUB OutConvNdx

'This sub, run once for each conference, appends the new message start
'pointers to the old cumulative xxx.ndx file in the \HIST\ subdirectory,
'offestting the pointers in the current PointerList%() to reflect the fact
'that the appended pointers point to positions far down the existing
'xxx.dat file, whereas the pointer numbers in PointerList%(1) start at 1.
 
'OutConfStart& = length in bytes of \HIST\xxx.dat before this update.

DIM MsStringOut AS STRING * 4
DIM PadString AS STRING * 1

z3$ = DirName$ + "\HIST\" + ConfNo$ + ".ndx"
OPEN z3$ FOR BINARY AS #4

b1% = VAL(ConfNo$)
IF b1% > 255 THEN b1% = 0
PadString = CHR$(b1%)

NoOfRecords% = OutConfStart& \ 128
LenNdxFile% = LOF(4)
SEEK #4, LenNdxFile% + 1

FOR i% = 1 TO MsgsInThisConf%
    MsStringOut = MKSMBF$(PointerList%(i%) + NoOfRecords%)
    PUT #4, , MsStringOut
    PUT #4, , PadString
NEXT i%
CLOSE #4

END SUB

SUB SetNewFlag

'This sub, for each conference, checks through the list of alreadiy
'existing conference numbers OldConfNos$() which was created by sub
'GetOldConfNos to determine if the conference number has no cumulative
'history.  This situation, which is completely normal, arises when a
'completely new conference is added to the download mail packet, or when the
'cumulative conference xxx.dat file has, after becoming large enough to
'warrant zipping into a new conference xxx.qwk packet, been removed
'from the old cumulative history files (by a separate program).

NewFlag% = 1
FOR i% = 1 TO CountOldConf%
    z$ = OldConfNos$(i%)
    IF ConfNo$ = z$ THEN
        NewFlag% = 0
        EXIT FOR
    ELSE
    END IF
NEXT i%

END SUB

SUB StoreOneConf

'This sub, for each conference, appends the new messages to the existing
'cumulative message file for the conference.

'Input file is the messages.dat file in the \WORK1\ subdirectory. It is
'already open as #1.
'Output file is the xxx.dat file in the \HIST\ subdirectory for this
'conference number (xxx).  It is already open as #2.

OutConfStart& = LOF(2)
SEEK #2, OutConfStart& + 1                  'position output write pointer

LastMsgPoint% = PointerList%(MsgsInThisConf%)

c1% = LastMsgPoint% - 1
c2% = c1% \ 128                             'c2%=no of 16384 byte blocks
c3% = c1% MOD 128                           'c3%=no of bytes remainder

IF c1% > 0 THEN                             'read and store all messages
                                            'except last
    FOR i% = 1 TO c2%
        Msg$ = INPUT$(16384, #1)
        PUT #2, , Msg$
    NEXT i%
    Msg$ = INPUT$(128 * c3%, #1)
    PUT #2, , Msg$

ELSE
END IF

FirstLine$ = INPUT$(128, #1)                'First record of last message
PUT #2, , FirstLine$

z2$ = MID$(FirstLine$, 117, 6)
b1% = VAL(z2$)                              'b1%=no. of lines in last message
a3% = 128 * (b1% - 1)                       'a3%=no of bytes in remaining mes.

Remaining$ = INPUT$(a3%, #1)
PUT #2, , Remaining$

CLOSE #2

END SUB

