
(************************************************************************)

PROCEDURE Line(LineChr,
               LineLength,
               Color       : Integer);
VAR Counter : Integer;
begin
     textcolor(Color);
     for Counter := 1 to LineLength do
         begin
              write(chr(LineChr));
         end;
end;

(****************************************************************************)

FUNCTION ReadPause  : Boolean;
VAR x,y      : Integer;
    Question : Char;
LABEL Beginning;
begin
     while keypressed do
          begin
               X := whereX;
               Y := whereY;
               SETSCREEN(lightred+blink,black,0,65,1,79,1);
               OFFCURSOR;
               write('FILE PAUSED.');
               Beginning:
               Question := ReadKey;
               if Question = #27
                  then begin
                            READPAUSE := TRUE;
                            exit;
                       end;
               if Question <> #13 then goto Beginning;
               ONCURSOR;
               SETSCREEN(white,black,0,65,1,79,1);
               SETSCREEN(white,black,1,1,2,79,25);
               gotoxy(X,Y);
               READPAUSE := FALSE;
          end;
end;

(*****************************************************************************)

PROCEDURE LIST_TO_PRINTER(FileName : String);

CONST
  PageWidth = 80;
  PrintLength = 55;
  PathLength  = 65;
  FormFeed = #12;
  VerticalTabLength = 3;

TYPE
  WorkString  = String[126];

VAR
  CurRow      : Integer;
  MainFile    : Text;

{---------------------------------------------------------------------------}

PROCEDURE VerticalTab;
VAR i: integer;
begin
    for i := 1 to VerticalTabLength do Writeln(LST);
end {vertical tab};

{---------------------------------------------------------------------------}

PROCEDURE ProcessLine(PrintStr: WorkString);
begin
    CurRow := Succ(CurRow);
    if Length(PrintStr) > PageWidth then Inc(CurRow);
    if CurRow > PrintLength then
    begin
      Write(LST,FormFeed);
      VerticalTab;
      CurRow := 1;
    end;
    Writeln(LST,PrintStr);
end {Process line};

{---------------------------------------------------------------------------}

PROCEDURE ProcessFile(FileName : string);
  { This procedure displays the contents of the File to the Printer }

VAR
    LineBuffer: WorkString;

begin  {Process File}
    VerticalTab;
    while not EOF(mainfile) do
    begin
      Readln(MainFile,LineBuffer);
      ProcessLine(LineBuffer);
      if READPAUSE = TRUE then Exit;
    end;
    Close(MainFile);
    Write(LST,FormFeed); { move the printer to the beginning of the next }
                         { page }
end {Process File};

{---------------------------------------------------------------------------}
begin {List_To_Printer}
  CurRow := 0;
  assign(MainFile,FileName);
  reset(MainFile);
  ProcessFile(FileName);
end; {List_To_Printer}

(****************************************************************************)

PROCEDURE Read_File(VAR Config : ConfigRec);
VAR Source          : String;
    Chars,
    Mode,
    Question        : Char;
    DataFile        : File of Char;
    Modem,
    dbool           : Boolean;
begin
     WINDOWIN(white,blue,4,10,10,70,12,CursorCol,CursorRow,WindowPtr);
     textcolor(yellow);
     write(' Read Filename: ');
     textcolor(white);
     readln(Source);
     if length(Source) = 0 then
        begin
             WINDOWOUT(CursorCol,CursorRow,WindowPtr);
             exit;
        end;
     textcolor(yellow);
     SETSCREEN(black,black,0,10,10,70,12);
     MAKEWINDOW(white,blue,4,0,25,10,55,16);
     OFFCURSOR;
     textcolor(yellow);
     writeln('    Select Display Device');
     LINE(196,29,white);
     textcolor(yellow);
     writeln('         S - Screen ');
     writeln('         P - Printer');
     write('         M - Modem  ');
     Mode := ReadKey;
     Mode := UpCase(Mode);
     ONCURSOR;
     if not(Mode in ['M','P'])
        then Mode := 'S';
     if Mode = 'M'
        then Modem := True
        else Modem := False;
     SETSCREEN(white,black,0,1,1,80,25);
     SETSCREEN(white,black,0,1,1,80,1);
     write('Printing File: ');
     textcolor(yellow);
     write(Source);
     textcolor(white);
     write('     Mode: ');
     textcolor(yellow);
     case Mode of
         'M' : write('Modem  ');
         'S' : write('Screen ');
         'P' : write('Printer');
     end; {case}
     SETSCREEN(white,black,0,1,2,80,25);
     write('Press ENTER when Ready or ESC to Exit.');
     Question := readkey;
     if Question = #27 then
        begin
             WINDOWOUT(CursorCol,CursorRow,WindowPtr);
             exit;
        end;
     clrscr;
     assign(DataFile,Source);
     {$I-}
     reset(DataFile);
     {$I+}
     if IOResult <> 0 then
        begin
             MAKEWINDOW(yellow,red,4,0,31,11,49,13);
             textcolor(white+blink);
             OFFCURSOR;
             write(' File Not Found!',^G);
             repeat until KeyPressed;
             ONCURSOR;
             WINDOWOUT(CursorCol,CursorRow,WindowPtr);
             exit;
        end;
     if Mode = 'P'
        then begin
                  LIST_TO_PRINTER(Source);
                  SETSCREEN(red,white,0,1,1,80,1);
                  write('                   Printing Completed. Press Any Key.');
                  Question := readkey;
                  WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                  exit;
             end;
     while not eof(DataFile) do
         begin
              read(DataFile,Chars);
              ANSIDRIVER(Chars);
              if Modem = True
                 then begin
                           Async_Send(Chars);
                           delay(10);
                      end;
              if READPAUSE = True
                 then begin
                           WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                           exit;
                      end;
         end;
     close(DataFile);
     SETSCREEN(red,white,0,1,1,80,1);
     write('                   Printing Completed. Press Any Key.');
     Question := readkey;
     WINDOWOUT(CursorCol,CursorRow,WindowPtr);
end;

(****************************************************************************)

PROCEDURE ReturnBeep(VAR Config : ConfigRec);
VAR Lcv : Byte;
begin
    Lcv := 0;
    if Config.MuteMode = Off
       then
           repeat
              Sound(500);
              delay(50);
              Sound(1000);
              delay(50);
              Lcv := Lcv + 1;
           until KeyPressed or (Lcv = 30);
    nosound;
end;

(************************************************************************)
(*         Hex_To_Dec --- Convert hex string to decimal number          *)
(************************************************************************)

FUNCTION Hex_To_Dec( S : AnyStr; Default : Integer ) : Integer;

(************************************************************************)
(*                                                                      *)
(*     Function:   Hex_To_Dec                                           *)
(*                                                                      *)
(*     Purpose:    Convert hex string to decimal number                 *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*        Integ := Hex_To_Dec( S: AnyStr; Default: Integer ) : Integer; *)
(*                                                                      *)
(*           S       --- the hex string                                 *)
(*           Default --- value to return if S not hex string            *)
(*           Integ   --- corresponding decimal Integer (0 if bad)       *)
(*                                                                      *)
(************************************************************************)

VAR
   I  : Integer;
   Sum: Integer;

BEGIN (* Hex_To_Dec *)
   Sum        := 0;
   Hex_To_Dec := Default;
   FOR I := 1 TO LENGTH( S ) DO
      CASE S[I] OF
         '0'..'9':  Sum := Sum * 16 + ( ORD(S[I]) - ORD('0') );
         'A'..'F':  Sum := Sum * 16 + ( ORD(S[I]) - ORD('A') + 10 );
         ELSE       EXIT;
      END;
   Hex_To_Dec := Sum;
END   (* Hex_To_Dec *);

(************************************************************************)

PROCEDURE DisplayMenu;
begin
     textcolor(yellow);
     writeln('                    SunCom v1.0  -  By Boyd C. Fletcher IV');
     LINE(196,78,white);
     writeln;
     writeln('                                HELP MENU');
     writeln;
     writeln;
     textcolor(white);
     writeln('      ALT X                             ALT L ');
     writeln('      ALT O                             ALT D ');
     writeln('      ALT F                             ALT H ');
     writeln('      ALT V                             ALT C ');
     writeln('      ALT W                             ALT M ');
     writeln('      ALT E                             ALT K ');
     writeln('      ALT S                             ALT R ');
     writeln('      ALT Z                             ALT B ');
     writeln('      ALT U                             ALT P ');
     MAKEWINDOW(yellow,blue,0,1,13,7,79,23);
     writeln('- Exit SunCom');
     writeln('- Configure');
     writeln('- Read a Text File');
     writeln('- Directory');
     writeln('- Clear Screen');
     writeln('- Toggle Echo ON/OFF');
     writeln('- Upload / Send');
     writeln('- Shell To Dos');
     writeln('- Capture Buffer Menu');
     MAKEWINDOW(yellow,blue,0,1,48,7,79,23);
     writeln('- Toggle Linefeeds ON/OFF');
     writeln('- Phone Book');
     writeln('- Hang Up');
     writeln('- Toggle Chat Mode ON/OFF');
     writeln('- Toggle Mute Mode ON/OFF');
     writeln('- Define Macro Keys');
     writeln('- Download / Receive');
     writeln('- Toggle Backspace ^H/<DEL>');
     writeln('- Toggle Buffer Pause ON/OFF');
     writeln;
     MAKEWINDOW(white,blue,0,1,22,18,79,23);
     writeln('ALT Q - This Screen (HELP SCREEN)');
end;

(****************************************************************************)

PROCEDURE Upload(VAR Config : ConfigRec);
VAR Source,
    Message,
    WkStr,
    FileName   : String[80];
    LCV        : Integer;
    Counter,
    Choice     : Char;
    ProtoList  : Set of 'A'..'Z';
    dBool      : Boolean;
LABEL Beginning;
begin
     WINDOWIN(white,blue,4,10,10,70,12,CursorCol,CursorRow,WindowPtr);
     FileName := ' ';
     textcolor(yellow);
     write('Upload FileName: ');
     textcolor(white);
     readln(FileName);
     if length(FileName) = 0 then
        begin
             WRITELN(^g);
             WINDOWOUT(CursorCol,CursorRow,WindowPtr);
             exit;
        end;
     SETSCREEN(white,black,0,1,1,80,24);
     MAKEWINDOW(white,blue,4,0,20,3,60,22);
     textcolor(yellow);
     writeln('         Select Upload Protocol');
     LINE(196,39,white);
     textcolor(yellow);
     writeln;
     ProtoList := [];
     with Config do
     begin
     for Counter := 'A' to 'G' do
        begin
           writeln(Counter:10,' - ',Protocols[Counter].Name);
           if Protocols[Counter].Flag = 1 then ProtoList := ProtoList + [Counter];
        end; {for}
     writeln;
     LINE(196,39,white);
     textcolor(yellow);
     writeln('         Z - Internal Zmodem');
     LINE(196,39,white);
     textcolor(lightgray);
     writeln;
     writeln('       ESC - To Exit');
     textcolor(yellow);
     writeln;
     write('   Select: ');
     Choice := Readkey;
     Choice := Upcase(Choice);
     if Choice in (ProtoList + ['Z']) then
        begin
             Source := ' /C ' + Protocols[Choice].Up
        end
        else begin
                  WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                  exit;
             end;
    str(BaudRate,WkStr);
    CASE ComPort OF
       1 : Message := Source + ' ' + WkStr + ' 1 ' + FileName;
       2 : Message := Source + ' ' + WkStr + ' 2 ' + FileName;
       3 : Message := Source + ' ' + WkStr + ' 3 ' + FileName;
       4 : Message := Source + ' ' + WkStr + ' 4 ' + FileName;
    end; {case}
    SETSCREEN(white,black,0,1,1,80,25);
    writeln('Sending File ',FileName);
    writeln(message);
    chdir(Config.FilesPath);
    if Choice = 'Z' then
       begin
            WINDOWOUT(CursorCol,CursorRow,WindowPtr);
            dBool := Zmodem_Send(FileName,TRUE,ComPort,BaudRate);
            ReturnBeep(Config);
       end
       else begin
                 swapvectors;
                 exec(getenv('comspec'),Message);
                 swapvectors;
                 writeln;
                 write('Press ENTER to return to SunCom.');
                 ReturnBeep(Config);
                 WINDOWOUT(CursorCol,CursorRow,WindowPtr);
            end;
    end; {with}
end;

(****************************************************************************)

PROCEDURE Download(VAR Config : ConfigRec);
VAR Source,
    Message,
    WkStr,
    DirPath    : String[80];
    LCV        : Integer;
    Counter,
    Choice     : Char;
    ProtoList  : Set of 'A'..'Z';
    dBool      : Boolean;
LABEL Beginning;
begin
     WINDOWIN(white,blue,4,10,10,70,12,CursorCol,CursorRow,WindowPtr);
     DirPath := ' ';
     textcolor(yellow);
     write('Download Path: ');
     textcolor(white);
     readln(DirPath);
     if length(DirPath) = 0 then
        begin
             WRITELN(^g);
             WINDOWOUT(CursorCol,CursorRow,WindowPtr);
             exit;
        end;
     SETSCREEN(white,black,0,1,1,80,24);
     {$I-}
     chdir(DirPath);
     {$I+}
     if (length(DirPath) = 2) and (DirPath[2] = ':')
        then DirPath := DirPath + '\'
        else if DirPath[length(DirPath)] = '\'
                then delete(DirPath,Length(DirPath),1);
     if IOresult <> 0 then
        begin
             MAKEWINDOW(white,red,4,0,22,9,57,11);
             textcolor(yellow);
             write(' Disk Error - Invalid Directory! '^G^G);
             delay(3500);
             WINDOWOUT(CursorCol,CursorRow,WindowPtr);
             exit;
        end;
     MAKEWINDOW(white,blue,4,0,20,3,60,22);
     textcolor(yellow);
     writeln('        Select Download Protocol');
     LINE(196,39,white);
     textcolor(yellow);
     writeln;
     ProtoList := [];
     with Config do
     begin
     for Counter := 'A' to 'G' do
        begin
           writeln(Counter:10,' - ',Protocols[Counter].Name);
           if Protocols[Counter].Flag = 1 then ProtoList := ProtoList + [Counter];
        end; {for}
     writeln;
     LINE(196,39,white);
     textcolor(yellow);
     writeln('         Z - Internal Zmodem');
     LINE(196,39,white);
     textcolor(lightgray);
     writeln;
     writeln('       ESC - To Exit');
     textcolor(yellow);
     writeln;
     write('   Select: ');
     Choice := Readkey;
     Choice := Upcase(Choice);
     if Choice in (ProtoList + ['Z']) then
        begin
             Source := ' /C ' + Protocols[Choice].Down
        end
        else begin
                  WINDOWOUT(CursorCol,CursorRow,WindowPtr);
                  exit;
             end;
    str(BaudRate,WkStr);
    CASE ComPort OF
       1 : Message := Source + ' ' + WkStr + ' 1 ';
       2 : Message := Source + ' ' + WkStr + ' 2 ';
       3 : Message := Source + ' ' + WkStr + ' 3 ';
       4 : Message := Source + ' ' + WkStr + ' 4 ';
    end; {case}
    SETSCREEN(white,black,0,1,1,80,25);
    writeln('Receiving Files to Directory ',DirPath);
    chdir(Config.FilesPath);
    if Choice = 'Z' then
       begin
            WINDOWOUT(CursorCol,CursorRow,WindowPtr);
            dBool := Zmodem_Receive(DirPath,ComPort,BaudRate);
            ReturnBeep(Config);
       end
       else begin
                 swapvectors;
                 exec(getenv('comspec'),Message);
                 swapvectors;
                 writeln;
                 write('Press ENTER to return to SunCom.');
                 ReturnBeep(Config);
                 WINDOWOUT(CursorCol,CursorRow,WindowPtr);
            end;
    end; {with}
end;

(****************************************************************************)

PROCEDURE Shell_To_Dos;
begin
     WINDOWIN(white,blue,0,1,1,80,25,CursorCol,CursorRow,WindowPtr);
     SETSCREEN(white,black,0,1,1,80,25);
     writeln('Type EXIT to return to HandyComm.');
     swapvectors;
     exec(getenv('comspec'),' /C prompt $p$g');
     exec(getenv('comspec'),'');
     swapvectors;
     WINDOWOUT(CursorCol,CursorRow,WindowPtr);
end;

(****************************************************************************)
