// chat.c

#define INCL_DOSPROCESS 
#define INCL_GPICONTROL 
#define INCL_WINSYS
#define INCL_WINDIALOGS
#define INCL_WININPUT
#define INCL_WINMESSAGEMGR 
#define INCL_WINENTRYFIELDS 
#define INCL_WINWINDOWMGR 
#define INCL_WINFRAMEMGR 

#include <stdlib.h>
#include <string.h>

#include "term.h"
#include "res\dialog2.h"

#define ENTRY_SIZE 255					// length of entry field
#define HISTORY_MEM_SIZE 4096			// size of history buffer
#define ENTRY_HIGH 16					// height of entry field
#define ENTRY_SPACE 15					// left and right space of entryfield

#define ADD_ENTRY  1
#define QUERY_NEXT 2
#define QUERY_PREV 3

static ch_NormHeight;

static PFNWP ch_OldEntryProc;    /* Original entry field window procedure */
static MRESULT EXPENTRY ch_SubEntryWinProc(HWND, ULONG, MPARAM, MPARAM);
static BOOL history(int, char*, int);

/***********************************************************************
*   Window procedure for status window                                 *
*                                                                      *
*                                                                      *
***********************************************************************/
MRESULT EXPENTRY 
ch_ChatWinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
	MRESULT rc= (MRESULT)FALSE;
	HWND hwndEntry;
	RECTL rcl;
	HPS hps;

	switch (msg) {

		case WM_INITDLG:
			WinQueryWindowRect(hwnd, &rcl);
			ch_NormHeight= rcl.yTop;
			WinSendDlgItemMsg(hwnd, DLG_CHAT_ENTRY, EM_SETTEXTLIMIT,
									MPFROMSHORT(ENTRY_SIZE), 0L);
			ch_OldEntryProc= WinSubclassWindow(hwnd, ch_SubEntryWinProc);
			break;

		case WM_PAINT:
			rc= (MRESULT)TRUE;
			hps= WinBeginPaint(hwnd, NL, &rcl);
			WinFillRect(hps, &rcl, SYSCLR_DIALOGBACKGROUND);
			msc_NiceBorder(hwnd, hps, 1);
			WinEndPaint(hps);
			break;

		case WM_ERASEBACKGROUND:
			rc= (MRESULT)TRUE;
			break;

		case WM_SIZE:
			WinQueryWindowRect(hwnd, &rcl);
			if((rcl.yTop-rcl.yBottom) >= ENTRY_HIGH)
			{
				hwndEntry= WinWindowFromID(hwnd, DLG_CHAT_ENTRY);			
				WinSetWindowPos(hwndEntry, 0,
					ENTRY_SPACE, (((rcl.yTop-rcl.yBottom)-ENTRY_HIGH)/2),
					(rcl.xRight-rcl.xLeft)-ENTRY_SPACE*2, ENTRY_HIGH, 
					SWP_SIZE |SWP_MOVE | SWP_SHOW);
			}
			break;

		default:
			rc= (MRESULT) WinDefWindowProc(hwnd, msg, mp1, mp2);
			break;
	}
	return (rc);
}


/***********************************************************************
*   Show or hide statusline (that means size to height or 0)           *
*                                                                      *
*                                                                      *
***********************************************************************/
void
ch_ShowChat(BOOL show)
{
	RECTL rcl;

	WinQueryWindowRect(hwndStatus, &rcl);

	if (show)	
		rcl.yTop= ch_NormHeight;
	else
		rcl.yTop= 0;

	WinSetWindowPos(hwndChat, 0, 0, 0, rcl.xRight, rcl.yTop,
				SWP_SIZE | SWP_SHOW);

	WinEnableControl(hwndChat, DLG_CHAT_ENTRY, show);
}




/***********************************************************************
*   Subclassed window procedure for entry field to handle special      *
*   keys                                                               *
*                                                                      *
***********************************************************************/
MRESULT EXPENTRY 
ch_SubEntryWinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
	MRESULT rc= (MRESULT)FALSE;
	USHORT ch_flags, ch_virt;
	char buffer[ENTRY_SIZE+1];
	int buflen= 0;
	BOOL success;

	ch_flags = SHORT1FROMMP(mp1);
	ch_virt = SHORT2FROMMP(mp2);

	switch (msg)
	{
		case WM_CHAR:
		{
			if((ch_flags & KC_VIRTUALKEY)!=0 && (ch_flags & KC_KEYUP)==0)
			{
				if(ch_virt == VK_ENTER || ch_virt == VK_NEWLINE)
				{
					buflen= WinQueryDlgItemText(hwnd, DLG_CHAT_ENTRY, 
										sizeof(buffer), buffer);
					if(buflen > 0)
					{
						buflen++;
						buffer[buflen]= '\0';
						history(ADD_ENTRY, buffer, buflen); 
						buffer[buflen-1]= '\r';
					}

					WinSetDlgItemText(hwnd, DLG_CHAT_ENTRY, "");
					AscSendBuffer(buffer, buflen, FALSE);
					
					break;
				}
			
				if(ch_virt == VK_UP)	// cursor up
				{
					success= history(QUERY_PREV, buffer, 0); 
					
					if(success)
					WinSetDlgItemText(hwnd, DLG_CHAT_ENTRY, buffer);
					
					break;	
				}
				
				if(ch_virt == VK_DOWN)	// cursor down
				{
					success= history(QUERY_NEXT, buffer, 0); 

					if(success)
					WinSetDlgItemText(hwnd, DLG_CHAT_ENTRY, buffer);
					else
					WinSetDlgItemText(hwnd, DLG_CHAT_ENTRY, "");

					break;	
				}
			}
			goto DefProc;
		}
		
		default:
		DefProc:
			rc= (MRESULT) ch_OldEntryProc(hwnd, msg, mp1, mp2);
			break;
	}

	return (rc);
}


/***********************************************************************
*   History handle of chat data packets.                               * 
*                                                                      *
*   ADD_ENTRY adds an new packet to history                            *
*   QUERY_NEXT requests next packet in history                         *
*   QUERY_PREV requests previous packet in history                     *
*                                                                      *
***********************************************************************/
BOOL history(int action, char* buffer, int buflen)
{
	static char data[HISTORY_MEM_SIZE]= "";
	static char* akt_ptr= data;
	static char* start_ptr= data;
	static char* end_ptr= data + HISTORY_MEM_SIZE-1;
	static char* search_ptr= data;

	BOOL rc= FALSE;


	switch(action)
	{
		case ADD_ENTRY:
		{
			// lschen, bis neuer Datensatz ans Ende pat 
			while((end_ptr-akt_ptr) < buflen)
			{
				char *i;
				int len= 0;

				// bis zur nchsten 0 gehen
				for(i=start_ptr; i<end_ptr && *i!=0; i++,len++) {;}
				memmove(start_ptr, i+1, HISTORY_MEM_SIZE-(len+1)); 
				akt_ptr -= len+1;
			}

			// neuen Datensatz schreiben
			strcpy(akt_ptr, buffer);
			akt_ptr += buflen;

			// Suchzeiger auf das Ende des letzten Satzes setzen
			search_ptr= akt_ptr-1;

			rc= TRUE;
			break;
		}

		case QUERY_NEXT:
		{
			// einen Eintrag berlesen, wenn noch nicht am aktuellen Ende
			if(search_ptr+1 < akt_ptr)
				do search_ptr++; while(search_ptr<akt_ptr && *search_ptr!=0);

			// wenn noch nicht am Ende, neuen Satz lesen
			if(search_ptr+1 < akt_ptr)
			{
				if(*search_ptr == 0)
					strcpy(buffer, search_ptr+1);
				else							// Zeiger steht ganz am Anfang
					strcpy(buffer, search_ptr);

				rc= TRUE;
				break;
			}
			break;
		}

		case QUERY_PREV:
		{
			// wenn noch nicht am Anfang, neuen Satz lesen
			if(search_ptr > start_ptr)
			{
				// bis zur vorherigen 0 gehen
				do search_ptr--; while(search_ptr>start_ptr && *search_ptr!=0);
				
				if(*search_ptr == 0)
					strcpy(buffer, search_ptr+1);
				else							// Zeiger steht ganz am Anfang
					strcpy(buffer, search_ptr);

				rc= TRUE;
				break;
			}
			break;
		}

		default:
			break;
	}		

	return(rc);
}

