;  ProComm+ logon script for Portal accessed via Telenet or PC Pursuit
;  Released to the public domain by K. Patz
;
;  S1 = "c portal,id,password^M"; id,password is PC Pursuit ID and password
;  if not using PC Pursuit, S1 = "c portal^M"
;
;  S2 = your Portal user name followed by ^M
;  S3 = your Portal password followed by ^M

ASSIGN S1 "c portal,pcpid,pcppassword^M"   ;*** Include PC Pursuit ID/pswd
ASSIGN S2 "Your User Name^M"               ;*** Portal user name
ASSIGN S3 "YourPortalPassword^M"           ;*** Portal password

SET DATABITS 8              ; Select 8 bits no parity
SET PARITY NONE             ; so Telenet messages come in clear
IF LINKED
    GOTO SKIPDIAL
ENDIF
REDIAL:
HANGUP
DIAL "5"                    ;*** Change to Telenet/Portal entry in dialing dir
SKIPDIAL:
PAUSE 1
TRANSMIT "^M"               ;Send CR D CR Telenet 8 bits no parity
PAUSE 1
TRANSMIT "D^M"
WAITFOR "TERMINAL="
PAUSE 1
TRANSMIT "^M"               ;Response to TERMINAL= prompt
WAITFOR "@"
LOOP:
PAUSE 1
TRANSMIT S1                 ;Send Telenet connect command and PCP info
WAITFOR "moment, please" 20 ;Wait for initial Portal message
IF NOT WAITFOR              ;Retry if not received
    GOTO RETRY
ENDIF
WAITFOR "INFO, or HELP:" 120   ;Wait for Portal user ID prompt
IF NOT WAITFOR
    GOTO RETRY              ;If it doesn't appear, error
ENDIF
PAUSE 1
SET PARITY NONE             ;Select 8 bits no parity for Portal
SET DATABITS 8          
TRANSMIT S2                 ;Send user name
WAITFOR "password: "        ;Wait for password prompt
PAUSE 1
TRANSMIT S3                 ;Send password
;
; ** If you don't want to have this script file change your default setting
;    to pseudonym, delete this code up to the "END OF PSEUDONYM CODE" comment.
;
WAITFOR "URN> to continue" 120 ;Wait for prompt at end of opening msg
IF NOT WAITFOR
    GOTO RETRY
ENDIF
PAUSE 1
TRANSMIT "^M"               ;Respond by sending CR
WAITFOR "Command: " 120     ;Wait for main menu command line
IF NOT WAITFOR
    GOTO RETRY
ENDIF
PAUSE 1
TRANSMIT "7;3;;1;TOP^M"     ;Go to user settings, select pseudonym, goto TOP
;
; **  END OF PSEUDONYM CODE
;
PAUSE 5
TRANSMIT "^M"
TERMINAL                    ; We're all done!!!!!

RETRY:                   ;Retry 10 times if failure to reach Portal
    WAITFOR "@" 15        ;Wait for Portal to return to Telenet
    IF NOT WAITFOR
        TRANSMIT "^M"     ;Send carriage return to reestablish @ prompt
        WAITFOR "@" 5
            IF NOT WAITFOR
            TRANSMIT "@^M"    ;Return to Telenet if Portal doesn't disconnect
            WAITFOR "@" 10
            IF NOT WAITFOR
                GOTO REDIAL
            ENDIF
            TRANSMIT "D^M"    ;Disconnect from Portal
        ENDIF
    ENDIF
    GOTO LOOP
