TITLE "Mail Run Script for Specific Range of Conferences"
;----------------------------------------------------------------------
;
; BBS Macros used in this script:
;
;   32      More?
;   41      Start Mail Download
;   42      Start Mail Upload
;   43      Packet Transfer Confirmation.
;   44      No Mail to Download
;
;----------------------------------------------------------------------
PARAMETER 1 "Mail Scan Starting Conference Number"
PARAMETER 2 "Mail Scan Ending Conference Number  "
PARAMETER 3 "Send Replies? (Y/N)"
PARAMETER 4 "Hang up after mail run? (Y/N)"
ENDPARAMS
   
    IF EMPTY "%P1%" GOTO PARAM_ERROR
    IF EMPTY "%P2%" GOTO PARAM_ERROR
    IF EMPTY "%P3%" GOTO PARAM_ERROR
    IF EMPTY "%P4%" GOTO PARAM_ERROR

    ; Default to ten minutes to scan for mail.
    ; Edit this if desired.
    TIMEOUT 600

    ; Get to mail door
    VENUE MAIL
 
    IF YES "%P3%" GOTO SENDREP
    GOTO GETMAIL

:SENDREP 
    ; Send Replies if present
    IF NOT EXIST "%REPDIR%%ID%.REP" GOTO NOREP
    SEND "U|"
    WAITFOR "%BBS42%" FAILURE GOTO I_AM_LOST
    MESSAGE "Uploading %REPDIR%%ID%.REP"
    UPLOAD "%REPDIR%%ID%.REP" USING "%BBS21%"
    ; Will keep up to 9 old rep packets.  Edit if desired.
    RENUMBER "%REPDIR%%ID%.REP" 9
    GOTO GETMAIL 

:NOREP
    MESSAGE "No %REPDIR%%ID%.REP to send"

:GETMAIL
    ; Request the mail packet
    SEND "D %P1%-%P2%|"

    WHEN "%BBS43%" SEND "Y|"
    WHEN "%BBS44%" GOTO ENDRUN
    WAITFOR "%BBS41%" FAILURE GOTO SLOW_BBS

    ; Keep 9 old QWK packets by default.
    ; Edit this if desired.
    IF EXIST "%QWKDIR%%ID%.QWK" RENUMBER "%QWKDIR%%ID%.QWK" 9

    ; Download the QWK packet.
    MESSAGE "Downloading %QWKDIR%%ID%.QWK"
    DOWNLOAD "%QWKDIR%%ID%.QWK" USING "%BBS22%"

    GOSUB GET_TO_COMMAND
    GOTO GETMAIL

:ENDRUN
    IF YES "%P4%" GOTO DROP_CARRIER
    GOSUB GET_TO_COMMAND
    SEND "Q|"
EXIT 0

:DROP_CARRIER
    MESSAGE "Dropping carrier per request"
    HANGUP
EXIT 0

:GET_TO_COMMAND
    SEND "|"
    CLEAR
    WHEN "%BBS32%" SEND "|"
    WHEN "to continue..." SEND "|"
    WAITFOR "%BBS40%" FAILURE GOTO I_AM_LOST
RETURN
 
:SLOW_BBS
    MESSAGE "^UERROR:^U Timeout during mail run."
    HANGUP
    CLOSE
EXIT 1

:I_AM_LOST
    MESSAGE "^UERROR:^U Sorry - I am lost."
    HANGUP
    CLOSE
EXIT 1

:PARAM_ERROR
    MESSAGE "^UERROR:^U All parameters are required!"
    CLOSE
EXIT 1

;eof
