' $title: 'ANSIChat Vertical Split Screen Chat for RBBS-PC v17.4x'
'
'          (c) 1991,1992 By Richie Molinelli
'
'
' $INCLUDE: 'RBBS-VAR.BAS'
'
' $SUBTITLE: 'ANSIChat - Vertical Split Screen SysOp ANSI Chat Routine'
'
' $PAGE
'
'  SUBROUTINE NAME   -  ANSIChat
'
'            INPUT   -  None
'
'           OUTPUT   -  None
'
'  PURPOSE -- Allows Vertical Split Screen ANSI SysOp Chat for RBBS
'
'
1000 SUB ANSIChat STATIC               ' Main program
     CALL ClearScrn
     CALL Decorate
     CALL SysopVChat
     CALL ClearScrn
     CALL SkipLine (1)
     END SUB
'
2000 SUB Decorate STATIC               ' Sets up the screen for chat
     ScreenTxt$ = STRING$(78,177)
     AC1$ = "[1;40;34m"               ' Blue
     AC2$ = "[1;40;31m"               ' Red
     CALL CurLocate (1,1)
     CALL QuickTPut (AC1$ + ScreenTxt$,0)
     CALL CurLocate (24,1)
     CALL QuickTput (ScreenTxt$,0)
     CALL CurLocate (1,1)
     CALL QuickTPut (ZEmphasizeOn$ + "ANSIChat v1.3",0)
     OutTxt$ =  " >>> " +  ZRBBSName$ + " <<< "
     LocalColumn = 40 - (LEN(OutTxt$)/2)
     CALL CurLocate (1,LocalColumn)
     CALL QuickTPut (OutTxt$,0)
     CALL CurLocate (1,60)
     CALL QuickTPut ("(c) 1992 R Molinelli",0)
     Column = 40
     CALL QuickTPut (AC2$,0)
     FOR Row = 2 TO 23
        CALL CurLocate (Row,Column) : _
        CALL QuickTPut(STRING$(1,186),0) : _
     NEXT Row
     OutTxt$ = ZSysopFirstName$ + " " + ZSysopLastName$
     LocalColumn = (40 - LEN(OutTxt$))/2
     CALL CurLocate (24,LocalColumn)
     CALL QuickTPut (ZEmphasizeOn$ + OutTxt$,0)
     LocalColumn = 40 + ((40 - LEN(ZActiveUserName$))/2)
     CALL CurLocate (24,LocalColumn)
     CALL QuickTPut (ZActiveUserName$ + ZEmphasizeOff$,0)
     CALL Line25
     CALL CurLocate (2,1)
     END SUB
'
3000 SUB RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,Bs) STATIC  ' Writes Remote Users Input
     IF HoldRTxt$ <> "" AND Bs = 1 THEN _
        HoldRTxt$ = MID$(HoldRTxt$,1,LEN(HoldRTxt$) - 1)
     IF Bs = 1 THEN _
        RemoteColumn = RemoteColumn - 1 : _
        RemoteTxt$ = " " : _
        GOSUB 3010 : _
        Bs = 0 : _
        GOTO 3020
     IF LEN(HoldRTxt$) => 38 THEN
        HoldRTxt$ = ""
        RemoteColumn = 42
        RemoteRow = RemoteRow + 1
        IF RemoteRow > 23 THEN _
           CALL ClearRemoteUpper : _
           RemoteRow = 2
        CALL CurLocate (RemoteRow,RemoteColumn)
     END IF
     IF RemoteTxt$ <> " " THEN _
        HoldRTxt$ = HoldRTxt$ + RemoteTxt$ _
     ELSE _
        HoldRTxt$ = ""
     IF RemoteColumn > 78 AND RemoteTxt$ = " " THEN
        RemoteColumn = 42
        RemoteRow = RemoteRow + 1
        IF RemoteRow = 12 THEN _
           CALL ClearRemoteLower
        IF RemoteRow > 23 THEN _
           CALL ClearRemoteUpper : _
           RemoteRow = 2
        CALL CurLocate (RemoteRow,RemoteColumn)
        RemoteTxt$ = ""
        HoldRTxt$ = ""
        EXIT SUB
     END IF
     IF RemoteColumn > 79 AND RemoteTxt$ <> " " THEN
        RemoteColumn = 80 - LEN(HoldRTxt$)
        HoldCTxt$ = STRING$((LEN(HoldRTxt$) + 1),32)
        CALL CurLocate (RemoteRow,RemoteColumn)
        CALL QuickTPut (HoldCTxt$,0)
        RemoteColumn = 42
        RemoteRow = RemoteRow + 1
        IF RemoteRow = 12 THEN _
           CALL ClearRemoteLower
        IF RemoteRow > 23 THEN _
           CALL ClearRemoteUpper : _
           RemoteRow = 2
        CALL CurLocate (RemoteRow,RemoteColumn)
        CALL QuickTPut (ZFG2$ + HoldRTxt$,0)
        RemoteColumn = RemoteColumn + LEN(HoldRTxt$)
        CALL CurLocate (RemoteRow,RemoteColumn)
        ZRemoteTxt$ = ""
        EXIT SUB
     END IF
3010 CALL CurLocate (RemoteRow,RemoteColumn)
     CALL QuickTPut (ZFG2$ + RemoteTxt$,0)
     IF Bs > 0 THEN _
        CALL CurLocate (RemoteRow,RemoteColumn) : _
        RETURN
     RemoteColumn = RemoteColumn + LEN(RemoteTxt$)
3020 RemoteTxt$ = ""
     END SUB
'
4000 SUB LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,Bs) STATIC      ' Writes Local Users Input
     IF HoldLTxt$ <> "" AND Bs = 1 THEN _
        HoldLTxt$ = MID$(HoldLTxt$,1,LEN(HoldLTxt$) - 1)
     IF Bs = 1 THEN _
        LocalColumn = LocalColumn - 1 : _
        LocalTxt$ = " " : _
        GOSUB 4010 : _
        Bs = 0 : _
        GOTO 4020
     IF LEN(HoldLTxt$) => 38 THEN
        HoldLTxt$ = ""
        LocalColumn = 1
        LocalRow = LocalRow + 1
        IF LocalRow > 23 THEN _
           CALL ClearLocalUpper : _
           LocalRow = 2
        CALL CurLocate (LocalRow,LocalColumn)
     END IF
     IF LocalTxt$ <> " " THEN _
        HoldLTxt$ = HoldLTxt$ + LocalTxt$ _
     ELSE _
        HoldLTxt$ = ""
     IF LocalColumn > 37 AND LocalTxt$ = " " THEN
        LocalColumn = 1
        LocalRow = LocalRow + 1
        IF LocalRow = 12 THEN _
           CALL ClearLocalLower
        IF LocalRow > 23 THEN _
           CALL ClearLocalUpper : _
           LocalRow = 2
        CALL CurLocate (LocalRow,LocalColumn)
        LocalTxt$ = ""
        HoldLTxt$ = ""
        EXIT SUB
     END IF
     IF LocalColumn > 38 AND LocalTxt$ <> " " THEN
        LocalColumn = 39 - LEN(HoldLTxt$)
        HoldCTxt$ = STRING$((LEN(HoldLTxt$) + 1),32)
        CALL CurLocate (LocalRow,LocalColumn)
        CALL QuickTPut (HoldCTxt$,0)
        LocalColumn = 1
        LocalRow = LocalRow + 1
        IF LocalRow = 12 THEN _
           CALL ClearLocalLower
        IF LocalRow > 23 THEN
           CALL ClearLocalUpper
           LocalRow = 2
        END IF
        CALL CurLocate (LocalRow,LocalColumn)
        CALL QuickTPut (ZFG4$ + HoldLTxt$,0)
        LocalColumn = LocalColumn + LEN(HoldLTxt$)
        CALL CurLocate (LocalRow,LocalColumn)
        LocalTxt$ = ""
        EXIT SUB
     END IF
4010 CALL CurLocate (LocalRow,LocalColumn)
     CALL QuickTPut (ZFG4$ + LocalTxt$,0)
     IF Bs > 0 THEN _
        CALL CurLocate (LocalRow,LocalColumn) : _
        RETURN
     LocalColumn = LocalColumn + LEN(LocalTxt$)
4020 LocalTxt$ = ""
     END SUB
'
     SUB SysopVChat STATIC               ' Verticl SysOp ANSI Chat routine
5000 LocalColumn = 1
     LocalRow = 2
     RemoteColumn = 42
     RemoteRow = 2
     RemoteTxt$ = "Hi, " + ZFirstName$ + ".  Go Ahead..."
     CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,0)
     RemoteColumn = 42
     RemoteRow = 3
     HoldLTxt$ = ""
     HoldRTxt$ = ""
     HoldCTxt$ = ""
     CALL CurLocate (LocalRow,LocalColumn)
     ZWaitExpired = ZFalse
5010 ZAutoLogoff! = TIMER + ZWaitBeforeDisconnect
     CALL Carrier
     IF ZSubParm < 0 THEN _
        EXIT SUB
5020 CALL FindFKey
     IF ZWasCM = 0 THEN _
        CALL FlushCom (ZCommPortStack$) : _
        ZKeyPressed$ = "" : _
        ZWasCM = ZTrue : _
        GOTO 5010
     LocalTxt$ = ZKeyPressed$
     IF ZKeyPressed$ = ZEscape$ THEN _
        EXIT SUB
     IF LocalTxt$ = "" THEN _
        GOTO 5030
     IF LocalTxt$ = CHR$(8) THEN _
        GOTO 5070 _
     ELSE IF LocalTxt$ = CHR$(9) THEN _
        GOTO 5090 _
     ELSE IF LocalTxt$ = CHR$(13) THEN _
        GOTO 6010
     CALL LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,0)
     GOTO 5010
5030 IF ZLocalUser THEN _
        GOTO 5010
     IF ZCommPortStack$ <> "" THEN _
        RemoteTxt$ = LEFT$(ZCommPortStack$,LEN(ZCommPortStack$) - 1) : _
        CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,0)
     CALL EofComm (Char)
     IF Char <> -1 THEN _
        GOTO 5050 _
     ELSE _
        GOTO 5010
5050 ZAutoLogoff! = TIMER + ZWaitBeforeDisconnect
     CALL GetCom (RemoteTxt$)
     IF RemoteTxt$ = CHR$(8) THEN _
        GOTO 6030 _
     ELSE IF RemoteTxt$ = CHR$(9) THEN _
        GOTO 6050 _
     ELSE IF RemoteTxt$ = CHR$(13) THEN _
        GOTO 6070
     CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,0)
     GOTO 5010
5070 IF LocalColumn - 1 > 0 THEN _     ' Local Back Space
        CALL LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,1)
     GOTO 5010
5090 IF LocalColumn + 5 > 38 AND LocalRow < 24 THEN _ 'Local TAB
        LocalColumn = 38 _
     ELSE _
        LocalColumn = LocalColumn + 4
     LocalTxt$ = " "
     CALL LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,0)
     GOTO 5010
6010 LocalColumn = 38                  ' Local Carriage Return
     LocalTxt$ = " "
     CALL LocalScreenWrite (LocalTxt$,LocalRow,LocalColumn,0)
     GOTO 5010
6030 IF RemoteColumn - 1 > 41 THEN _   ' Remote Back Space
        CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,1)
     GOTO 5010
6050 IF RemoteColumn + 5 > 79 AND RemoteRow < 24 THEN _  ' Remote TAB
        RemoteColumn = 79 _
     ELSE _
        RemoteColumn = RemoteColumn + 4
     RemoteTxt$ = " "
     CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,0)
     GOTO 5010
6070 RemoteColumn = 79                 ' Remote Carriage Return
     RemoteTxt$ = " "
     CALL RemoteScreenWrite (RemoteTxt$,RemoteRow,RemoteColumn,0)
     GOTO 5010
     END SUB
'
7000 SUB ClearScrn STATIC              ' Clears the Entire screen
     CALL QuickTPut ("[2J[0m",0)
     ZSubParm = 2
     CALL Line25
     ZSubParm = 0
     CALL CurLocate (1,1)
     END SUB
'
7100 SUB ClearRemoteUpper STATIC       ' Clears the Upper half of Remote users screen
     Column = 42
     FOR Row = 2 TO 13
         CALL CurLocate (Row,Column)
         CALL QuickTPut ("[K",0)
     NEXT Row
     END SUB
'
7200 SUB ClearLocalUpper STATIC        ' Clears the Upper half of Local users screen
     Column = 1
     FOR Row = 2 TO 13
        CALL CurLocate (Row,Column)
        CALL QuickTPut (STRING$(38,32),0)
     NEXT Row
     END SUB
'
7300 SUB ClearRemoteLower STATIC       ' Clears the lower half of Remote users Screen
     Column = 42
     FOR Row = 14 TO 23
        CALL CurLocate (Row,Column)
        CALL QuickTPut ("[K",0)
     NEXT Row
     END SUB
'
7400 SUB ClearLocalLower STATIC         ' Clears the lower half of Local users screen
     Column = 1
     FOR Row = 14 TO 23
        CALL CurLocate (Row,Column)
        CALL QuickTPut (STRING$(38,32),0)
     NEXT Row
     END SUB
'
7500 SUB CurLocate (Row,Column) STATIC   ' Moves the cursor to desired position
     CALL QuickTPut ("[" + MID$(STR$(Row),2) + ";" + MID$(STR$(Column),2) + "H",0)
     END SUB
