{$A+,B-,D+,E+,F-,I+,L+,N-,O+,R+,S+,V-}
{$M 16384,0,655360}

{                              Backgammon
                                   by
                               Joel Bergen

              Modified from the original WWIV Backgammon written by
                         The Hightailer, sysop of
                         The Rapid Transit System
                         Richmond VA
                                                                            }

program gammon;

{$I commtag.pas}


type
gametype = record
  player1name : string[25];
  player2name : string[25];
  sidetomove  : integer;  {1=1's turn,2=2's turn,3=1 won,4=2 won, 5=signup}
  lastmovedate: string[25];              { for sysop }
  totalmoves  : integer;
  lastroll    : string[25];
  lastmove    : array[1..4] of string[25];
  piparray    : array[0..25] of integer;    {1-24 holds # of pips in each slot}
end;                                        {0 = player 2's pips on bar       }
                                            {25 = player 1's pips on bar      }
                                            {player 1's pips are positive values }
                                            {player 2's pips are negative values}

var
command : char;
movesleft,offboard1,offboard2,movenumber,frommove,tomove,die1,die2 : integer;
tempdie1,tempdie2,moveflag,pipplace,pipcode,gameposition,setnumber : integer;
toslot,fromslot : array[1..4] of string[25];
bumpcode : array[1..4] of integer;
gamefile : file of gametype;
thisgame : gametype;
takingitoff,moveok,nomove,oktocontinue,player1,player2,oktomove : boolean;
temppause   : boolean;
requestfile : text;

procedure Greturn;         { closes current data file }
var                        { restores top-of-screen data}
f : file;                  {returns to BBS }
begin
  close(gamefile);
  return;
end;

procedure pauseon;
begin
  temppause := false;
end;

procedure pauseoff;
begin
end;

procedure resetgame;         {initializes a new game }
var
ctr : integer;
begin
  with thisgame do
    begin
      sidetomove := random(2) + 1;   {side to move 1st determined randomly}
      totalmoves := 0;
      lastroll := '00';
      lastmovedate := 'NEVER';
      lastmove[1] := 'NONE';
      for ctr := 2 to 4 do
        lastmove[ctr] := ' ';
      for ctr := 0 to 25 do
        piparray[ctr] := 0;
      piparray[24] := 2;
      piparray[19] := -5;
      piparray[17] := -3;
      piparray[13] := 5;
      piparray[12] := -5;
      piparray[8] := 3;
      piparray[6] := 5;
      piparray[1] := -2;
    end;
end;

procedure initialize;
var
ctr : integer;
begin
  randomize;
  setnumber := 1;        {set number 1 is default}
  assign(gamefile,'gammon1.dat');
  {$I-}  reset(gamefile);  {$I+}
  if ioresult <> 0 then         {create set 1 if not present}
    begin
      print('     Creating first data file...');
      rewrite(gamefile);
      for ctr := 1 to 9 do
        begin
          thisgame.player1name := '';
          thisgame.player2name := '';
          resetgame;
          thisgame.sidetomove:=3;   {this will flag game as available}
          write(gamefile,thisgame);
        end;
      close(gamefile);
    end;
  reset(gamefile);
end;

procedure gotobottom;      {move cursor to bottom of screen}
begin
  locate(24,1);
  checkhangup;
end;

procedure readgame;       {reads in game data}
begin
  seek(gamefile,gameposition);
  read(gamefile,thisgame);
end;

procedure rolldice;          {rolls dice}
begin
  die1 := random(6) + 1;
  die2 := random(6) + 1;
  tempdie1 := die1;
  tempdie2 := die2;
end;

procedure initializemove;    {do before each move attempt}
var
ctr,temp : integer;
begin
  for ctr := 1 to 4 do
    begin
      bumpcode[ctr] := 0;
    end;
  die1 := tempdie1;    {use tempdice since user may decide to do move over}
  die2 := tempdie2;
  if die1 = die2 then
    movesleft := 4
  else
    begin
      movesleft := 2;
      if die1 < die2 then
        begin
          temp := die2;     {swap dice}
          die2 := die1;
          die1 := temp;
        end;
    end;
  movenumber := 1;
  nomove := false;
  moveok := false;
end;



procedure getgame;      {displays select-game menu}
var
gamenumber : char;
ctr1,ctr2,spacectr : integer;
begin
  cls;
  oktocontinue := true;
  if okansi then locate(8,31);
  ansic(5);
  prompt('Game set number: ');
  ansic(3);print(cstr(setnumber));
  for ctr1 := 0 to 8 do
    begin
      seek(gamefile,ctr1);
      read(gamefile,thisgame);
      if okansi then locate(ctr1 + 10,11);
      ansic(3);
      prompt(cstr(ctr1 + 1)+':  ');
      if not(okansi) then prompt('['+cstr(thisgame.sidetomove)+'] ');
      spacectr := 25 - length(thisgame.player1name);
      if okansi then
        for ctr2 := 1 to spacectr do                     {centers game titles}
          prompt(' ');
      case thisgame.sidetomove of
        1:ansic(4);                   {set playername colors according to}
        2:ansic(2);                   {who's turn it is to move}
        3:ansic(6);
        4:ansic(2);
      end;
      prompt(thisgame.player1name);
      ansic(5);prompt(' vs ');
      case thisgame.sidetomove of
        1:ansic(3);     {player 1's turn}
        2:ansic(4);     {player 2's turn}
        3:ansic(3);     {player 1 won}
        4:ansic(6);     {player 2 won}
      end;
      prompt(thisgame.player2name);
      if not(okansi) then nl;
    end;
  if okansi then gotobottom
  else nl;
  prt('Which game [1-9,Q=Quit]? ');
  onek(gamenumber,'123456789Q');
  if gamenumber = 'Q' then
    oktocontinue := false
  else
    begin
      gameposition := value(gamenumber) - 1;
      readgame;
    end;
end;

procedure asciiintroduction;  {DO NOT remove credits!!!!!!!!}
begin
  cls;nl;
  print('  ** B A C K G A M M O N **');nl;
  print('              by');nl;
  print('         Joel Bergen');nl;nl;
  print('          Thanks to:');nl;
  print('The Hightailer, Jak, Marvin, & Marcus Aurelius');nl;
  print('   for their help and ideas.');nl;nl;nl;nl;
  pausescr;
end;

procedure introduction;   { title screen - DO NOT REMOVE CREDITS!!!!!!!!!}
begin
  cls;locate(2,27);ansic(5);
  prompt('ͻ');
  locate(3,27);
  prompt('            ');
  locate(4,27);
  prompt('            ');
  locate(5,27);
  prompt('            ');
  locate(6,27);
  prompt('');ansic(4);prompt('B');ansic(5);prompt('');ansic(4);prompt('A');
  ansic(5);prompt('');ansic(4);prompt('C');ansic(5);prompt('');ansic(4);prompt('K');
  ansic(5);prompt('');ansic(4);prompt('G');ansic(5);prompt('');ansic(4);prompt('A');
  ansic(5);prompt('');ansic(4);prompt('M');
  ansic(5);prompt('');ansic(4);prompt('M');ansic(5);prompt('');ansic(4);prompt('O');
  ansic(5);prompt('');ansic(4);prompt('N');ansic(5);prompt('͹');
  locate(7,27);
  prompt('            ');
  locate(8,27);
  prompt('            ');
  locate(9,27);
  prompt('            ');
  locate(10,27);
  prompt('ͼ');
  locate(12,38);ansic(3);
  prompt('b y');
  locate(14,35);ansic(2);
  prompt('Joel Bergen');
  locate(16,18);ansic(5);
  prompt('Based off WWIV backgammon by The Hightailer');
  locate(18,18);ansic(1);
  prompt('Thanks to Jak, Marvin, Marcus Aurelius, and');
  locate(20,27);ansic(2);
  prompt('The author of BKGAMMON.BAS');
  gotobottom;
  if hangup then Greturn;
  pausescr;
end;

procedure processoffboardpips; {diplays # of pips on bar & off board}
var
ctr : integer;
begin
  locate(9,7);ansic(3);
  if thisgame.piparray[0] < 10 then
    prompt(' ');
  prompt(cstr(thisgame.piparray[0]));
  locate(13,7);ansic(2);
  if thisgame.piparray[25] < 10 then
    prompt(' ');
  prompt(cstr(thisgame.piparray[25]));
  offboard1 := 15;                      {calculate # off board for each user}
  offboard2 := 15;
  for ctr := 1 to 24 do
    begin
      if thisgame.piparray[ctr] > 0 then
        offboard1 := offboard1 - thisgame.piparray[ctr];
      if thisgame.piparray[ctr] < 0 then
        offboard2 := offboard2 - abs(thisgame.piparray[ctr]);
    end;
  offboard1 := offboard1 - thisgame.piparray[25];
  offboard2 := offboard2 - thisgame.piparray[0];
  locate(9,17);ansic(3);
  if offboard2 < 10 then
    prompt(' ');
  prompt(cstr(offboard2));
  locate(13,17);ansic(2);
  if offboard1 < 10 then
    prompt(' ');
  prompt(cstr(offboard1));
end;

procedure displaygamestatus;    {displays status line}
var
ctr : integer;
begin
  if cs then         {show last move date for sysop}
    begin
      locate(23,1);ansic(5);
      prompt('Last move on: ');
      case thisgame.sidetomove of
        1:ansic(3);
        2:ansic(2);
        3:ansic(3);
        4:ansic(2);
      end;
      prompt(thisgame.lastmovedate);
    end;
  locate(22,1);ansic(5);
  prompt('Moves '+cstr(thisgame.totalmoves)+' ');
  case thisgame.sidetomove of
    1:ansic(3);
    2:ansic(2);
    3:ansic(3);
    4:ansic(2);
  end;
  prompt('Last Roll '+thisgame.lastroll+' ');
  prompt('Moves');
  for ctr := 1 to 4 do
    begin
      prompt(' ');
      prompt(thisgame.lastmove[ctr]);
    end;
end;


procedure displayscreen;    {draws game screen}
var
ctrx,ctry,xpos,ypos,pipplayer,numberofpips : integer;
begin
  cls;
  ctrx := 29;
  ansic(5);
  repeat                        {draw vertical lines}
    for ctry := 3 to 19 do
      begin
        locate(ctry,ctrx);
        if (ctrx = 29) or (ctrx = 53) or (ctrx = 77) then
          prompt('')
        else
          prompt('');
      end;
    ctrx := ctrx + 4;
  until (ctrx > 77) or hangup;
  locate(1,31);ansic(1);
  prompt('X   W   V   U   T   S   R   Q   P   O   N   M');
  locate(2,29);ansic(5);
  prompt('ͻ');
  locate(11,29);
  prompt('͹');
  locate(20,29);
  prompt('ͼ');
  locate(21,31);ansic(1);
  prompt('A   B   C   D   E   F   G   H   I   J   K   L');
  locate(6,12);ansic(3);
  prompt(' ');
  locate(3,1);
  case thisgame.sidetomove of
    1:ansic(3);
    2:ansic(4);                  {set color for name}
    3:ansic(3);
    4:ansic(6);
  end;
  prompt(thisgame.player2name);
  locate(11,5);ansic(1);
  prompt('ON BAR   OFF BOARD [Z]');
  locate(19,1);
  case thisgame.sidetomove of
    1:ansic(4);
    2:ansic(2);                 {set color for name}
    3:ansic(6);
    4:ansic(2);
  end;
  prompt(thisgame.player1name);
  locate(16,12);ansic(2);
  prompt('ͯ');
  processoffboardpips;
  ctrx := 24;
  repeat                       {draws pips in top 12 slots}
    if thisgame.piparray[ctrx] <> 0 then
      begin
        if thisgame.piparray[ctrx] > 0 then
          pipplayer := 1
        else
          pipplayer := 2;
        numberofpips := thisgame.piparray[ctrx];
        if numberofpips > 8 then      {if > 8 pips in slot, only draw 8}
          numberofpips := 8;
        if numberofpips < -8 then
          numberofpips := -8;
        for ctry := 1 to abs(numberofpips) do
          begin
            xpos := 3 + ctry - 1;
            ypos := (24 - ctrx) * 4 + 30;
            locate(xpos,ypos);
            ansic(pipplayer + 1);
            if pipplayer = 1 then
              prompt('ͯ')
            else
              prompt(' ');
          end;
      end;
    ctrx := ctrx - 1;
  until (ctrx < 13) or hangup;
  for ctrx := 1 to 12 do                {draw pips in bottom 12 slots}
    begin
      if thisgame.piparray[ctrx] <> 0 then
        begin
          if thisgame.piparray[ctrx] > 0 then
            pipplayer := 1
          else
            pipplayer := 2;
          numberofpips := thisgame.piparray[ctrx];
          if numberofpips > 8 then
            numberofpips := 8;               {only draw max of 8 pips in a slot}
          if numberofpips < -8 then
            numberofpips := -8;
          for ctry := 1 to abs(numberofpips) do
            begin
              xpos := 20 - ctry;
              ypos := (ctrx - 1) * 4 + 30;
              locate(xpos,ypos);
              ansic(pipplayer + 1);
              if pipplayer = 1 then
                prompt('ͯ')
              else
                prompt(' ');
            end;
        end;
    end;
  displaygamestatus;
  gotobottom;
  if hangup then Greturn;
end;

procedure asciidisplayscreen;
var
ctr : integer;
begin
  nl;nl;nl;nl;nl;nl;nl;nl;
  offboard1 := 15;offboard2 := 15;
  for ctr := 1 to 24 do
    begin
      if thisgame.piparray[ctr] > 0 then
        offboard1 := offboard1 - thisgame.piparray[ctr];
      if thisgame.piparray[ctr] < 0 then
        offboard2 := offboard2 - abs(thisgame.piparray[ctr]);
    end;
  offboard1 := offboard1 - thisgame.piparray[25];
  offboard2 := offboard2 - thisgame.piparray[0];
  print('[-]  '+thisgame.player2name);
  print('ON BAR: '+cstr(thisgame.piparray[0])+'  OFF BOARD [Z]: '+cstr(offboard2));
  nl;print(' X  W  V  U  T  S   R  Q  P  O  N  M');
  print('+--+--+--+--+--+--++--+--+--+--+--+--++');
  prompt('|');ctr := 24;
  repeat
    case thisgame.piparray[ctr] of
      0       :prompt('   ');
      1..9    :prompt(' '+cstr(thisgame.piparray[ctr])+' ');
      10..15  :prompt(cstr(thisgame.piparray[ctr])+' ');
      -15..-10:prompt(cstr(thisgame.piparray[ctr]));
      -9..-1  :prompt(cstr(thisgame.piparray[ctr])+' ');
    end;
    ctr := ctr - 1;
  until (ctr = 18) or hangup;
  prompt('|');ctr := 18;
  repeat
    case thisgame.piparray[ctr] of
      0       :prompt('   ');
      1..9    :prompt(' '+cstr(thisgame.piparray[ctr])+' ');
      10..15  :prompt(cstr(thisgame.piparray[ctr])+' ');
      -15..-10:prompt(cstr(thisgame.piparray[ctr]));
      -9..-1  :prompt(cstr(thisgame.piparray[ctr])+' ');
    end;
    ctr := ctr - 1;
  until (ctr = 12) or hangup;
  print('|');print('|--+--+--+--+--+--++--+--+--+--+--+--+|');
  prompt('|');
  for ctr := 1 to 6 do
    case thisgame.piparray[ctr] of
      0       :prompt('   ');
      1..9    :prompt(' '+cstr(thisgame.piparray[ctr])+' ');
      10..15  :prompt(cstr(thisgame.piparray[ctr])+' ');
      -15..-10:prompt(cstr(thisgame.piparray[ctr]));
      -9..-1  :prompt(cstr(thisgame.piparray[ctr])+' ');
    end;
  prompt('|');
  for ctr := 7 to 12 do
    case thisgame.piparray[ctr] of
      0       :prompt('   ');
      1..9    :prompt(' '+cstr(thisgame.piparray[ctr])+' ');
      10..15  :prompt(cstr(thisgame.piparray[ctr])+' ');
      -15..-10:prompt(cstr(thisgame.piparray[ctr]));
      -9..-1  :prompt(cstr(thisgame.piparray[ctr])+' ');
    end;
  print('|');print('+--+--+--+--+--+--++--+--+--+--+--+--++');
  print(' A  B  C  D  E  F   G  H  I  J  K  L');nl;
  print('[+]  '+thisgame.player1name);
  print('ON BAR: '+cstr(thisgame.piparray[25])+'  OFF BOARD [Z]: '+cstr(offboard1));
  nl;
  print('TOTAL MOVES: '+cstr(thisgame.totalmoves));
  case thisgame.sidetomove of
    1:prompt('[-]');
    2:prompt('[+]');
    3:prompt('[+]');
    4:prompt('[-]');
  end;
  prompt(' LR: '+thisgame.lastroll+' LM:');
  for ctr := 1 to 4 do
    prompt(' '+thisgame.lastmove[ctr]);
  nl;
  if cs then print('Last move on: '+thisgame.lastmovedate);nl;
end;

procedure badmove;      {informs user of invalid move}
begin
  prompt(#7);
  if okansi then
    begin
      gotobottom;ansic(6);prompt('Invalid move - try again.     ');
      ansic(1);prompt('                       Re-display screen? ');
      if yn then
        displayscreen
      else
        begin
          gotobottom;
          prompt('                                                                          ');
          gotobottom;
        end;
      ansic(thisgame.sidetomove + 1);
      prompt('Your roll is: '+cstr(die1));   {re-display roll}
      if movesleft > 1 then
        prompt(' '+cstr(die2));
    end
  else
    begin
      print('Invalid move - try again.');
      pausescr;
      asciidisplayscreen;
      prompt('Your roll is: '+cstr(die1));
      if movesleft > 1 then
        print(' '+cstr(die2));
    end;
end;

procedure buildgame;   {sysop build procedure}
begin
  nl;nl;
  prt('Edit game, are you sure?');
  if yn then
    begin
      nl;print('If you just want to erase the game,');
      print('just press ENTER when asked for the player names.');
      nl;print('Otherwise, make sure you spell the player names correctly,');
      print('and that you capitalize the names correctly');
      nl;
      prompt('Enter player 1''s name:');
      input(thisgame.player1name,25);
      nl;
      prompt('Enter player 2''s name:');
      input(thisgame.player2name,25);
      prompt('Reset the game? ');
      if yn then resetgame;
      thisgame.sidetomove:=4;
      seek(gamefile,gameposition);
      write(gamefile,thisgame);
      nl;print('Done.');
    end
  else
    begin
      nl;print('Aborted.');
    end;
  nl;pausescr;
end;

procedure checkformoveaccess;   {check for player's access to game when "M" selected}
var
errorcode : integer;    {0=OK,1=not in game,2=not your move,3=you won,4=you lost}
begin
  oktomove := false;
  player1 := false;
  player2 := false;
  errorcode := 0;
  if thisuser.name = thisgame.player1name then   {check if user is in this game}
    player1 := true;
  if thisuser.name = thisgame.player2name then
    player2 := true;
  if not(player1) and not(player2) then
    errorcode := 1;
  if errorcode = 0 then           {if user in game, check if it's his move}
    begin
      if player1 then
        case thisgame.sidetomove of
          2:errorcode := 2;
          3:errorcode := 3;
          4:errorcode := 4;
          5:errorcode := 5;
        end
      else
        case thisgame.sidetomove of
          1:errorcode := 2;
          3:errorcode := 4;
          4:errorcode := 3;
          5:errorcode := 5;
        end;
    end;
  if errorcode > 0 then
    begin
      cls;
      if okansi then
        begin
          locate(12,10);ansic(5);      {display error messages}
        end;
      case errorcode of
        1:print('Nice try, but you''re not playing in this game.');
        2:print('It''s still your opponent''s turn to move...');
        3:print('You''ve already won this game!');
        4:print('The game is over, and you lost (hahahaha!)');
        5:print('This game hasn''t started yet!');
      end;
      if okansi then gotobottom else nl;
      pausescr;
    end
  else
    oktomove := true;     {Ok for user to move...}
end;

procedure changeset;
var
setchoice : char;
ctr : integer;
begin
  cls;nl;ansic(5);
  prompt('Current game set is: ');
  ansic(1);prompt(cstr(setnumber));
  nl;prt('Enter desired game set number (1 or 2,Q=Quit): ');
  onek(setchoice,'12Q');nl;
  if setchoice = 'Q' then
    begin
      ansic(1);
      prompt('Aborted.');
    end
  else
    begin
      close(gamefile);
      case setchoice of
        '1':begin
              assign(gamefile,'gammon1.dat');
              setnumber := 1;
            end;
        '2':begin
              assign(gamefile,'gammon2.dat');
              {$I-} reset(gamefile); {$I+}
              if ioresult <> 0 then
                begin
                  nl;print('Creating second data file...');
                  rewrite(gamefile);
                  for ctr := 1 to 9 do
                    begin
                      thisgame.player1name := '';
                      thisgame.player2name := '';
                      resetgame;
                      write(gamefile,thisgame);
                    end;
                  close(gamefile);
                end;
              setnumber := 2;
            end;
      end;
      reset(gamefile);
      ansic(5);
      prompt('Current game set is now: ');
      ansic(1);prompt(cstr(setnumber));
    end;
  nl;pausescr;
end;

procedure movepips;   {moves pips on board when player moves}
var
temp,numberofpips,pipplayer,xpos,ypos : integer;
begin
  if thisgame.piparray[pipplace] < 0 then
    pipplayer := 2
  else
    pipplayer := 1;
  numberofpips := thisgame.piparray[pipplace];
  if numberofpips > 8 then
    numberofpips := 8;
  if numberofpips < -8 then
    numberofpips := -8;
  if pipplace < 13 then
    begin
      xpos := (pipplace - 1) * 4 + 30;
      if pipplace = frommove then
        temp := 1
      else
        temp := 0;
      ypos := 20 - abs(numberofpips) - temp;
    end
  else
    begin
      xpos := (24 - pipplace) * 4 + 30;
      if pipplace = frommove then
        temp := 1
      else
        temp := 0;
      ypos := 2 + abs(numberofpips) + temp;
    end;
  if ypos <> 11 then
    begin
      locate(ypos,xpos);
      prompt('   ');
    end;
  if pipplace = tomove then
    begin
      locate(ypos,xpos);ansic(thisgame.sidetomove + 1);
      if pipplayer = 1 then
        prompt('ͯ')
      else
        prompt(' ');
    end;
end;

procedure updatescreen;  {determine how to move pips}
begin
  processoffboardpips;
  if (frommove > 0) and (frommove < 25) then
    begin
      pipplace := frommove;
      movepips;
      if tomove < 99 then
        begin
          pipplace := tomove;
          movepips;
        end;
    end
  else
    begin
      pipplace := tomove;
      movepips;
    end;
end;

procedure savegame;     {saves game stats when Move is done}
var
ctr : integer;
begin
  if okansi then gotobottom;
  ansic(1);
  prompt('Your move(s) are saved...        ');
  if player1 then
    if offboard1 = 15 then
      begin
        thisgame.sidetomove := 3;
        ansic(6);prompt('     You WON!!      ');
        sysoplog('- Won at Backgammon');
      end
    else
      begin
        thisgame.sidetomove := 2;
      end;
  if player2 then
    if offboard2 = 15 then
      begin
        thisgame.sidetomove := 4;
        ansic(6);prompt('     You WON!!'      );
        sysoplog('- Won at Backgammon');
      end
    else
      begin
        thisgame.sidetomove := 1;
      end;
  if not(okansi) then nl;
  pausescr;
  if tempdie1 > tempdie2 then
    thisgame.lastroll := cstr(tempdie1)+cstr(tempdie2)
  else
    thisgame.lastroll := cstr(tempdie2)+cstr(tempdie1);
  for ctr := 1 to 4 do
    thisgame.lastmove[ctr] := ' ';
  for ctr := 1 to movenumber do     {create last moves}
    begin
      thisgame.lastmove[ctr] := fromslot[ctr]+'-'+toslot[ctr];
      if bumpcode[ctr] = 1 then
        thisgame.lastmove[ctr] := thisgame.lastmove[ctr]+'(BUMP)';
    end;
  if not(nomove and (movenumber = 1)) then
    thisgame.totalmoves := thisgame.totalmoves + movenumber;
  thisgame.lastmovedate := date;
  seek(gamefile,gameposition);
  write(gamefile,thisgame);
end;

procedure get2move;  {gets player 2's From and To moves - checks for illegal moves}
var
validinput,okfrom : boolean;
fromcommand,tocommand : char;
begin
  validinput := false;
  repeat
    if okansi then
      begin
        locate(24,40);prompt('                                       ');
        locate(24,40);ansic(3);
      end;
    prompt('From: ');okfrom := false;
    if thisgame.piparray[0] > 0 then
      begin
        frommove := 0;okfrom := true;
        prompt('BAR');
        if not(okansi) then nl;
        fromcommand := 'b';
      end
    else
      begin
        onek(fromcommand,'ABCDEFGHIJKLMNOPQRSTUVWX');
        frommove := ord(fromcommand) - 64;
        if thisgame.piparray[frommove] > -1 then
          badmove
        else
          okfrom := true;
      end;
    if okfrom then
      begin
        if fromcommand = 'b' then
          fromslot[movenumber] := 'BAR'
        else
          fromslot[movenumber] := fromcommand;
        if okansi then
          begin
            locate(24,60);ansic(3);
          end;
        prompt('To: ');
        onek(tocommand,'ABCDEFGHIJKLMNOPQRSTUVWXZ');
        takingitoff := false;
        if tocommand = 'Z' then
          tomove := 99
        else
          tomove := ord(tocommand) - 64;
        if tomove = 99 then
          begin
            if pipcode < 19 then
              badmove
            else
              begin
                if (frommove = 25 - die2) or ((pipcode > 25 - die2) and (frommove = pipcode)) then
                  begin
                    validinput := true;
                    takingitoff := true;
                    die2 := die1;
                  end
                else
                  if (frommove = 25 - die1) or ((pipcode > 25 - die1) and (frommove = pipcode)) then
                    begin
                      validinput := true;
                      takingitoff := true;
                      die1 := die2;
                    end;
                if not(validinput) then
                  badmove;
              end;
          end
        else
          begin
            if thisgame.piparray[tomove] > 1 then
              badmove
            else
              begin
                if tomove - frommove = die1 then
                  begin
                    validinput := true;die1 := die2;
                  end
                else
                  if tomove - frommove = die2 then
                    begin
                      validinput := true;die2 := die1;
                    end;
                if not(validinput) then
                  badmove;
            end;
          end;
      end;
  until validinput or hangup;
  if tocommand = 'Z' then
    toslot[movenumber] := 'OFF'
  else
    toslot[movenumber] := tocommand;
end;


procedure player2move;  {do player 2's turn}
var
ctr : integer;
begin
  repeat
    if okansi then
      begin
        gotobottom;prompt('                                ');gotobottom;
      end
    else asciidisplayscreen;
    ansic(3);prompt('Your roll is: '+cstr(die1));
    if movesleft > 1 then
      prompt(' '+cstr(die2));
    if not(okansi) then nl;
    pipcode := 0;
    if (thisgame.piparray[0] > 0) and (thisgame.piparray[die1] > 1) and (thisgame.piparray[die2] > 1) then
      begin
        nomove := true;movesleft := 0;moveok := true;
      end
    else
      begin
        while (thisgame.piparray[0] < 1) and (thisgame.piparray[pipcode] > -1) do
          pipcode := pipcode + 1;
        moveflag := 0;
        if (thisgame.piparray[0] > 0) and (thisgame.piparray[die1] < 2) then
          moveflag := 1;
        if (thisgame.piparray[0] > 0) and (thisgame.piparray[die2] < 2) then
          moveflag := 1;
        for ctr := 1 to (24 - die1) do
          if (thisgame.piparray[ctr] < 0) and (thisgame.piparray[ctr+die1] < 2) then
            moveflag := 1;
        for ctr := 1 to (24 - die2) do
          if (thisgame.piparray[ctr] < 0) and (thisgame.piparray[ctr+die2] < 2) then
            moveflag := 1;
        if moveflag = 0 then
          begin
            if ((pipcode <19) or ((thisgame.piparray[25-die2] > -1) and (thisgame.piparray[25-die1] > -1) and
            (pipcode < (25 - die1)))) then
              begin
                nomove := true;movesleft := 0;moveok := true;
              end;
          end;
        if not(nomove) then
          begin
            get2move;
            if frommove = 0 then
              thisgame.piparray[0] := thisgame.piparray[0] - 2;
            thisgame.piparray[frommove] := thisgame.piparray[frommove] + 1;
            if not(takingitoff) then
              begin
                if thisgame.piparray[tomove] = 1 then
                  begin
                    thisgame.piparray[25] := thisgame.piparray[25] + 1;
                    thisgame.piparray[tomove] := 0;
                    bumpcode[movenumber] := 1;
                  end;
              end;
            thisgame.piparray[tomove] := thisgame.piparray[tomove] - 1;
            if okansi then updatescreen;
            movenumber := movenumber + 1;
            movesleft := movesleft - 1;
            if offboard2 = 15 then
              movesleft := 0;
            if movesleft = 0 then
              begin
                movenumber := movenumber - 1;
                if okansi then
                  begin
                    gotobottom;prompt('                                                                ');
                    gotobottom;ansic(3);
                  end
                else asciidisplayscreen;
                prompt('Is this ok? ');
                if yn then
                  moveok := true
                else
                  begin
                    if okansi then
                      begin
                        gotobottom;ansic(1);
                      end;
                    prompt('Ok, try again then...              ');
                    if not(okansi) then nl;
                    pausescr;readgame;
                    if okansi then displayscreen;
                    initializemove;
                  end;
              end;
          end;
      end;
  until ((movesleft = 0) and (moveok)) or hangup;
end;

procedure get1move;  {get player 1's From and To moves}
var
validinput,okfrom : boolean;
fromcommand,tocommand : char;
begin
  validinput := false;
  repeat
    if okansi then
      begin
        locate(24,40);prompt('                                       ');
        locate(24,40);ansic(2);
      end;
    prompt('From: ');okfrom := false;
    if thisgame.piparray[25] > 0 then
      begin
        frommove := 25;okfrom := true;
        prompt('BAR');
        if not(okansi) then nl;
        fromcommand := 'b';
      end
    else
      begin
        onek(fromcommand,'ABCDEFGHIJKLMNOPQRSTUVWX');
        frommove := ord(fromcommand) - 64;
        if thisgame.piparray[frommove] < 1 then
          badmove
        else
          okfrom := true;
      end;
    if okfrom then
      begin
        if fromcommand = 'b' then
          fromslot[movenumber] := 'BAR'
        else
          fromslot[movenumber] := fromcommand;
        if okansi then
          begin
            locate(24,60);ansic(2);
          end;
        prompt('To: ');
        onek(tocommand,'ABCDEFGHIJKLMNOPQRSTUVWXZ');
        takingitoff := false;
        if tocommand = 'Z' then
          tomove := 99
        else
          tomove := ord(tocommand) - 64;
        if tomove = 99 then
          begin
            if pipcode > 6 then
              badmove
            else
              begin
                if (frommove = die2) or ((die2 > pipcode) and (frommove = pipcode)) then
                  begin
                    validinput := true;
                    takingitoff := true;
                    die2 := die1;
                  end
                else
                  if (frommove = die1) or ((die1 > pipcode) and (frommove = pipcode)) then
                    begin
                      validinput := true;
                      takingitoff := true;
                      die1 := die2;
                    end;
                if not(validinput) then
                  badmove;
              end;
          end
        else
          begin
            if thisgame.piparray[tomove] < -1 then
              badmove
            else
              begin
                if frommove - tomove = die1 then
                  begin
                    validinput := true;die1 := die2;
                  end
                else
                  if frommove - tomove = die2 then
                    begin
                      validinput := true;die2 := die1;
                    end;
                if not(validinput) then
                  badmove;
            end;
          end;
      end;
  until validinput or hangup;
  if tocommand = 'Z' then
    toslot[movenumber] := 'OFF'
  else
    toslot[movenumber] := tocommand;
end;

procedure player1move;   {do player 1's turn}
var
ctr : integer;
begin
  repeat
    if okansi then
      begin
        gotobottom;prompt('                                ');gotobottom;
      end
    else asciidisplayscreen;
    ansic(2);prompt('Your roll is: '+cstr(die1));
    if movesleft > 1 then
      prompt(' '+cstr(die2));
    if not(okansi) then nl;
    pipcode := 25;
    if (thisgame.piparray[25] > 0) and (thisgame.piparray[25-die1] < -1) and (thisgame.piparray[25-die2] < -1) then
      begin
        nomove := true;movesleft := 0;moveok := true;
      end
    else
      begin
        while thisgame.piparray[pipcode] < 1 do
          pipcode := pipcode - 1;
        moveflag := 0;
        for ctr := (die1 + 1) to 25 do
          if (thisgame.piparray[ctr] > 0) and (thisgame.piparray[ctr-die1] > -2) then
            moveflag := 1;
        for ctr := (die2 + 1) to 25 do
          if (thisgame.piparray[ctr] > 0) and (thisgame.piparray[ctr-die2] > -2) then
            moveflag := 1;
        if moveflag = 0 then
          begin
            if ((pipcode > 6) or ((thisgame.piparray[die2] < 1) and (thisgame.piparray[die1] < 1) and (pipcode > die1))) then
              begin
                nomove := true;movesleft := 0;moveok := true;
              end;
          end;
        if not(nomove) then
          begin
            get1move;
            thisgame.piparray[frommove] := thisgame.piparray[frommove] - 1;
            if not(takingitoff) then
              begin
                if thisgame.piparray[tomove] = -1 then
                  begin
                    thisgame.piparray[0] := thisgame.piparray[0] + 1;
                    thisgame.piparray[tomove] := 0;
                    bumpcode[movenumber] := 1;
                  end;
              end;
            thisgame.piparray[tomove] := thisgame.piparray[tomove] + 1;
            if okansi then updatescreen;
            movenumber := movenumber + 1;
            movesleft := movesleft - 1;
            if offboard1 = 15 then
              movesleft := 0;
            if movesleft = 0 then
              begin
                movenumber := movenumber - 1;
                if okansi then
                  begin
                    gotobottom;prompt('                                                                     ');
                    gotobottom;ansic(2);
                  end
                else asciidisplayscreen;
                prompt('Is this ok? ');
                if yn then
                  moveok := true
                else
                  begin
                    if okansi then
                      begin
                        gotobottom;ansic(1);
                      end;
                    prompt('Ok, try again then...             ');
                    if not(okansi) then nl;
                    pausescr;readgame;
                    if okansi then displayscreen;
                    initializemove;
                  end;
              end;
          end;
      end;
  until ((movesleft = 0) and (moveok)) or hangup;
end;

procedure ansigame;
begin
  repeat
    cls;
    if cs then     {draw sysop functions on menu}
      begin
        locate(2,32);ansic(5);prompt('B - ');
        ansic(1);prompt('Build a game (sysop only)');
      end;
    locate(4,28);ansic(5);prompt('---- Game set number: ');
    ansic(1);prompt(cstr(setnumber));ansic(5);prompt(' ----');
    locate(8,32);ansic(5);prompt('C - ');
    ansic(1);prompt('Change set number');
    locate(10,32);ansic(5);prompt('E - ');
    ansic(1);prompt('Enter a game');
    locate(12,32);ansic(5);prompt('I - ');
    ansic(1);prompt('Instructions');
    locate(14,32);ansic(5);prompt('M - ');
    ansic(1);prompt('Make move(s)');
    locate(16,32);ansic(5);prompt('V - ');
    ansic(1);prompt('View a game');
    locate(18,32);ansic(5);prompt('Q - ');
    ansic(1);prompt('Quit to BBS');
    gotobottom;
    prt('Which? ');
    onek(command,'BCEIMVQ');
    case command of
      'B':begin
            if cs then
              begin
                getgame;
                if oktocontinue then
                  buildgame;
              end;
          end;
      'C':changeset;
      'E':begin
            getgame;
            if oktocontinue then begin
              if thisgame.sidetomove>2 then begin {game open}
                if (thisuser.name<>thisgame.player1name) and (thisgame.sidetomove=5)
                then begin  {sign up player 2 & start}
                  thisgame.player2name:=thisuser.name;
                  resetgame;
                  seek(gamefile,gameposition);
                  write(gamefile,thisgame);
                  nl;
                  print('Done -- game initialized.');
                  pausescr;
                end else begin
                  thisgame.player1name:=thisuser.name;
                  thisgame.player2name:='-OPEN-';
                  thisgame.sidetomove:=5;
                  seek(gamefile,gameposition);
                  write(gamefile,thisgame);
                  print('Done -- your name has been added to the game.');
                  pausescr;
                end;
              end else begin
                print('Select an OPEN game!');
                pausescr;
              end;
            end;
          end;
      'I':begin
            cls;pauseon;
            printfile('gammon.txt');
            pauseoff;pausescr;
          end;
      'M':begin
            getgame;
            if oktocontinue then
              begin
                checkformoveaccess;
                if oktomove then
                  begin
                    rolldice;
                    displayscreen;
                    initializemove;
                    if player1 then
                      player1move
                    else
                      player2move;
                    if nomove then
                      begin              {player couldn't move}
                        prompt('                                                                 ');
                        prompt(#7);ansic(6);locate(24,40);
                        prompt('You can''t move!!      ');
                        pausescr;
                        fromslot[movenumber] := 'NO';
                        toslot[movenumber] := 'MOVE';
                      end;
                    if not(hangup) then  {if user hung up don't save - could}
                      savegame;          {mess up the data}
                  end;
              end;
          end;
      'V':begin
            getgame;
            if oktocontinue then
              begin
                displayscreen;
                pausescr;
              end;
          end;
    end;
  until (command = 'Q') or hangup;
end;

procedure asciigame;
begin
  repeat
    cls;nl;nl;
    if cs then
      begin
        print('B - Build a game (sysop only)');
      end;
    print('Game set number: '+cstr(setnumber));
    nl;print('C - Change set number');
    print('E - Enter a game');
    print('I - Instructions');
    print('M - Make move(s)');
    print('V - View a game');
    print('Q - Quit to BBS');
    nl;prompt('Which? ');
    onek(command,'BCEIMVQ');
    case command of
      'B':begin
            if cs then
              begin
                getgame;
                if oktocontinue then
                  buildgame;
              end;
          end;
      'C':changeset;
      'E':begin
            getgame;
            if oktocontinue then begin
              if thisgame.sidetomove>2 then begin {game open}
                if (thisuser.name<>thisgame.player1name) and (thisgame.sidetomove=5)
                then begin  {sign up player 2 & start}
                  thisgame.player2name:=thisuser.name;
                  resetgame;
                  seek(gamefile,gameposition);
                  write(gamefile,thisgame);
                  nl;
                  print('Done -- game initialized.');
                  pausescr;
                end else begin
                  thisgame.player1name:=thisuser.name;
                  thisgame.player2name:='-OPEN-';
                  thisgame.sidetomove:=5;
                  seek(gamefile,gameposition);
                  write(gamefile,thisgame);
                  print('Done -- your name has been added to the game.');
                  pausescr;
                end;
              end else begin
                print('Select an OPEN game!');
                pausescr;
              end;
            end;
          end;
      'I':begin
            cls;pauseon;
            printfile('gammon2.txt');
            pauseoff;
            pausescr;
          end;
      'M':begin
            getgame;
            if oktocontinue then
              begin
                checkformoveaccess;
                if oktomove then
                  begin
                    rolldice;
                    initializemove;
                    if player1 then player1move
                    else player2move;
                    if nomove then
                      begin
                        nl;prompt(#7);print('You can''t move!!');
                        pausescr;
                        fromslot[movenumber] := 'NO';
                        toslot[movenumber] := 'MOVE';
                      end;
                    if not(hangup) then savegame;
                  end;
              end;
          end;
      'V':begin
            getgame;
            if oktocontinue then
              begin
                asciidisplayscreen;
                pausescr;
              end;
          end;
    end;
  until (command = 'Q') or hangup;
end;

begin
  iport;
  initialize;
  if okansi then introduction else asciiintroduction;
  if okansi then ansigame else asciigame;
  Greturn;
end.

