/*
   Copyright (C) 1988-1992 The GAP Development Company

   All Rights Reserved
   
   This source code is considered to be confidential information proprietary
   to The GAP Development Company.  It is prohibited and punishable by law
   to use or duplicate any part of this information.
 

   GAPSTRUC.H

   Header file for GAPCDR modules
*/

#pragma pack(1)                           // All structs must be packed

   struct GAP_USER
      {
      char fname     [16];                // first name
      char lname     [16];                // last name
      char handle    [16];                // handle for MPART!
      char city      [30];                // city, state
      char passwd    [13];                // password
      char hphone    [14];                // homephone
      char bphone    [14];                // work/data phone
      char subscribe  [9];                // subscription date
      short  level;                       // security - up to 255
      long timeson;                       // times on - over 2 billion
      char lastdate   [9];                // last date on - mm/dd/yy
      char lasttime   [6];                // last time on - hh:mm
      long ttlmins;                       // total mins on - 2+ billion
      short  minutes;                     // # of minutes last call
      long uploads;                       // # of uploads - 2+ billion
      long downloads;                     // # of downloads - 2+ billion
      long ttlbytes;                      // total bytes downloaded
      long curbytes;                      // bytes downloaded this call
      char private;                       // allow on private nodes?
      char protocol   [3];                // transfer protocol
      short  page;                        // page length - to 23
      char lastdir    [9];                // date last looked at dir
      long lastmsg;                       // last message read - 99999 max
      long mesread;                       // total msgs read - 2+ billion
      long mesleft;                       // total messages left
      long forum_joined;                  // total forums joined
      long blts_read;                     // total bulletins read
      long doors_opened;                  // total doors opened
      short  lastconf;                    // last forum in
      char expert;                        // novice = N, expert = Y
      char sysop;                         // sysop record, 1 = Y, 0 = N
      long upbytes;                       // total bytes uploaded
      short curdown;                      // total files downed today
      char birthdate  [9];                // user's birthdate
      char comment   [51];                // comment about user
      long forum1;                        // forum membership  1  - 30
      long forum2;                        // forum membership  31 - 60
      long forum3;                        // forum membership  61 - 90
      long fmes      [90];                // last message read each forum
      };                                  // 652


   struct PCBSYS14                        // structure of PCBOARD.SYS    
      {
      char display      [2];              // display on/off -1=on,0=off  
      char printer      [2];              // printer on/off -1=on,0=off  
      char pagebell     [2];              // page bell      -1=on,0=off  
      char calleralarm  [2];              // caller alarm   -1=on,0=off  
      char sysopnext;                     // sysop on next  N,X,space    
      char errcorrect   [2];              // ecc modem      -1=yes,0=no  
      char color;                         // color toggle   Y,N,7        
      char nu;                            // node chat, not provided     
      char baud         [5];              // com port bps rate           
      char userbaud     [5];              // call bps rate               
      int  userrec;                       // user record position        
      char userfirst   [15];              // caller's first name         
      char password    [12];              // users password              
      int timeon;                         // time user logged on (mins)  
      int timeused;                       // time user has used that day 
      char ctime        [5];              // time user logged on hh:mm   
      int timeallowed;                    // allowed time in minutes     
      int ttlbytes;                       // total bytes available /1024 
      char forumnum;                      // forum user was in "0" = main
      char nu1          [5];              // areas been in, not provided 
      char nu2          [5];              // areas scanned, not provided 
      int timegiven;                      // highest forum time given    
      int timecredit;                     // time credit in minutes      
      char nu3          [4];              // language being used         
      char username    [25];              // name of caller              
      int minsleft;                       // minutes left for caller     
      char node;                          // node number (short int)     
      char event        [5];              // event time hh:mm            
      char event_active [2];              // event active  -1=yes,0=no   
      char slide_event  [2];              // slide event   -1=yes,0=no   
      char nu4          [4];              // memorized mess #, not prov  
      char port;                          // com port, '0','1','2'       
      char nu5          [2];              // not used                    
      };


   //****************************************************************
   //  you will need to consult the pcb documentation for a more     
   //  detailed explanation of these fields.  Note that any          
   //  double or float fields will have to be converted with the     
   //  appropriate C conversion function.                            
   //****************************************************************

   struct PCBUSER14                       // structure for PCB USERS     
      {
      char name         [25];             // users full name             
      char city         [24];             // users home town             
      char passwd       [12];             // users password              
      char bphone       [13];             // users data phone number     
      char hphone       [13];             // users home phone number     
      char lastdate      [6];             // last date on as yymmdd (sic)
      char lasttime      [5];             // last time on as hh:mm       
      char expert;                        // expert mode                 
      char protocol;                      // protol being used           
      char nu;                            // not used                    
      char lastdir       [6];             // last directory date yymmdd  
      char level;                         // users level as short int    
      int  timeson;                       // # of times on               
      char page;                          // page length as short int    
      int  uploads;                       // # of uploads                
      int  downloads;                     // # of downloads              
      double curdown;                     // current down bytes          
      char comment1     [30];             // comment                     
      char comment2     [30];             // comment                     
      int elap;                           // elapsed time                  
      char regisdate     [6];             // registration date yymmdd    
      char exp_level;                     // expired security level      
      char lastconf;                      // last forum in               
      char forum_regis   [5];             // you figure it out cause     
      char forum_exp     [5];             // these fields are definately 
      char forum_scan    [5];             // NOT bit maps!               
      double downbytes;                   // total downbytes             
      double upbytes;                     // total upbytes               
      char delete;                        // deleted user                
      float lastmsg;                      // last msg read               
      float lastmsg1    [39];             // last msg read in forums     
      char nu1          [15];             // not used                    
      };                                  // 400 bytes                   


#define YES 1                             // used when calling show_mess()   
#define NO  0


#define TAB  9
#define ESC  0x1b

#define F1  59 + 0x100
#define F2  60 + 0x100
#define F3  61 + 0x100
#define F4  62 + 0x100
#define F5  63 + 0x100
#define F6  64 + 0x100
#define F7  65 + 0x100
#define F8  66 + 0x100
#define F9  67 + 0x100
#define F10 68 + 0x100
#define F11 171 + 0x100
#define F12 172 + 0x100
#define CF10 103 + 0x100

#define HOME_KEY  71 + 0x100
#define END_KEY   79 + 0x100
#define PGUP      73 + 0x100
#define PGDN      81 + 0x100
#define CUR_LEFT  75 + 0x100
#define CUR_RIGHT 77 + 0x100
#define CUR_UP    72 + 0x100
#define CUR_DOWN  80 + 0x100

#define CTRLK   11
#define CTRLX   24

#define ON 1
#define OFF 0
#define TIMEOUT -10

//  ASCII Protocol Characters

#define NUL 0
#define SOH 1
#define STX 2
#define ETX 3
#define EOT 4
#define ACK 6
#define DLE 0x10
#define DC1 0x11
#define DC2 0x12
#define DC3 0x13
#define DC4 0x14
#define NAK 0x15
#define ETB 0x17
#define CAN 0x18
#define XON 0x11
#define XOFF 0x13


   // prototypes for GAPCDR functions 

   extern  void _pascal ansi(char *ansicolor);
   extern  void _pascal backspace(short howmany);
   extern  void _pascal do_chat(void );
   extern  void _pascal update_clock(void );
   extern  void _pascal clear_scrn(void );
   extern  void _pascal elap_time(void );
   extern  void _pascal time_left(void );
   extern  void _pascal empty(unsigned char *str,short len);
   extern  FILE * _pascal read_cnf(char *fname);
   extern  short _pascal read_doorsys(void );
   extern  short _pascal init_door(void );
   extern  void _pascal no_carrier(void );
   extern  void _pascal leave(short how);
   extern  short _pascal read_gapuser(char *path );
   extern  short _pascal write_gapuser(char *path );
   extern  short _pascal getakey(void );
   extern  void _pascal get_string(char *fld);
   extern  void _pascal more(void );
   extern  void _pascal nl(char howmany);
   extern  void _pascal pagesysop(void );
   extern  void _pascal pause(void );
   extern  short _pascal read_pcbsys(void );
   extern  short _pascal write_pcbsys(void );
   extern  short _pascal read_pcbuser(char *path);
   extern  short _pascal write_pcbuser(char *path );
   extern  void _pascal write_score(char *datfile,unsigned long score);
   extern  short _pascal read_score(char *datfile,char *message);
   extern  void _pascal show_file(char *filename);
   extern  void _pascal show_mess(char *vstring,char flag,char newline);
   extern  void _pascal set_status(short update);
   extern  void _pascal time_credit(short how);
   extern  char *trim(char *str);
   extern void _pascal cls(void);
   extern void _pascal cls_all(void);
   extern void  _pascal dv_pause(void);
   extern short _pascal dv_here(void);


   // prototypes for private GAPCDR functions 

   extern  void _pascal init_com(void );
   extern  void _pascal wrap_word(void );
   extern  void _pascal putkey(short c);
   extern  short _pascal get_random(short low,short high);
   extern void _pascal make_sound(unsigned short f, short dur);
   extern short _pascal getkeyc(void);
   extern short _pascal access1(char *fname);

   extern void _pascal gapputs(char *string);
	extern void _pascal gapputc(short ch);
   extern void _pascal lputs(char *str);
   extern void _pascal lputc(short ch);
   extern void _pascal curson(void);
   extern void _pascal cursoff(void);
   extern void _pascal timer(unsigned short tics);

   extern void _pascal init_ansi(void);
   extern void _pascal fix_color(void);

   extern void _pascal set_int10(void);
   extern void _pascal rest_int10(void);
   extern void _pascal set_cord(unsigned char topr, unsigned char topc, unsigned char botr, unsigned char botc);
   extern void _pascal set_attr(unsigned char forg, unsigned char back);
   extern void _pascal get_attr(void);
   extern void _pascal save_screen(short row1, short col1, short row2, short col2, unsigned short savemem);
   extern void _pascal restore_screen(short row1, short col1, short row2, short col2, unsigned short savemem);


   extern void _pascal set_cbreak(void);
   extern void _pascal rest_cbreak(void);


   // prototypes for Communications routines

   short  _pascal setport(short  bufsize,short  irq,short  base);
   void   _pascal reset_port(void);
   short  _pascal init_port(short  parity,short  data);

   extern  short _pascal ckeypress(void );
   extern  short _pascal comgetc(void );
   extern  void _pascal near is_carrier(void );
   extern  void _pascal clr_buf(void );
   extern  short _pascal comgetd(short secs);
   extern  void _pascal computc(unsigned char ch);
   extern  void _pascal computs(const unsigned char *str);
   extern  void _pascal computb(const unsigned char *str, short length);
   extern  void _pascal dtr(short how);
   extern  void _pascal rts(short how);
   extern  short _pascal iscd(void );
   extern  short _pascal isring(void );
   extern  short _pascal rxempty(void );
   extern  short _pascal near check_port(void );
