/* Designed and written by David M. Larson, BBS: 916-753-8788 */
/* Copyright (c) 1988,   Dynasoft, P.O. Box 915, Davis, CA 95617 */
/* Refer to GRULES.DOC and GKIT.DOC for details */
#define DEF_GLOBALS 1
#include "GATEWAYS.H"
#include "fcntl.h" /* should only be needed by overgame */
#include "errno.h"
#if IBM_TURBO || IBM_MICROSOFT
#include "conio.h"
#endif
#if USE_longjmp
#include "setjmp.h"
#endif
#if LARGE_DATA
int reserved[30000]; /* reserved data space for other games */
#else
int reserved[8000]; /* reserved data space for other games */
#endif
static int malloc_cnt=0;
static int problem_flag=0;
static long og_file_bitmap=0;
static int test_score;
#if PROTO_ON
void error_check(void);
#else
void error_check();
#endif
#if USE_longjmp
jmp_buf save_env;
#endif
/*=====================================================================*/
main() /* driver function for your game */
{
int i=0;
#if REDUCE_STACK
int reserved[2048]; /* stack space reserved for overgame */
#else
int reserved[512];  /* stack space reserved for overgame */
#endif
  problem_flag=2; /* temporarily suppress carrier loss test */
  outstr("\nWelcome to the Gateways development environment!");

#if AMIGA_MANX
   g0_setup_amiga();
#endif

#if RANDOM_START
  outstr("\nPress any key to start");
  while(keystat()==-2)
     {
     irandom(1);
     i =(++i & 8191);
     }
  keyin(); /* discard the keystroke */
# if IBM_MICROSOFT || IBM_TURBO
    srand(i); /* seed the pseudo random # generator */
# endif
#endif
#if VALIDATE
     outstr("\nFirst I would like to validate a few g0kit.c functions");
     i=og_create("VALIDATE");
     if(i<0) 
     	{ 
     	extern int errno;
     	outstr("\nCould not create VALIDATE file"); 
     	sprintf(gss,"  errno=%d ",errno); outstr(gss);
     	exit(1); 
     	}
   writeline(i,"Test");
   writeline(i," This is exciting! ");
   og_close(i);
   i=og_open("VALIDATE",0);
     if(i<0) { outstr("\nCould not open VALIDATE file"); exit(1); }
   readline(i,gss,sizeof(gss),0);
   readline(i,gss,sizeof(gss),0);
   og_close(i);
   trim(gss); upcfy(gss);
   if(strcmp(gss,"THIS IS EXCITING!")!=0)
     {
     outstr("\nThere is a problem with the file functions");
#if AMIGA_MANX
       g0_close_amiga();
#endif
     exit(1); /* only I can use exit() */
     }
   gp0=og_malloc(8000);
   gp1=og_malloc(8000);
   if(gp1==0 || gp0==0 || gp0==gp1)
     {
     outstr("\nThere is a problem with og_malloc()");
     if(gp1==0) outstr("\nIt thinks there isn't enough memory");
#if AMIGA_MANX
       g0_close_amiga();
#endif
     exit(1); /* only I can use exit() */
     }
    og_free(gp0); og_free(gp1);
   outstr("\ndouble random #s between 0.0 to 1.0:\n");
   for(i=0;i<5;i++) { sprintf(gss,"%g  ",drandom()); outstr(gss); }
   outstr("\ninteger random #s between 0 and 199:\n");
   for(i=0;i<5;i++) { sprintf(gss,"%d  ",irandom(200)); outstr(gss); }
   outstr("\nDo these numbers look reasonable? ");
/* IF YOU GET STUCK HERE, You need to fix keystat() and keyin() */
   while(keystat()==1) keyin(); /* flush keyboard buffer */
   while(keystat()==-2) ; /* wait for keystroke */
   /* notice keystat() and keyin() is being validated */
   i=keyin();
   if(i!='Y' && i!='y')
     {
     outstr("\nSince you said the random #s are not ok, I'll quit");
#if AMIGA_MANX
       g0_close_amiga();
#endif
     exit(1); /* only I can use exit() */
     }
   error_check();
#endif

again:

problem_flag=2;
gfd0=gfd1=gfd2=-1;
gp0=gp1=gp2=gp3=gp4=gp5=gp6=gp7=gp8=gp9=(void *) 0;
outstr("\nBuckle your seat belts!\n");
problem_flag=0;
#if USE_longjmp
if(setjmp(save_env)==0) /* notice the then part of this is GAME() */
#endif
 /* your game function entry point, random player# passed */
   GAME(irandom(MAX_PLAYERS),MAX_PLAYERS,irandom(NUMGATES),NUMGATES);
problem_flag|=2;
if((problem_flag & 1)==0)
     {
     sprintf(gss,"\nYour score was %d",test_score);
     outstr(gss);
     }
error_check();
outstr("\nDo you want to try again? ");
for(;;) /* endless loop waiting for the right characters*/
     {
        i=keyin();
        i=upchar(i);
        if(i=='Y')
          {
          outstr("Y\n");
          goto again; /* I could have used a while() loop */
          }
        if(i=='N')
          {
          outstr("N\n");
          break;
          }
     }
outstr("\nExiting Gateways\n");
#if AMIGA_MANX
  g0_close_amiga();
#endif
for(i=0;i<5;i++) reserved[i]=0; /* trick the lint type error checkers */
return 0;
}
/*=====================================================================*/
void error_check()
   {
   int flag;
   flag=0;
   if(og_file_bitmap!=0)
     {
     flag=1;
     sprintf(gss,"\n***ERROR*** files still open, use og_close()! %d",og_file_bitmap);
     outstr(gss);
     }
   if(malloc_cnt!=0)
      {
      flag=1;
      sprintf(gss,"\n***ERROR*** all og_malloc() 'ed memory is not og_free()'d %d",malloc_cnt);
      outstr(gss);
      }
   if(flag) outstr("\n");
   }
/*=====================================================================*/
#ifndef O_BINARY
#define O_BINARY 0
#endif
int og_open(filename,mode)
/* use this function to open ALL files  (unbuffered) */
char *filename;
int mode; /* mode can be 1 for O_RDWR or 0 for O_RDONLY */
{
/* it will return -3 if you must exit your game
                 (due to filelock or error or carrier loss) */
/* it will return -1 if file did not exist */
extern int errno;
int fd;
if(problem_flag==0 && SIM_CARRIER && irandom(35)==12) /* do not remove! */
   {
   problem_flag=2;
   outstr("\nRANDOM TEST OF og_open() carrier loss or error \n");
   problem_flag=1;
   og_carrier();
   }
if(mode==1) fd=open(filename,O_RDWR+O_BINARY);
else if(mode==0) fd=open(filename,O_RDONLY+O_BINARY);
else { outstr("\nInvalid mode passed to og_open()\n"); return -3; }
if(fd==-1 && errno!=ENOENT) return -3;
og_file_bitmap |= (1L<<fd);
return fd;
}
/*=====================================================================*/
int og_create(filename) char *filename;
{ /* use this function to create ALL files (unbuffered) */
/* it will return -3 if you must exit your game
                 (due to filelock or error or carrier loss) */
int fd;
if(problem_flag==0 && SIM_CARRIER && irandom(15)==3) /* do not remove! */
   {
   problem_flag=2;
   outstr("\nRANDOM TEST OF og_creat() carrier loss or error \n");
   problem_flag=1;
   og_carrier();
   }
fd=open(filename,O_RDWR|O_CREAT|O_TRUNC|O_BINARY);
if(fd==-1) return -3;
else og_file_bitmap |= (1L<<fd);
return fd;
}
/*=====================================================================*/
int og_close(fd) int fd; /* MAKE SURE YOU CLOSE ALL FILES */
{
int i;
/* it will return -3 if you must exit your game due to error */
i=close(fd);
if(i==-1) return -3;
else og_file_bitmap &= ~(1L<<fd);
return 0;
}
/*=====================================================================*/
int readline(fd,buffer,size,stopat) int fd,size; char *buffer,stopat;
{
char *ptr,c;
int i,j,k;
size--; /* to account for the null byte */
i=uread(fd,buffer,size);
if(i<1 || buffer[0]==26) { buffer[0]=0; return -1; }
for(ptr=buffer,j=0;
     j<i && *ptr!=stopat && *ptr!=13 && *ptr!=10 && *ptr!=26;j++) ptr++;
k=j;
c=*ptr;
*ptr++=0;
if(c!=26) j++;
if(j<i && *ptr==10 && c==13) { j++; ptr++; }
if(j<i)
     {
     lseek(fd,((long)(j-i)),1); /* back up to the right spot */
     }
else if(i==size)
     {
         c=0;
        while(uread(fd,&c,1)>0 && c!=stopat && c!=13 && c!=10) ;
   if(c==13)
              {
              uread(fd,&c,1);
              if(c!=10) lseek(fd,-1L,1);
              }
   }
return k;
}
/*=====================================================================*/
int writeline(fd,buffer) int fd; char *buffer;
{
int i;
i=writestr(fd,buffer);
writestr(fd,"\r\n");
return i;
}
/*=====================================================================*/
int writestr(fd,buffer) int fd; char *buffer;
{
char *ptr;
int i;
for(i=0,ptr=buffer;*ptr;ptr++) i++;
if(i>0) write(fd,buffer,i);
return i;
}
/*=====================================================================*/
#if PROTO_ON
void (*fn_onexit)(void)=0;
#else
void (*fn_onexit)()=0;
#endif
/*=====================================================================*/
#if PROTO_ON
void og_onexit(fn) void (*fn)(void);
#else
void og_onexit(fn) void (*fn)();
#endif
/*
fn is function in your game to execute if carrier is lost such as to
close files
*/
{
fn_onexit=fn;
}
/*=====================================================================*/
void og_carrier()
{
if(!SIM_CARRIER || (problem_flag & 2)) return;
if(problem_flag || irandom(C_LOSS_P+100)==52)
   {
   problem_flag |=2;
   if((problem_flag & 1)==0)
      outstr("\nRANDOM TEST OF carrier loss");
   problem_flag=3;
   if(fn_onexit!=0)
      {
      outstr("\nAttempting to execute your exit function");
      (*fn_onexit)();
      }
#if USE_longjmp
   longjmp(save_env,-1); /* jump back to main() */
#else
   error_check();
   outstr("\nThats all folks!\n");
   exit(0);
#endif
   }
}
/*=====================================================================*/
int keyin()
/* returns character pressed */
{ /* get character, no echo */
while(keystat()==-2) ; /* wait for character or carrier loss */
/*********** You need an operating system call to get a character without */
/*********** echoing it here.. */
/*********** it should be compatible with the one used in keystat() */
#if IBM_AZTEC
return bdos(7,0); /* aztec c, use dos function so printscreen doesnt crash */
#endif
#if CPM_AZTEC
return bdos(6,255);
#endif
#if IBM_MICROSOFT || IBM_TURBO
return getch();
#endif
#if AMIGA_MANX
return getchar();
#endif
}
/*=====================================================================*/
int keystat()
/* returns -2 if no char waiting, 1 if char waiting */
{
int retval;
retval=0;
og_carrier();
/*************  you need operating sytem function to check for keyboard */
/*************  activity here (without waiting for a key) */
#if IBM_AZTEC || CPM_AZTEC
/* yep, some IBM functions are clones of CPM */
if(bdos(11,0)==0) retval=-2; else retval=1;
#endif
#if IBM_MICROSOFT || IBM_TURBO
if(kbhit()) retval=1; else retval=-2;
#endif
/***** IF THE OPERATING SYSTEM FUNCTION WASN'T AVAILABLE, FAKE IT ****/
/* return no character waiting most of the time to simulate reality */
if(retval)
  {
  if(irandom(99)==55) retval=1; else retval=-2;
  }
return retval;
}
/*=====================================================================*/
void keyout(c) char c;
{
og_carrier(); /* check for carrier loss */
putchar(c);
}
/*=====================================================================*/
void trim(ss) char *ss;
{
char *ptr1,*ptr2,*ptr3;
ptr1=ptr2=ptr3=ss;
if(*ptr1<=' ')
    {
    while(*ptr1 && *ptr1<=' ') ptr1++;
    while(*ptr1)
     {
     if((*ptr2++ = *ptr1++)>' ') ptr3=ptr2;
        }
     }
else while(*ptr1)
     {
        if(*ptr1++>' ') ptr3=ptr1;
        }
*ptr3=0;
}
/*=====================================================================*/
char upchar(c) char c; /* convert a character to uppercase */
{
if(c>='a' && c<='z') c-=32;
return c;
}
/*=====================================================================*/
void upcfy(ss) char *ss; /* convert a string to upper case */
{
while(*ss)
     {
     if(*ss>='a' && *ss<='z') *ss -=32;
     ss++;
     }
}
/*=====================================================================*/
int og_mode(i) int i; /* set modes of operation */
{ /* use not defined yet */
int dummy;
for(dummy=i;dummy!=i;) ;
return 0;
}
/*=====================================================================*/
int og_gateways(gate) int gate; /*  returns -3 must exit -2 continue */
{
int c,dummy;
for(dummy=gate;dummy!=gate;) ;
outstr("\nPress (1)return to game (2)exit to overgame  ?");
for(;;)
     {
     c=keyin();
     switch(c)
          {
          case '1': outstr("return to game\n"); return -2;
          case -3: return -3; /* carrier loss */
          case '2': outstr("entering gateway\n"); return -3;
          }
     }
}
/*=====================================================================*/
char *og_plname(num) int num; /* return point to player #num's name */
{
int dummy;
for(dummy=num;dummy!=num;) ;
return "Test Player";
}
/*=====================================================================*/
int *og_plscore(num) int num; /* return player #num's score */
{
int dummy;
for(dummy=num;dummy!=num;) ;
return &test_score;
}
/*=====================================================================*/
double drandom() /* return a random double d>=0.0 && d<1.0 */
{
#if IBM_AZTEC || CPM_AZTEC || AMIGA_MANX
double ran();
return ran();
#endif
#if IBM_MICROSOFT || IBM_TURBO
int rand();
double d;
d=rand(); /* automatic cast from int rand() to double d */
d /=32768.0;
return d;
#endif
}
/*=====================================================================*/
int irandom(max) int max; /* return a random integer i>=0 && i<=max-1 */
{
#if IBM_AZTEC || CPM_AZTEC || AMIGA_MANX
double ran();
int v;
v=(int)(ran()*(double)max);
return v;
#endif
#if IBM_MICROSOFT || IBM_TURBO
int rand();
long v;
v=rand();
v *=max;
v /=32768L;
return (int) v;
#endif
}
/*=====================================================================*/
void outstr(ss) char *ss; /* output a string */
{
while(*ss) keyout(*ss++);
}
/*=====================================================================*/
int inpstr(ss,len) /* input a string ss, len doesnt include the null char */
char *ss; int len;
{
char *ptr,*ptrmax;
int c;
ptr=ss; ptrmax=ss+len;
for(;;)
     {
     c=keyin();
   if(c==13) { *ptr=0; return 0; } /* user pressed return */
   if(c==8 && ptr>ss) /* user pressed escape */
     {
     ptr--;
     keyout(8);
     keyout(' ');
     keyout(8);
     }
   else if(c>=' ' && c<127 && ptr<ptrmax)
     {
     keyout(c);
     *ptr++=c;
     }
     }

}
/*=====================================================================*/
int isin(s0,c) char *s0,c;
{
char *s;
s=s0;
while(*s)
  if(*s==c) return s-s0+1;
  else s++;
return 0;
}
/*=====================================================================*/
void *og_malloc(size) int size;
{
void *ptr;
#if IBM_AZTEC || CPM_AZTEC || AMIGA_MANX
void *malloc();
#endif
ptr=malloc((unsigned) size);
if(ptr!=0) malloc_cnt++;
return ptr;
}
/*=====================================================================*/
void og_free(ptr) void *ptr;
{
if(ptr==0) return;
free(ptr);
malloc_cnt--;
}
/*=====================================================================*/
#if AMIGA_MANX
g0_setup_amiga()
{
struct sgttyb stty;
/* To allow raw key input; temporary measure */
/* Set up ioctl() */
ioctl(fileno(stdin),TIOCGETP,&stty);     /* Read the stdin status */
stty.sg_flags |= RAW;                    /* set mode to RAW       */
ioctl(fileno(stdin),TIOCSETP,&stty);     /* write new mode        */
}

g0_close_amiga()
{
struct sgttyb stty;
/* Necessary or CLI screwed up. I don't know what will happen if this */
/* is run from the Workbench */
ioctl(fileno(stdin),TIOCGETP,&stty); /* Go through the whole rigamorole */
stty.sg_flags &= ~RAW;               /* again, to restore things to     */
ioctl(fileno(stdin),TIOCSETP,&stty); /* normal.                         */
}
#endif
/*=====================================================================*/
/* Designed and written by David M. Larson, BBS: 916-753-8788 */
/* Dynasoft, P.O. Box 915, Davis, CA 95617 */