;
; ͻ
;   Mycroft Door Installation  
;     By: Michael W. Bayley    
;          Mar 30, 1989        
; ͼ


;
; ͻ
;   Variable Usage  
; ͼ
;Ŀ
;      String Variables                    Numeric Variables                
;Ĵ
;  %0  General String Input            #0  General Numeric Input            
;  %1  DeArc program Name              #1  Work variable                    
;  %2  Work variable                   #2  Work variable                    
;  %3  Work variable                   #3  Work variable                    
;  %4  Work variable                   #4  Work variable                    
;  %5  Bulletin #1 Drive & Path        #5  Max Time                         
;  %6  Bulletin #2 Drive & Path        #6                                   
;  %7  Bulletin #3 Drive & Path        #7                                   
;  %8  Bulletin #4 Drive & Path        #8                                   
;  %9                                  #9                                   
; %10  BBS Name                       #10  Number of BBS Nodes              
; %11  SysOp Name                     #11                                   
; %12  BBS Type                       #12  BBS Type ID                      
; %13  BBS Tag                        #13                                   
; %14  Monitor Drive & Path           #14                                   
; %15  Batch Filename                 #15  Install/Update Flag              
; %16  Door Drive                     #16                                   
; %17  Door Path                      #17                                   
; %18  Docs Drive & Path              #18                                   
; %19                                 #19                                   
; %20  Node 1 BBS Drive               #20  Node 1 BBS Comm Port #           
; %21  Node 2 BBS Drive               #21  Node 2 BBS Comm Port #           
; %22  Node 3 BBS Drive               #22  Node 3 BBS Comm Port #           
; %23  Node 4 BBS Drive               #23  Node 4 BBS Comm Port #           
; %24                                 #24                                   
; %25  Node 1 BBS Path                #25                                   
; %26  Node 2 BBS Path                #26                                   
; %27  Node 3 BBS Path                #27                                   
; %28  Node 4 BBS Path                #28                                   
; %29                                 #29                                   
; %30  Editor Login                   #30                                   
; %31  Editor Password                #31                                   
;


;
; ͻ
;   Initialize Variables  
; ͼ
;
$SET %14 "<not in use>"
$SET %20 ""
$SET %21 ""
$SET %22 ""
$SET %23 ""
$SET %25 "<not in use>"
$SET %26 "<not in use>"
$SET %27 "<not in use>"
$SET %28 "<not in use>"

$SET #20 0
$SET #21 0
$SET #22 0
$SET #23 0





;
; ͻ
;   Signon Screens  
; ͼ
;
CLS
$MSG
$MSG
$MSG "  The Mycroft Text Display Door         "
$MSG "  Installation Procedure                "
$MSG "  By Michael W. Bayley                  "
$MSG "  Mycroft Systems (408)927-0105         "
$MSG "  Version 1.00  Oct 25, 1990            "
$MSG
$MSG
$MSG "  This program is used to install/update the Mycroft TEXTDOOR on       "
$MSG "  your system.  It is intended to simplify bringing up the door by     "
$MSG "  relieving you of the task of reading all the SysOps documentation    "
$MSG "  and having to build the .BAT files and configuration files.  It is   "
$MSG "  still recommended however that you do read the SysOps documentation. "
$MSG
$MSG "  The following files must be in this directory:                       "
$MSG
$MSG "       INSTALL.BAT                                                    "
$MSG "       INSTALL.DO                                                     "
$MSG "       MTX-D.ZIP                                                      "
$MSG "       MTX-X.ZIP                                                      "
$MSG
$INP %0 "  Press [ENTER] to continue..."

CLS
$MSG
$MSG
$MSG "  This program will perform the following functions:                   "
$MSG
$MSG "       DeZip all SysOp and User documentaton                          "
$MSG "       DeZip all door program files                                   "
$MSG "       Provide the user access to the documentation                   "
$MSG "       Build the node id file (NODES.BBS)                             "
$MSG "       Build door .BAT file                                           "
$MSG "       Build any configuration files                                  "
$MSG "       Run any required program initialization                        "
$MSG
$MSG "  After the installation is complete, the door should be able to be    "
$MSG "  run after you have made any required changes to add the door to      "
$MSG "  your BBS door list.                                                  "
$MSG
$MSG "  If you are running a BBS that is not supported by this door, you     "
$MSG "  will need to use a BBS conversion program and make changes to the    "
$MSG "  .BAT files as required.                                              "
$MSG
$MSG "  Follow the instructions and answer each question carefully.  Typos   "
$MSG "  are the main cause of the door not being setup correctly.            "
$MSG

$:VALID
$INP %0 "  Enter [I] to install, [U] to update, or [Q] to quit: "
$IF %0 = "I" INSTALL
$IF %0 = "i" INSTALL
$IF %0 = "U" UPDATE
$IF %0 = "u" UPDATE
$IF %0 = "Q" ABORT
$IF %0 = "q" ABORT
$GOTO VALID

$:ABORT
$MSG
$MSG "  Process aborted..."
$MSG
$GOTO DONE





;
; ͻ
;   Get All Input  
; ͼ
;
$:INSTALL
$SET #15 1
$GOTO START
;
$:UPDATE
$SET #15 0
;
$:START
$GOSUB BBS_NAME
$GOSUB SYSOP
$GOSUB BBS_TYPE

$IF #12 < 3 NO_MON
$IF #12 > 4 NO_MON
$GOSUB MON_PATH

$:NO_MON
$GOSUB NODES

$SET #30 1
$SET #1 #30
$GOSUB BBS_PATH
$SET %20 %2
$SET %25 %3
$SET #1 #30
$GOSUB BBS_COMM
$SET #20 #1
$ADD #30 1

$IF #30 > #10 LPEND
$SET #1 #30
$GOSUB BBS_PATH
$SET %21 %2
$SET %26 %3
$SET #1 #30
$GOSUB BBS_COMM
$SET #21 #1
$ADD #30 1

$IF #30 > #10 LPEND
$SET #1 #30
$GOSUB BBS_PATH
$SET %22 %2
$SET %27 %3
$SET #1 #30
$GOSUB BBS_COMM
$SET #22 #1
$ADD #30 1

$IF #30 > #10 LPEND
$SET #1 #30
$GOSUB BBS_PATH
$SET %23 %2
$SET %28 %3
$SET #1 #30
$GOSUB BBS_COMM
$SET #23 #1

$:LPEND

$GOSUB DOORPATH
$GOSUB BAT_NAME





;
; ͻ
;   Main Control Menu  
; ͼ
;
$:MENU
CLS
$MSG
$MSG "  Ŀ"
$MSG "                      M Y C R O F T   T E X T   D O O R                     "
$MSG "  "
$SET %2 "        [1]  BBS Name                 : "
$CAT %2 %10
$MSG %2
$SET %2 "        [2]  SysOps Name              : "
$CAT %2 %11
$MSG %2
$SET %2 "        [3]  BBS Type                 : "
$CAT %2 %12
$MSG %2
$SET %2 "        [4]  Monitor Path             : "
$CAT %2 %14
$MSG %2
$SET %2 "        [5]  Door Batch Filename      : "
$CAT %2 %15
$MSG %2
$SET %2 "        [6]  Door Drive & Path        : "
$CAT %2 %16
$CAT %2 %17
$SET %2 "        [7]  Node Count               : "
$CAT %2 #10
$MSG %2
$SET %2 "        [8]  Node 1 Port, Drive & Path: COM"
$CAT %2 #20
$CAT %2 ":  -  "
$CAT %2 %20
$CAT %2 %25
$MSG %2
$SET %2 "        [9]  Node 2 Port, Drive & Path: COM"
$CAT %2 #21
$CAT %2 ":  -  "
$CAT %2 %21
$CAT %2 %26
$MSG %2
$SET %2 "       [10]  Node 3 Port, Drive & Path: COM"
$CAT %2 #22
$CAT %2 ":  -  "
$CAT %2 %22
$CAT %2 %27
$MSG %2
$SET %2 "       [11]  Node 4 Port, Drive & Path: COM"
$CAT %2 #23
$CAT %2 ":  -  "
$CAT %2 %23
$CAT %2 %28
$MSG %2
$MSG "  "
$INP %0 "  Enter item to change, [ENTER] to build, or [Q] to quit: "

$IF %0 = "1" MENU1
$IF %0 = "2" MENU2
$IF %0 = "3" MENU3
$IF %0 = "4" MENU4
$IF %0 = "5" MENU5
$IF %0 = "6" MENU6
$IF %0 = "7" MENU7
$IF %0 = "8" MENU8
$IF %0 = "9" MENU9
$IF %0 = "10" MENU10
$IF %0 = "11" MENU11
$IF %0 = "Q" ABORT
$IF %0 = "q" ABORT
$IF %0 = "" BUILD


$MSG "  Error - Invalid selection."
$:DELAY
$SET #0 1
$IF #0 = 25 MENU
$ADD #0 1
$GOTO DELAY


$:MENU1
$GOSUB BBS_NAME
$GOTO MENU


$:MENU2
$GOSUB SYSOP
$GOTO MENU


$:MENU3
$GOSUB BBS_TYPE
$GOTO MENU


$:MENU4
$GOSUB MON_PATH
$GOTO MENU


$:MENU5
$GOSUB BAT_NAME
$GOTO MENU


$:MENU6
$GOSUB DOORPATH
$GOTO MENU


$:MENU7
$GOSUB NODES
$GOTO MENU


$:MENU8
$SET #1 1
$GOSUB BBS_PATH
$SET %20 %2
$SET %25 %3
$SET #1 1
$GOSUB BBS_COMM
$GOTO MENU


$:MENU9
$SET #1 2
$GOSUB BBS_PATH
$SET %21 %2
$SET %26 %3
$SET #1 2
$GOSUB BBS_COMM
$GOTO MENU


$:MENU10
$SET #1 3
$GOSUB BBS_PATH
$SET %22 %2
$SET %27 %3
$SET #1 3
$GOSUB BBS_COMM
$GOTO MENU


$:MENU11
$SET #1 4
$GOSUB BBS_PATH
$SET %23 %2
$SET %28 %3
$SET #1 4
$GOSUB BBS_COMM
$GOTO MENU





;
; ͻ
;   Build Required Directories  
; ͼ
;
$:BUILD
CLS
$MSG
$MSG "  Ŀ"
$MSG "                      M Y C R O F T   T E X T   D O O R                     "
$MSG "  "
$MSG
$MSG "  Building directories..."
$SET %2 %16
$CAT %2 %17
MAKEDIR %2
$CAT %2 "\DOCS"
MAKEDIR %2





;
; ͻ
;   UnZip Documentation  
; ͼ
;
$MSG "  UnZipping documentation..."
PKUNZIP -o MTX-D.ZIP %2 *.* >NUL





;
; ͻ
;   UnZip Program Files  
; ͼ
;
$MSG "  UnZipping program files..."
$SET %2 %16
$CAT %2 %17
PKUNZIP -o MTX-X.ZIP %2 *.* >NUL





;
; ͻ
;   Build NODES.BBS  
; ͼ
;
$MSG "  Building node ID file(s)..."

$IF #12 < 3 NBBS0
$IF #12 > 4 NBBS0
$SET %2 %14
$GOTO NBBS1

$:NBBS0
$SET %2 %20
$CAT %2 %25

$:NBBS1
$CAT %2 "\NODES.BBS"
REMOVE %2
$:NBBS1_NO
$SET %3 "COM"
$CAT %3 #20
$WRITE %2 %3
$SET %3 "COM"
$CAT %3 #21
$WRITE %2 %3
$SET %3 "COM"
$CAT %3 #22
$WRITE %2 %3
$SET %3 "COM"
$CAT %3 #23
$WRITE %2 %3
$SET %3 %16
$CAT %3 %17
$CAT %3 "\NODES.BBS"
COPY %2 %3 >NUL

$IF #12 = 3 BATCH
$IF #12 = 4 BATCH
$IF #10 < 2 BATCH
$SET %3 %21
$CAT %3 %26
$CAT %3 "\NODES.BBS"
$IF %2 = %3 NBBS3
COPY %2 %3 >NUL

$:NBBS3
$IF #10 < 3 BATCH
$SET %3 %22
$CAT %3 %27
$CAT %3 "\NODES.BBS"
$IF %2 = %3 NBBS4
COPY %2 %3 >NUL

$:NBBS4
$IF #10 < 4 BATCH
$SET %3 %23
$CAT %3 %28
$CAT %3 "\NODES.BBS"
$IF %2 = %3 BATCH
COPY %2 %3 >NUL





;
; ͻ
;   Build Batch Files  
; ͼ
;
$:BATCH
$IF #12 < 3 BAT1
$IF #12 > 4 BAT1

$MSG "  Copying MONITOR1.EXE file to door directory..."
$SET %2 %14
$CAT %2 "\MONITOR1.EXE"
$SET %3 %16
$CAT %3 %17
$IF EXISTS %2 MON_COPY

$MSG "  WARNING - MONITOR1.EXE file not found!"
$GOTO CONFIG

$:MON_COPY
COPY %2 %3
$GOTO CONFIG

$:BAT1
$MSG "  Building door batch file(s)..."
$SET %2 %20
$CAT %2 %25
$CAT %2 "\"
$CAT %2 %15
REMOVE %2
$:BAT1_NO
$WRITE %2 "ECHO OFF"
$WRITE %2 "ECHO Ŀ"
$WRITE %2 "ECHO   MYCROFT TEXT DOOR  "
$WRITE %2 "ECHO "
$WRITE %2 %16
$SET %3 "CD "
$CAT %3 %17
$WRITE %2 %3

$SET %3 "TEXTDOOR"
$IF #12 = 1 BAT11
$IF #12 = 2 BAT11
$CAT %3 " 1 "
$GOTO BAT12
$:BAT11
$CAT %3 " %1 "
$:BAT12
$CAT %3 %20
$CAT %3 %25
$CAT %3 " "
$CAT %3 %13
$WRITE %2 %3

$WRITE %2 %20
$SET %3 "CD "
$CAT %3 %25
$WRITE %2 %3
$WRITE %2 " "



$:BAT2
$IF #10 < 2 CONFIG
$SET %4 %21
$CAT %4 %26
$CAT %4 "\"
$CAT %4 %15
$IF %2 = %4 BAT3
$SET %2 %4
REMOVE %2
$:BAT2_NO
$WRITE %2 "ECHO OFF"
$WRITE %2 "ECHO Ŀ"
$WRITE %2 "ECHO   MYCROFT TEXT DOOR  "
$WRITE %2 "ECHO "
$WRITE %2 %16
$SET %3 "CD "
$CAT %3 %17
$WRITE %2 %3

$SET %3 "TEXTDOOR"
$IF #12 = 1 BAT21
$IF #12 = 2 BAT21
$CAT %3 " 2 "
$GOTO BAT22
$:BAT21
$CAT %3 " %1 "
$:BAT22
$CAT %3 %21
$CAT %3 %26
$CAT %3 " "
$CAT %3 %13
$WRITE %2 %3

$WRITE %2 %21
$SET %3 "CD "
$CAT %3 %26
$WRITE %2 %3
$WRITE %2 " "



$:BAT3
$IF #10 < 3 CONFIG
$SET %4 %22
$CAT %4 %27
$CAT %4 "\"
$CAT %4 %15
$IF %2 = %4 BAT4
$SET %2 %4
REMOVE %2
$:BAT3_NO
$WRITE %2 "ECHO OFF"
$WRITE %2 "ECHO Ŀ"
$WRITE %2 "ECHO   MYCROFT TEXT DOOR  "
$WRITE %2 "ECHO "
$WRITE %2 %16
$SET %3 "CD "
$CAT %3 %17
$WRITE %2 %3

$SET %3 "TEXTDOOR"
$IF #12 = 1 BAT31
$IF #12 = 2 BAT31
$CAT %3 " 3 "
$GOTO BAT32
$:BAT31
$CAT %3 " %1 "
$:BAT32
$CAT %3 %22
$CAT %3 %27
$CAT %3 " "
$CAT %3 %13
$WRITE %2 %3

$WRITE %2 %22
$SET %3 "CD "
$CAT %3 %27
$WRITE %2 %3
$WRITE %2 " "



$:BAT4
$IF #10 < 4 CONFIG
$SET %4 %23
$CAT %4 %28
$CAT %4 "\"
$CAT %4 %15
$IF %2 = %4 CONFIG
$SET %2 %4
REMOVE %2
$:BAT4_NO
$WRITE %2 "ECHO OFF"
$WRITE %2 "ECHO Ŀ"
$WRITE %2 "ECHO   MYCROFT TEXT DOOR  "
$WRITE %2 "ECHO "
$WRITE %2 %16
$SET %3 "CD "
$CAT %3 %17
$WRITE %2 %3

$SET %3 "TEXTDOOR"
$IF #12 = 1 BAT41
$IF #12 = 2 BAT41
$CAT %3 " 4 "
$GOTO BAT42
$:BAT41
$CAT %3 " %1 "
$:BAT42
$CAT %3 %23
$CAT %3 %28
$CAT %3 " "
$CAT %3 %13
$WRITE %2 %3

$WRITE %2 %23
$SET %3 "CD "
$CAT %3 %28
$WRITE %2 %3
$WRITE %2 " "





;
; ͻ
;   Build Configuration Files  
; ͼ
;
$:CONFIG
$MSG "  Building door configuration file..."
$SET %2 %16
$CAT %2 %17
$CAT %2 "\TEXTDOOR.CFG"
REMOVE %2
$:CFG_NO
$WRITE %2 %10
$WRITE %2 %11
$WRITE %2 "1"
$WRITE %2 "32"
$WRITE %2 "1"
$WRITE %2 "-- BULLETIN SELECTIONS --"
$WRITE %2 "TXSAMPLE.BUL     TXSAMPLE.CLR      Sample Text File"




;
; ͻ
;   Signoff Message  
; ͼ
;
$:SIGNOFF
CLS
$MSG
$MSG "  Ŀ"
$MSG "                      M Y C R O F T   T E X T   D O O R                     "
$MSG "  "
$MSG
$MSG "    The Mycroft Text Display Door is now ready to run.  The program is set  "
$MSG "    for a sample bulletin file.  You will need to modify the TEXTDOOR.CFG   "
$MSG "    file to add your own display files.  Please read the documentation for  "
$MSG "    the format of this file.  You will need to modify your BBS configuration"
$MSG "    files to recognize this door.  Also if your BBS software needs to be    "
$MSG "    re-run after the door terminates then you will need to add a line at the"
$MSG "    end of the batch files to do that."
$MSG
$MSG "    I hope you that you and your users enjoy this door.  If you have any    "
$MSG "    problems please contact me at Mycroft Systems as listed below.  Also    "
$MSG "    please take the time to fill out the registration from and mail it to me"
$MSG "    at:                                                                     "
$MSG
$MSG "                                Mycroft Systems  "
$MSG "                                 P.O. Box 7672   "
$MSG "                              San Jose, CA. 95150"
$MSG "                                 (408)927-0105   "
$MSG





;
; ͻ
;   All Done, Exit  
; ͼ
;

$:DONE
$EXIT 0






;
; ͻ
;   Get the BBS name  
; ͼ
;
$:BBS_NAME
;
CLS
$MSG
$MSG "  Ŀ"
$MSG "              BBS NAME           "
$MSG "  Ĵ"
$MSG "   Enter the name of your BBS as "
$MSG "    you wish it to show in the   "
$MSG "           door program.         "
$MSG "                                 "
$MSG "     Example: Mycroft Systems    "
$MSG "  "
$INP %10 "  >"
$RETURN





;
; ͻ
;   Get the SysOp name  
; ͼ
;
$:SYSOP
;
CLS
$MSG
$MSG "  Ŀ"
$MSG "             SYSOP NAME          "
$MSG "  Ĵ"
$MSG "   Enter the name you use as the "
$MSG "        SysOp of your BBS.       "
$MSG "                                 "
$MSG "       Example: Mike Bayley      "
$MSG "  "
$INP %11 "  >"
$RETURN





;
; ͻ
;   Get the Editor name  
; ͼ
;
$:LOGIN
;
CLS
$MSG
$MSG "  Ŀ"
$MSG "         EDITOR LOGIN NAME       "
$MSG "  Ĵ"
$MSG "   Enter the user login name of  "
$MSG "    the person you wish to have  "
$MSG "    access to the doors editor.  "
$MSG "                                 "
$MSG "           Example: SYSOP        "
$MSG "  "
$INP %30 "  >"
$RETURN





;
; ͻ
;   Get the Editor Password  
; ͼ
;
$:PASSWORD
;
CLS
$MSG
$MSG "  Ŀ"
$MSG "          EDITOR PASSWORD        "
$MSG "  Ĵ"
$MSG "    Enter the password you wish  "
$MSG "    to use to gain access to the "
$MSG "           doors editor.         "
$MSG "                                 "
$MSG "         Example: Mycroft        "
$MSG "  "
$INP %31 "  >"
$RETURN





;
; ͻ
;   Get the BBS type  
; ͼ
;
$:BBS_TYPE
;
CLS
$MSG
$MSG "  Ŀ"
$MSG "         BBS ENVIRONMENT TYPE        "
$MSG "  Ĵ"
$MSG "     1. RBBS 15                      "
$MSG "     2. RBBS 16 or RBBS 17           "
$MSG "     3. Bob Wescotts Door Monitor    "
$MSG "     4. G-Mon                        "
$MSG "     5. Quick BBS                    "
$MSG "     6. PC-Board 12.1                "
$MSG "     7. PC-Board 14.0                "
$MSG "     8. Wildcat BBS                  "
$MSG "     9. GAP BBS                      "
$MSG "    10. WWIV BBS                     "
$MSG "    11. Spitfire BBS (Doors)         "
$MSG "    12. Spitfire BBS (Main menu cmd) "
$MSG "    13. Spitfire BBS (Msg. menu cmd) "
$MSG "    14. Spitfire BBS (File menu cmd) "
$MSG "  "
;
$:BBS_T0
;
$INP #12 "  >"
$IF #12 < 1 BBS_TERR
;
$:BBS_T1
$IF #12 > 1 BBS_T2
$SET %12 "RBBS 15"
$SET %13 ""
$RETURN
;
$:BBS_T2
$IF #12 > 2 BBS_T3
$SET %12 "RBBS"
$SET %13 "RBBS"
$RETURN
;
$:BBS_T3
$IF #12 > 3 BBS_T4
$SET %12 "Wescotts Monitor"
$SET %13 ""
$RETURN
;
$:BBS_T4
$IF #12 > 4 BBS_T5
$SET %12 "G-Mon"
$SET %13 ""
$RETURN
;
$:BBS_T5
$IF #12 > 5 BBS_T6
$SET %12 "Quick BBS"
$SET %13 "QBBS"
$RETURN
;
$:BBS_T6
$IF #12 > 6 BBS_T7
$SET %12 "PC-Board 12.1"
$SET %13 "PCBOARD"
$RETURN
;
$:BBS_T7
$IF #12 > 7 BBS_T8
$SET %12 "PC-Board 14.0"
$SET %13 "PCBOARD14"
$RETURN
;
$:BBS_T8
$IF #12 > 8 BBS_T9
$SET %12 "Wildcat BBS"
$SET %13 "WILDCAT"
$RETURN
;
$:BBS_T9
$IF #12 > 9 BBS_T10
$SET %12 "Gap BBS"
$SET %13 "GAP"
$RETURN
;
$:BBS_T10
$IF #12 > 10 BBS_T11
$SET %12 "WWIV BBS"
$SET %13 "WWIV"
$RETURN
;
$:BBS_T11
$IF #12 > 11 BBS_T12
$SET %12 "Spitfire BBS (Doors)"
$SET %13 "SPITFIRE"
$RETURN
;
$:BBS_T12
$IF #12 > 12 BBS_T13
$SET %12 "Spitfire BBS (Main menu cmd.)"
$SET %13 "SPITFIREK"
$RETURN
;
$:BBS_T13
$IF #12 > 13 BBS_T14
$SET %12 "Spitfire BBS (Msg. menu cmd.)"
$SET %13 "SPITFIREM"
$RETURN
;
$:BBS_T14
$IF #12 > 14 BBS_TERR
$SET %12 "Spitfire BBS (File menu cmd.)"
$SET %13 "SPITFIREF"
$RETURN
;
$:BBS_TERR
$MSG "  Error, please enter a number between 1 and 14."
$GOTO BBS_T0





;
; ͻ
;   Get the Monitor drive & path  
; ͼ
;
$:MON_PATH
;
CLS
$MSG
$MSG "  Ŀ"
$MSG "   DOOR MONITOR DRIVE & PATHNAME "
$MSG "  Ĵ"
$MSG "   Enter the complete drive and  "
$MSG "   pathname for the location of  "
$MSG "        your monitor files.      "
$MSG "                                 "
$MSG "      Example: C:\RBBS\G-MON     "
$MSG "  "
$INP %14 "  >"
$RETURN





;
; ͻ
;   Get the BBS node count  
; ͼ
;
$:NODES
CLS
$MSG
$MSG "  Ŀ"
$MSG "        NUMBER OF BBS NODES      "
$MSG "  Ĵ"
$MSG "       1. System has 1 node      "
$MSG "       2. System has 2 nodes     "
$MSG "       3. System has 3 nodes     "
$MSG "       4. System has 4 nodes     "
$MSG "  "
;
$:NODE_0
$INP #10 "  >"
$IF #10 = 1 NODE_1
$IF #10 = 2 NODE_2
$IF #10 = 3 NODE_3
$IF #10 = 4 NODE_4
$GOTO NODE_ERR

$:NODE_1
$SET %23 ""
$SET %28 "<not in use>"
$SET #23 0

$:NODE_2
$SET %22 ""
$SET %27 "<not in use>"
$SET #22 0

$:NODE_3
$SET %21 ""
$SET %26 "<not in use>"
$SET #21 0

$:NODE_4
$RETURN
;
$:NODE_ERR
$MSG "  Error, please enter a number between 1 and 4."
$GOTO NODE_0





;
; ͻ
;   Get the BBS drive & path  
; ͼ
;
$:BBS_PATH
CLS
$MSG
$MSG "  Ŀ"
$MSG "             BBS DRIVE           "
$MSG "  Ĵ"
$SET %3 "              NODE #"
$CAT %3 #1
$CAT %3 "            "
$MSG %3
$MSG "                                 "
$MSG "     1. A:     5. E:     9. I:   "
$MSG "     2. B:     6. F:    10. J:   "
$MSG "     3. C:     7. G:    11. K:   "
$MSG "     4. D:     8. H:    12. L:   "
$MSG "  "
;
$:BBS_P0
$INP #0 "  >"
$IF #0 < 1 BBS_PERR
;
$:BBS_P1
$IF #0 > 1 BBS_P2
$SET %2 "A:"
$GOTO BBS_PTH2
;
$:BBS_P2
$IF #0 > 2 BBS_P3
$SET %2 "B:"
$GOTO BBS_PTH2
;
$:BBS_P3
$IF #0 > 3 BBS_P4
$SET %2 "C:"
$GOTO BBS_PTH2
;
$:BBS_P4
$IF #0 > 4 BBS_P5
$SET %2 "D:"
$GOTO BBS_PTH2
;
$:BBS_P5
$IF #0 > 5 BBS_P6
$SET %2 "E:"
$GOTO BBS_PTH2
;
$:BBS_P6
$IF #0 > 6 BBS_P7
$SET %2 "F:"
$GOTO BBS_PTH2
;
$:BBS_P7
$IF #0 > 7 BBS_P8
$SET %2 "G:"
$GOTO BBS_PTH2
;
$:BBS_P8
$IF #0 > 8 BBS_P9
$SET %2 "H:"
$GOTO BBS_PTH2
;
$:BBS_P9
$IF #0 > 9 BBS_P10
$SET %2 "I:"
$GOTO BBS_PTH2
;
$:BBS_P10
$IF #0 > 10 BBS_P11
$SET %2 "J:"
$GOTO BBS_PTH2
;
$:BBS_P11
$IF #0 > 11 BBS_P12
$SET %2 "K:"
$GOTO BBS_PTH2
;
$:BBS_P12
$IF #0 > 12 BBS_PERR
$SET %2 "L:"
$GOTO BBS_PTH2
;
$:BBS_PERR
$MSG "  Error, please enter a number between 1 and 12."
$GOTO BBS_P0


$:BBS_PTH2
;
$MSG
$MSG "  Ŀ"
$MSG "           BBS PATHNAME          "
$MSG "  Ĵ"
$SET %3 "              NODE #"
$CAT %3 #1
$CAT %3 "            "
$MSG %3
$MSG "                                 "
$MSG "   Enter the complete path where "
$MSG "       your BBS software is.     "
$MSG "                                 "
$MSG "          Example: \RBBS         "
$MSG "  "
$INP %3 "  >"
$RETURN





;
; ͻ
;   Get the BBS node comm port  
; ͼ
;
$:BBS_COMM
CLS
$MSG
$MSG "  Ŀ"
$MSG "   BBS NODE COMM PORT ASSIGNMENT "
$MSG "  Ĵ"
$SET %3 "              NODE #"
$CAT %3 #1
$CAT %3 "            "
$MSG %3
$MSG "                                 "
$MSG "           1. Uses COM1          "
$MSG "           2. Uses COM2          "
$MSG "           3. Uses COM3          "
$MSG "           4. Uses COM4          "
$MSG "  "
;
$:COMM_0
$INP #1 "  >"
$IF #1 < 1 COMM_ERR
$IF #1 > 4 COMM_ERR
$RETURN
;
$:COMM_ERR
$MSG "  Error, please enter a number between 1 and 4."
$GOTO COMM_0





;
; ͻ
;   Get the door drive & path  
; ͼ
;
$:DOORPATH
CLS
$MSG
$MSG "  Ŀ"
$MSG "            DOOR DRIVE           "
$MSG "  Ĵ"
$MSG "     1. A:     5. E:     9. I:   "
$MSG "     2. B:     6. F:    10. J:   "
$MSG "     3. C:     7. G:    11. K:   "
$MSG "     4. D:     8. H:    12. L:   "
$MSG "  "
;
$:DOR_P0
$INP #0 "  >"
$IF #0 < 1 DOR_PERR
;
$:DOR_P1
$IF #0 > 1 DOR_P2
$SET %16 "A:"
$GOTO DOORPTH2
;
$:DOR_P2
$IF #0 > 2 DOR_P3
$SET %16 "B:"
$GOTO DOORPTH2
;
$:DOR_P3
$IF #0 > 3 DOR_P4
$SET %16 "C:"
$GOTO DOORPTH2
;
$:DOR_P4
$IF #0 > 4 DOR_P5
$SET %16 "D:"
$GOTO DOORPTH2
;
$:DOR_P5
$IF #0 > 5 DOR_P6
$SET %16 "E:"
$GOTO DOORPTH2
;
$:DOR_P6
$IF #0 > 6 DOR_P7
$SET %16 "F:"
$GOTO DOORPTH2
;
$:DOR_P7
$IF #0 > 7 DOR_P8
$SET %16 "G:"
$GOTO DOORPTH2
;
$:DOR_P8
$IF #0 > 8 DOR_P9
$SET %16 "H:"
$GOTO DOORPTH2
;
$:DOR_P9
$IF #0 > 9 DOR_P10
$SET %16 "I:"
$GOTO DOORPTH2
;
$:DOR_P10
$IF #0 > 10 DOR_P11
$SET %16 "J:"
$GOTO DOORPTH2
;
$:DOR_P11
$IF #0 > 11 DOR_P12
$SET %16 "K:"
$GOTO DOORPTH2
;
$:DOR_P12
$IF #0 > 12 DOR_PERR
$SET %16 "L:"
$GOTO DOORPTH2
;
$:DOR_PERR
$MSG "  Error, please enter a number between 1 and 12."
$GOTO DOR_P0


$:DOORPTH2
;
$MSG
$MSG "  Ŀ"
$MSG "           DOOR PATHNAME         "
$MSG "  Ĵ"
$MSG "   Enter the complete path where "
$MSG "      the door will be run.      "
$MSG "                                 "
$MSG "     Example: \DOORS\OPINION     "
$MSG "  "
$INP %17 "  >"
$RETURN





;
; ͻ
;   Get the user documentation drive & path  
; ͼ
;
$:DOCSPATH
;
CLS
$MSG
$MSG "  Ŀ"
$MSG "  USER DOCUMENTATION DRIVE & PATH"
$MSG "  Ĵ"
$MSG "   Enter the complete drive and  "
$MSG "   pathname for the location of  "
$MSG "    the downloadable doc files.  "
$MSG "                                 "
$MSG "      Example: C:\RBBS\DOCS      "
$MSG "  "
$INP %18 "  >"
$RETURN





;
; ͻ
;   Get the door batch filename  
; ͼ
;
$:BAT_NAME
;
CLS
$MSG
$MSG "  Ŀ"
$MSG "        DOOR BATCH FILENAME      "
$MSG "  Ĵ"
$MSG "    Enter the name of the BATCH  "
$MSG "    file you wish to use to run  "
$MSG "    the door.  Do not include a  "
$MSG "        drive or pathname.       "
$MSG "                                 "
$MSG "       Example: OPINION.BAT      "
$MSG "  "
$INP %15 "  >"
$RETURN





;
; ͻ
;   Get the door bulletin drive, path & filename 
; ͼ
;
$:BUL_NAME
;
CLS
$MSG
$MSG "  Ŀ"
$MSG "           BULLETIN NAME         "
$MSG "  Ĵ"
$MSG %2
$MSG "                                 "
$MSG "  Enter the complete drive, path "
$MSG "  and filename for this bulletin."
$MSG "                                 "
$MSG "     Example: C:\RBBS\BULLET10   "
$MSG "  "
$INP %2 "  >"
$RETURN





$:MAX_TIME
;
CLS
$MSG
$MSG "  Ŀ"
$MSG "         MAXIMUM DOOR TIME       "
$MSG "  Ĵ"
$MSG "                                 "
$MSG "    Enter the maximum number of  "
$MSG "   minutes user may stay in door "
$MSG "                                 "
$MSG "            Example: 15          "
$MSG "  "
$INP #5 "  >"
$RETURN





