Unit TwTrad2;

{
Copyright (C) 1993 by David Myers.  All rights reserved.  Personal
copying and use of this code permitted.  This source cannot be
sold or distributed for more than the cost of media.
}

Interface
Uses
  Crt, FlyCom, FParser, TwBuffer, TwScr, TwAnsi, TwLine, TwTrade;

Procedure HalfSteal;
Implementation

Procedure HalfSteal;
Const
  Risk = 0.0333333333; { assuming 1/30 chance of getting caught }

Var
  Port1Buy, Port2Buy, ExpStr : String;
  P1b, P1s : real3;
  P1F : Real3;
  NTraded, MaxNBought : integer;
  P1_4Sale,P2_4Sale : integer;
  P1Haggle, P2Haggle : Integer;
  P1Buy, P2Buy : integer;
  TotHolds,SumHolds : integer;
  Bp5p , Fo5p : integer;
  Holds : Int3;
  Loop : Boolean;
  HasSold : Boolean;
  X,Y,i : integer;
  experience, MostEff, EffHolds,ec1 : integer;
  eff,neweff,rtemp : real;
  OneMinusRisk, lnOMR, NRisk : real;
  holdspt, newholds, maxcyc, nturns, turns, xsteal : integer;
  StealHolds : integer;


BEGIN
  OneMinusRisk := 1.0 - Risk;
  lnOMR := ln(OneMinusRisk);
  SaveScreen(X,Y);
  Window(5,5,40,15);
  YellowVideo;
  ClrScr;
  Loop := TRUE;
  for i := 1 to 3 do begin
    { none of these are used but it keeps process_port_pair happy }
    P1F[i] := DefaultFactor;
    P1B[i] := DefaultBuy;
    P1S[i] := DefaultSell;
  end;
  WriteLn('   Half Steal/Sell: ');
    Write('         Port Type: ');
  ReadLn(Port1Buy);
  { if somebody enters a port class, convert it to the 3 char string }
  If ((length(Port1Buy) = 1) and (isdigit(Port1Buy[1]))) then
    Port1Buy := ClassStr[Ord(Port1Buy[1]) - Ord('0')];
  Port2Buy := Port1Buy;
  Port2Buy[3] := 'S';
  { Finding out how many products we can "trade" }

  Process_Port_Pair(Port1Buy,Port2Buy,NTraded,P1Buy,P2Buy,
                    P1Haggle,P2Haggle,P1_4Sale,P2_4Sale);

  { if we can sell equipment to this port, then steal }
  If (NTraded > 0) THEN
    BEGIN
      Write('  Your Experience : ');
      BuildString(ExpStr);WriteLn;
      Write(' How many Holds to Trade with : ');
      ReadLn(TotHolds);
      experience := 0;
      If (Length(ExpStr) > 0) then begin
        Val(ExpStr,experience,ec1);
        if (ec1 <> 0) then
          experience := 0;
      end;
      if (experience > 0) then begin
        rtemp := experience / 100;
        holdspt := round(5*rtemp); { round to nearest 5 holds of exp/20 }
        if (holdspt >= totholds) then begin
          stealholds := totholds;
          mosteff := 1;
          {
            trading efficiency = (holds sold per turn - risk*#holds that can
            be lost per turn - risk*loss of holds that could be stolen with
            lost experience per turn)
          }
          eff := (stealholds - Risk*(stealholds + experience/200))
                 /(mosteff + 1.0);
        end
        else begin
          maxcyc := totholds div holdspt + 1;
          mosteff := 0;
          eff := 0.0;
          stealholds := 0;
          for turns := 1 to maxcyc do begin
            NRisk := 1.0 - exp(turns*lnOMR);
            nturns := turns + 1;
            if (turns*holdspt > TotHolds) then
              newholds := TotHolds div turns
            else newholds := holdspt;
            { ok, how efficient is this potential loop? }
            {
              efficiency = turns*holds/# turns for loop -
                           cumulative risk for loop turns * (
                           mean number of holds to be lost +
                           holds equivalent to 10% of exp)/
                           # turns for loop
            }
            neweff := (turns*newholds - NRisk*
                      (newholds*(turns+1)/2 + experience/200))/nturns;
            if (neweff > eff) then begin
              mosteff := turns;
              eff := neweff;
              stealholds := newholds;
            end;
          end; { for turns }
        end;
      end
      else begin
        StealHolds := TotHolds;
        MostEff := 1;
        eff := stealholds*(1 - Risk)/(mosteff + 1.0);
      end;
      For i := 1 to 3 do begin
        If i = 3 then
          Holds[i] := StealHolds*MostEff
        else Holds[i] := 0;
      end;
      Writeln(' Stealing ',StealHolds:3,' Holds for ');
      WriteLn(' ',MostEff:1,' Consecutive Turns.');
      WriteLn(' Eff = ',Eff:7:2,' holds/turn.');
      Delay(2500);
      NormalVideo;
      SelectWindow(2);
      RestoreScreen;
      GoToXY(X,Y);
      { notify user Stealing Macro is active }
      TextColor(White);
      TextBackground(Cyan);
      SelectWindow(1);
      ClrScr;
      Write('      === ALT 7 - HalfSteal Steal/Sell. ALT Q Quits. ===      ');
      NormalVideo;
      SelectWindow(2);
      GoToXY(X,Y);

      { stealing loop }
      BP5P := 0;
      FO5P := 0;
      HasSold := FALSE;
      { Steal *Once*}
      xsteal := 0;
      While ((xsteal < Mosteff) and Loop) do begin
        StealAtAPort(Loop,HasSold,StealHolds,SHalf);
        Inc(xsteal);
      end;
      SaveScreen(X,Y);
      TextColor(Yellow);
      TextBackground(Blue);
      GoToXY(10,10);WriteLn('                          ');
      GoToXY(10,11);WriteLn(' Exiting Half-STEAL Macro ');
      GoToXY(10,12);WriteLn('                          ');
      Delay(3000);
      NormalVideo;
      RestoreScreen;
      GotoXY(X,Y);

    END { if NTraded > 0 }
  ELSE BEGIN

    { no Equipment to sell, so split }

    SelectWindow(2);
    RestoreScreen;
    GoToXY(X,Y);
    SaveScreen(X,Y);
    TextColor(White);
    TextBackground(Red);
    GoToXY(10,10);WriteLn('                                      ');
    GoToXY(10,11);WriteLn(' Equipment is not bought at this port ');
    GoToXY(10,12);WriteLn('                                      ');
    Delay(3000);
    NormalVideo;
    RestoreScreen;
    GoToXY(X,Y);
  END;
END;

BEGIN { beginning of module }
END.