procedure BusyPorts;
var
  p : 0..MaxPorts;
  Number,
  i,
  s, n : SectorIndex;
  log  : boolean;
  f    : text;
begin
  for i := 1 to MaxSector do
    distances[i].s := i;
  EliminateUnwanted( distances, PortOnly, Number, 0 );
  for i := 1 to Number do
    begin
      p := portNumber(distances[i].s);
      if p <> 0 then
        with space.ports.data[p] do
          distances[i].d := round((usage[fuel] / 100) *
                        (usage[organics] / 100) * usage[equipment])
      else
        distances[i].d := -maxint;
    end; {for}
  log := prompt( 'Log to disk? ');
  if log then
    begin
      assign( f, GetNewFileName('File name for report?  ', 'busiest.txt') );
      rewrite( f );
    end;
  if Number <> 0 then
    begin
      for n := 1 to Number do
        begin
          FindSmallest( distances, n, Number );
          DisplaySector( distances[ n ].s, ' Left:',distances[n].d,
                        log, f );
          if n mod 20 = 0 then
            if not prompt( 'more? ') then
              begin
                if log then
                  close( f );
                  exit;
              end;
        end; {for}
    end; {if}
  if log then
    close( f );
end; {busiest ports}
