procedure control;
{ You specify border sectors and an internal sector, and it determines which
sectors you really control.  Yet another in the interminable timewastes of
TWViewer stuff.
   Written 3/21/91 by woody.
}

type
  controltype = ( unk, border, unexp, controlled );
  
var
  dominion : array [sector] of controltype;
  t, s : sector;
  count : integer;
  KeepGoing : boolean;
  

var
  empire : queue;

procedure EnqueueInto( s : sector; var q : queue );
{ add to the queue everything that has unknown status that can enter s }
var
  t : sector;
begin
  for t := 1 to maxSector do
    if IsWarp( t, s ) then
      if dominion[ t ] = unk then
        enqueue( q, t, s );
end; {enqueueinto}

procedure CheckUnexps;
{ look for unexplored sectors on boundary of controlled regions }
var
  warn : boolean;
  s : sector;
  i : warpindex;
begin
  warn := true;
  for s := 1 to MaxSector do
    if dominion[s] = controlled then
      for i := 1 to space.sectors[s].number do
        if dominion[ space.sectors[s].data[i] ] = unexp then
          begin
            if warn then
              writeln('Warning: the following sectors are unexplored on the border');
            warn := false;
            write( space.sectors[s].data[i] : 5 );
          end; {for if for if}
  if not warn then writeln;
end; {CheckUnexps}

begin {control}
  writeln;
  writeln;
  writeln('Border sectors are your militarized zones that you are');
  writeln('certain you control (by force).');
  repeat
    for s := 1 to maxSector do
      if space.sectors[s].number = UnExplored then
        dominion[s] := unexp
      else
        dominion[s] := unk;
    writeln;
    writeln('Please enter border sectors.  Enter 0 to finish.');
    s := GetSector;
    repeat
      dominion[ s ] := border;
      s := GetSector;
    until s = 0;
    write('One sector that is inside your domain? ');
    empire.front := 0;
    s := GetSector;
    if s = 0 then 
      halt;
    Enqueue( empire, s, s );
    writeln('Controlled sectors:');
    count := 0;
    KeepGoing := true;
    while (empire.front <> 0) and KeepGoing do
      begin
        serve( empire, s, t );
        EnqueueInto( s, empire );      { add everything that can enter }
        dominion[ s ] := controlled;
        write( s : 9, '->', t:5 );
        count := count + 1;
        if space.sectors[s].etc and SpaceLane <> Nothing then
          begin
            writeln;
            writeln('error: sector ', s, ' is a major space lane and uncontrollable.');
            Keepgoing := false;
          end
        else if count mod 10 = 0 then
          keepGoing := not prompt('     Stop? ');
      end; {while}
    writeln;
    writeln('Total of ', count, ' controlled sectors.');
    checkUnexps;
  until not prompt('Again? ');
end;