{GSDATA.INC}
const
  SectorFieldMarker = 'Sector data starts here...';
  
procedure writeSectors( var g : text; var ss : SectorArray );
var
  s : sector;
  i : 0..maxWarps;
begin
  writeln( g, SectorFieldMarker);
  for s := 1 to maxSector do
    with ss[s] do
      if (number <> Unexplored) or (PortType <> NotAPort) or (etc <> Nothing) then
      begin
        write( g, s : 5, number:3 );
        for i := 1 to number do
          write( g, data[i] : 5);
        write( g, portType : 3 );
        write( g, etc : 6 );
        writeln( g );
      end; {for if}
end; {writeSectors}

procedure WriteDock( var g : text; d : integer );
begin
  writeln( g, 'SpaceDock is ', d : 5 );
end;

procedure WriteNotes( var g : text; var n : NoteList );
var
  i : 1..MaxNote;
begin
  writeln( g, n.top, '  <- number of notes' );
  if n.top > 0 then
    for i := 1 to n.top do
      writeln( g, n.data[ i ].reference : 5, ' ', n.data[i].info );
end; {WriteNotes}

procedure WritePorts( var g : text; var p : PortList );
var
  i : 1..MaxPorts;
begin
  writeln( g, p.top, '  <- number of Port Infos' );
  if p.top > 0 then
    for i := 1 to p.top do
      with p.data[i] do
        writeln( g, where : 5, amts[ Fuel ] : 8, amts[ Organics ] : 8, 
                 amts[ Equipment ] : 8, usage[ Fuel ] : 4,
                 usage[ Organics ] : 4, usage[ Equipment ] : 4, ' ',
                 change[ Fuel ] : 5, ' ', change[ Organics ] : 5,
                 ' ', change[ Equipment ] : 5 );
end; {WritePorts}

const
 DataFileIdentifier = '::Tradewars Data file::';
 
procedure SaveData( var g : text; var Space : TheVoid );
begin
  writeln(g, DataFileIdentifier );
  writeDock( g, Space.dock );
  writeNotes( g, Space.notes );
  writePorts( g, space.ports );
  writeSectors( g, space.sectors );
  close( g );
end; {SaveData}

procedure InitSectors( var s : SectorArray );
var
  r : sector;
begin
  for r := 1 to maxSector do
    with s[r] do
      begin
        number  := UnExplored;
        portType:= NotAPort;
        etc     := Nothing;
      end; {for with}
end; {Init Sectors}


function bval( line : string; var n : integer) : boolean;
{ convert  nonnegative numeric value at front of line into n; return whether
conversion was successful. }
var
  i : integer;
  error : boolean;

begin
  i := 1;
  n := 0;
  Error := true;
  while ( i <= length( line ) ) do
    if line[i] = ' ' then
      i := i + 1
    else if line[ i ] in ['0'..'9'] then
      begin
        Error := false;
        n := 10 * n + ord( line[ i ] ) - ord('0');
        i := i + 1;
      end
    else
      i := length( line ) + 1;
  bval := error;
end;

procedure InitPorts( var p : portList );
const
  empty  : goodsArray = ( 0, 0, 0 );
var
  i : portIndex;
begin
  p.top := 0;
  for i := 1 to MaxPorts do
    p.data[i].amts := empty;
end;

procedure InitSpace( var s : TheVoid );
begin
  s.dock  := 0;
  s.notes.top := 0;
  InitPorts( s.ports );
  InitSectors( s.sectors );
end;

procedure ReadSectors( var h : text; var ss : SectorArray );
var
  r : sector;
  i : 0..maxSector;
  temp,
  etccount,
  portcount,
  sectorcount :integer;
  line : string;
begin
  portcount := 0; sectorcount := 0; etccount := 0;
  readln( h, line);   { "Sector data starts here..." }
  if line <> SectorFieldMarker then
    writeln('Sector data missing?  Found ', line )
  else
    while not eof( h ) do
      begin
        read( h, r );
        sectorcount := sectorcount + 1;
        with ss[r] do
          begin
            read( h, number );
            for i := 1 to number do
              begin
                read( h, temp );
                if (temp >= 1) and (temp <= maxSector) then
                  data[ i ] := temp
                else
                  writeln('bad data for sector ', r);
              end; {for}
            read( h, temp );
            if temp <> NotAPort then
              PortType := temp;
            if PortType <> NotAPort then
              portcount := portcount + 1;
            read( h, temp );
            etc := etc or temp;
            if etc <> Nothing then
              etccount := etccount + 1;
          end; {with}
        readln( h );
      end; {while}
  writeln('Finished reading ', sectorcount, ' sectors, ',
           portcount, ' ports, ', etccount, ' etc.');
end; {ReadSectors}

procedure ReadDock( var f : text; var d : SectorIndex );
begin
  if d = 0 then
    begin
      skip( f, 12);    { "SpaceDock is" }
      readln( f, d );
      if d = 0 then
        writeln('Space Dock location unknown')
      else
        writeln('Space Dock location ', d );
    end
  else  {already known, just skip line}
    readln( f );
end; {ReadDock}

procedure ReadNotes( var f : text; var sn : NoteList );
var
  NoteIndex,
  i : 0..MaxNote;
  more,
  j : integer;
  n : string;
begin
  readln( f, more );
  if more > 0 then
    for i := 1 to more do
      begin
        readln( f, n );
        if not bval( copy( n, 1, 5 ), j ) then
          begin
            NoteIndex := NoteNumber( j );         { is this note new? }
            if NoteIndex = 0 then                 { yes, so add to    }
              if sn.top = MaxNote then
                writeln('Too many notes.  Can''t record information')
              else
                begin                             { # notes, and work }
                  sn.top := sn.top + 1;           { with that entry   }
                  NoteIndex := sn.top;
                end; {if}
            with sn.data[ NoteIndex ] do          { then store it     }
              begin
                reference := j;
                info := copy( n, 7, NoteSize);
              end {with}
          end {if}
        else
          writeln('Error with note ', n );
      end; {for}
  writeln('Info for ', sn.top, ' notes ');
end; {ReadNotes}

procedure ReadPorts( var f : text; var sp : PortList );
const
  debug = false;
var
  p, i : 0..MaxPorts;
  location : sector;
  more : integer;
begin
  readln( f, more );
  if debug then write('Should get ', more, ' ports.');
  if debug then writeln('Top currently ', sp.top );
  if more > 0 then
    for i := 1 to more do
      begin
        read( f, location );
        p := portnumber( location );
        if debug then write( location : 5, ' to ', p : 3 );
        if p = 0 then
          begin
            sp.top := sp.top + 1;
            p := sp.top;
            if debug then write (' => ', p : 3, ' ');
          end; {if}
        sp.data[p].where := location;
        with sp.data[ p ] do
          begin
            read( f, amts[ Fuel ], amts[ Organics ], amts[ Equipment ]);
            if not eoln( f ) then
               read( f, usage[Fuel], usage[Organics], usage[Equipment] )
            else
              begin
                usage[fuel] := 0;
                usage[organics] := 0;
                usage[equipment] := 0;
              end;
            if not eoln( f ) then
              read( f, change[Fuel], change[Organics], change[Equipment] )
            else
              begin
                change[Fuel] := amts[Fuel];
                change[Organics] := amts[Organics];
                change[Equipment] := amts[Equipment];
              end;
            readln( f );
          end; {with}
      end; {if for}
  writeln('Info for ', sp.top, ' ports');
end; {ReadPorts}

procedure GetData( var space : TheVoid; var name : string );
var
  h : text;
  line,
  filename : string;
begin
  if name = '' then
    begin
      writeln('Hit carriage return if data base hasn''t been generated yet.');
      write('Name of data file?  ');
      readln( filename );
    end {if}
  else
    filename := name;
  if filename = '' then
    writeln('Okay, initializing with empty space.')
  else
    begin
      assign( h, filename );
{$I-}
      reset( h );
{$I+}
      if ioresult <> 0 then
        begin
          writeln('Sorry, there seems to be a problem finding the file ', filename );
          writeln('Does it really exist?  Have you misspelled it?  Wrong default directory?');
          writeln('Anyway, I''m not sure where to go from here, so I''m giving up.');
          writeln('Sorry about that, but hey, if you can''t control your files...');
          halt;
        end; {if}
      if pos( '.', filename) <> 0 then
        name := copy( filename, 1, pos( '.', filename) - 1 )
      else
        name := '';
      readln( h, line );
      if line <> DataFileIdentifier then
        begin
          writeln('This is not a trade wars database file!');
          halt;
        end; {Error}
      ReadDock( h, Space.dock );
      ReadNotes( h, Space.notes );
      ReadPorts( h, space.ports );
      ReadSectors( h, space.sectors );
      close( h );
    end; {if filename <> '' }
end; {GetData}
