type
  datum = record
            s : sectorIndex;
            c : integer;
          end;
  ChangeIndex = array [ portPtr ] of datum;


procedure LoadChange( var portChange : changeIndex );
{set up the index list }
var
  p : PortIndex;
begin
  for p := 1 to space.ports.top do
    with space.ports.data[p], portchange[p] do
      begin
        s := p;
        c := abs( change[Fuel] ) + abs( change[Organics] )
           + abs( change[Equipment] );
      end;  {for with}
end; {LoadChange}

procedure SortChange( var change : ChangeIndex );
{ sort the ChangeIndex array based upon change field }

procedure quicksort( start, finish : portIndex );
{ This uses C.M. Hoare's quicksort algorithm to sort the entries}
var
   left, right   : portIndex;
   starter       : integer;
   temp          : datum;

begin
  left := start;
  right := finish;
  starter := change[(start + finish) div 2].c;   {middle of array}
  repeat
    while change[left].c > starter do
      left := left + 1;		{find a smaller value on the left}
    while starter > change[right].c do
      right := right - 1;
    if left <= right then		{we haven't gone too far, so}
      begin
	temp := change[left];		{swap the two}
	change[left] := change[right];
	change[right] := temp;
        left := left + 1;
        right := right -1;	{and update the pointers}
      end; {{if}
  until right < left;
  if start < right then quicksort(start, right );
  if left < finish then quicksort(left, finish );
end;  {quicksort}

begin
  quicksort( 1, space.ports.top );
end;

procedure DisplayChangeInfo( p : portIndex; total : integer );
{ display the information for entry p of the port sales info record }
var
  s : sectorIndex;
  line : string;
  item : goods;
begin
  s := space.ports.data[p].where;
  line := 'Port: ' + str( s, 3 );
  AddEtc( s, line );
  line := line + ' ' + status( space.sectors[s].portType) + DisplayPort( p );
  writeln( line );
  line := 'Net change: ' + str( total, 5 ) + ' with changes ';
  for item := Fuel to Equipment do
    line := line + ' ' + str( space.ports.data[p].change[item], 5);
  writeln( line );
end;

procedure HighChange;
{Identify the ports that have changed the most since last record }

var
  PortChange : ChangeIndex;
  p : portIndex;
  keepGoing : boolean;

begin
  LoadChange( PortChange );
  SortChange( PortChange );
  KeepGoing := true;
  for p := 1 to space.ports.top do
    if KeepGoing and (PortChange[p].c > 0) then
      begin
        DisplayChangeInfo( PortChange[p].s, PortChange[p].c );
        if p mod 10 = 0 then
          KeepGoing := prompt( 'more? ');
      end; {for if}
end; {HighChange}