procedure AddNote( var BaseChanged : boolean );
var s : SectorIndex;
    n : NoteIndex;
begin
  write('Add note for ');
  s := GetSector;
  if s = 0 then
    exit;
  n := noteNumber( s );
  if (n=0) and (space.notes.top = MaxNote) then
    begin
      writeln('Sorry, notes full.  You must delete a note first');
      exit;
    end; {if}
  BaseChanged := true;
  if n = 0 then
    begin
      space.notes.top := space.notes.top + 1;
      n := space.notes.top;
    end {if}
  else
    writeln('wiping out old note: ', space.notes.data[n].info );
  with space.notes.data[ n ] do
    repeat
      reference := s;
      write('Note: ');
      readln( info );
      writeln('Sector ',reference : 5, ' ', info );
    until prompt('Is this okay? ');
  space.sectors[s].etc := space.sectors[s].etc or NoteExists;
end; {Add Note}

procedure RemoveNote( var BaseChanged : boolean);
var 
  s : sectorIndex;
  n : NoteIndex;
begin
  write('Remove note for ');
  s := GetSector;
  if s = 0 then exit;
  n := NoteNumber( s );
  if n = 0 then
    writeln('no note for sector ', s, ' was found!')
  else
    begin
      writeln('Current note: ', space.notes.data[n].info );
      if prompt('Remove it? ') then
        begin
          space.notes.data[n] := space.notes.data[ space.notes.top ];
          space.notes.top := space.notes.top - 1;
          space.sectors[s].etc := space.sectors[s].etc and ( not NoteExists);
          BaseChanged := true;
        end; {if}
    end; {else}
end; {RemoveNote}
