procedure GetExplored( var scanme : sectorscanner );
var
  n : integer;
  s : sector;
begin
  writeln('Examining list of EXPLORED sectors.');
  for s := 1 to maxSector do
    scanme[ s ] := false;
  n := readNumber(f);
  while (not eof( f )) and (n>0) do
    begin
      if space.sectors[n].number = 0 then
        scanme[ n ] := true;
      n := readNumber(f);
    end; {while}
end; {GetExplored}

procedure GetUnexplored( var ScanMe : sectorscanner );
var
  n         : integer;
  s         : sector;
begin
  writeln('Examining list of UNEXPLORED sectors.');
  for s := 1 to MaxSector do                            { if unexplored }
    ScanMe[ s ] := space.sectors[s].number=Unexplored;  { we'd like it  }
  n := readnumber(f);
  while (not eof(f) ) and (n>0) do
    begin
      ScanMe[ n ] := false;                              { no info       }
      n := ReadNumber(f);
    end; {while}
end; {GetUnexplored}

procedure PartOneThree;
{Determines if this is an EXPLORED or UNEXPLORED log, and creates scan 
accordingly.}
var
  newcount,
  count, n : integer;
  line     : string;
  ch       : char;
  ScanMe   : sectorScanner;
  s        : sector;
  PortsToo : boolean;
begin
  repeat
    readln( f, line );
  until (pos( 'sectors:', line ) > 0) or eof( f );
  PortsToo := prompt('Do you want port report inquiries included? ');
  if pos('NOT', line) > 0 then
    GetUnexplored( ScanMe )
  else
    GetExplored( ScanMe );
  newcount := 0;
  for s := 1 to MaxSector do
    if ScanMe[s] then
      begin
        newcount := newcount + 1;
        writeln('New sector infor for ', s );
        writeln( g, 'I', s);
        if PortsToo then
          writeln( g, 'R', s );
      end;
  writeln('Explored ', newcount, ' new sectors.');
  close( g );
end; {PartOneThree}
