{part 2.inc}

procedure LoadData( var TheSector : SectorInfo );
var
  ch : char;
begin
  with TheSector do
    begin
      number := 0;
      repeat
        read( f, ch );
      until ch = ':';
      ch := '-';
      while ch = '-' do
        begin
          number := number + 1;
          data[ number ] := ReadNumber(f);
          read( f, ch );
        end; {while}
      readln( f );
    end; {with}
end; {LoadData}

procedure CheckData( var TheSector : SectorInfo );
var
  t  : warpIndex;
  ch : char;
begin
  repeat
    read( f, ch );
  until ch = ':';
  for t := 1 to TheSector.number do
    begin
      if TheSector.data[ t ] <> ReadNumber(f) then
        begin
          write('Log data doesn''t match input data!  Exiting without save!');
          halt;
        end; {if}
      read( f, ch );
    end; {for}
  readln( f );
end; {Data}

procedure ProcessWarps( var space : TheVoid );
var
  s    : integer;
  line : string;
begin
  skip( f, 6);
  s := ReadNumber(f);
  writeln('Processing sector ', s );
  if s = 0 then
    begin
      writeln('Something is screwy.  Exiting.');
      readln;
      writeln('Screwup after line:');
      writeln( line );
      readln;
      SaveData( g, space );
      readln;
      halt;
    end;
  if space.sectors[s].number > 0 then
    CheckData( space.sectors[ s ] )
  else
    LoadData( space.sectors[ s ] );
end; {ProcessWarps}

procedure GetPortStatus(     s        : sector;
                         var PortType : stuff;
                             line     : string;
                         var ThePorts : Portlist );
var
  ch : char;
  use: PercentArray;
  pa : GoodsArray;
  NewSlot : PortIndex;
  item : goods;

begin
  if pos( 'You can buy', line ) > 0 then
    PortType := Class0
  else
    begin              
      readln( f, line );  { blank }
      readln( f, line );  { items }
      readln( f, line );  { ----- }
      skip( f, 11 );
      read( f, ch );
      skip( f, 8 );
      pa[ Fuel ] := readNumber(f);
      use[Fuel] := readNumber(f);
      readln( f );
      if ch = 'B' then
        begin
          PortType := 0;
          pa[ Fuel ] := -pa[ fuel ];
        end {if}
      else
        PortType := 1;
      skip( f, 11 );
      read( f, ch );
      skip( f, 8 );
      pa[ Organics ] := readNumber(f);
      use[Organics] := readNumber(f);
      readln( f );
      if ch = 'B' then
        pa[ Organics ] := -pa[ Organics ]
      else
        PortType := PortType + 2;
      skip( f, 11 );
      read( f, ch );
      skip( f, 8 );
      pa[ Equipment ] := readNumber(f);
      use[Equipment] := readNumber(f);
      readln( f );
      if ch = 'B' then
        pa[ Equipment ] := -pa[ Equipment ]
      else
        PortType := PortType + 4;
      if (pa[ Fuel ]=0) or (pa[ Organics ]=0) or ( pa[ Equipment ] = 0) then
        begin {fuck up}
          writeln('Something is screwy with sector ', s, ' in the log.');
          writeln('Current values: ', pa[Fuel]:6, 
                   pa[organics]:6, pa[equipment]:6);
          write('Hit carriage return to acknowledge:');
          readln;
        end   {fuck up}
      else
        begin
          NewSlot := FindPortSlot( ThePorts.top, s );
          if NewSlot = 0 then
            begin
              writeln('Can''t record all of our port info!');
              writeln('Need to recompile with larger MaxPorts (currently ', MaxPorts, ')');
              write('Hit carriage return to acknowledge:');
              readln;
            end {outta slots}
          else with ThePorts.data[ NewSlot ] do
            begin
              where := s;
              for item := Fuel to Equipment do
                change[ item ] := pa[ item ] - amts[ item ];
              amts := pa;
              usage := use;
            end; {else}
        end; {else no fuckup}
    end; {else not class 0}
end; {GetPortStatus}

procedure ProcessPorts( var space    : TheVoid;
                            line     : string );
var
  LeftBrack, s : integer;
  ch : char;
  err : string;
begin
  LeftBrack := pos( ']', line );
  delete( line, 1, LeftBrack );
  if bval( line, s ) then
    writeln('error parsing sector ', line )
  else if (s<1) or (s>maxSector) then
    writeln('sector value', s, ' out of bounds ')
  else if not eof( f ) then
    begin
      readln( f );           { next line is blank }
      if not eof( f ) then
        begin
          readln( f, line );
          if (copy( line, 1, 8) = 'Commerce') and (not eof( f )) then
            begin
              if pos( 'Stargate Alpha', line ) > 0 then
                begin
                  writeln('StarDock found in sector ', s);
                  space.dock := s;
                  space.sectors[ s ].etc := space.sectors[ s ].etc or StarDock;
                end;
              space.sectors[ s ].etc := space.sectors[ s ].etc or IsPort;
              GetPortStatus( s, space.sectors[ s ].portType, line, space.Ports );
              writeln('Status on port ', s, ' : ', status(space.sectors[s].portType) );
            end; {if}
        end; {if}
    end; {eof}
end; {ProcessPorts}

procedure PartII( var space : TheVoid );
var
  line : string;
  ch : char;
  s, i : integer;
  finished : boolean;
begin
  while not eof( f ) do
    begin
      readln( f, line );
      if pos( 'examine?', line ) > 0 then
        processWarps( space )
      else if pos( 'What sector is the port in?', line) > 0 then
        processPorts( space, line );
    end; {while}
  writeln('Log processed... updating now.');
  SaveData( g, space );
end; {PartII}
