procedure PartV;
{ generate an upload to determine the Major Space Lanes. }
var
  Class0Count : integer;
  Class0s     : array [1..3] of sectorIndex;
  s           : sectorIndex;
  
begin
  for Class0Count := 1 to 3 do
    Class0s[ Class0Count ] := 0;
  Class0Count := 0;
  for s := 1 to MaxSector do
    if space.sectors[s].PortType = Class0 then
      begin
        Class0Count := Class0Count + 1;
        writeln( s, ' is a Class 0 port.');
        Class0s[ Class0Count ] := s;
      end;
  writeln('Number of Class 0 ports detected: ', Class0Count );
  if Class0Count < 3 then
    begin
      writeln('To find the major space lanes, I need the locations of the');
      writeln('class 0 ports.  Please list any additional known ports.');
      repeat
        write('Unlisted Class 0 port? (0 to abort) ');
        readln( s );
        if s > 0 then
          begin
            Class0Count := Class0Count + 1;
            Class0s[ Class0Count ] := s;
          end; {if}
      until (s = 0) or (Class0Count = 3);
    end; {if}
  if space.dock = 0 then
    begin
      writeln('Most important to the space lane computation is the location of the');
      writeln('Space Dock.  If you know its location, please give it.');
      write('Space Dock?  (0 to abort) ');
      readln( space.dock );
    end; {if}
  if space.dock > 0 then
    for Class0Count := 1 to 3 do
      if Class0s[Class0Count] <> 0 then
        begin
          writeln( g, 'F', space.dock);
          writeln( g, Class0s[Class0Count] );
          writeln( g, 'F', Class0s[Class0Count] );
          writeln( g, space.dock );
        end; {if for if}
  if (Class0s[2] <> 0) and (Class0s[3] <> 0) then
    begin
      writeln( g, 'F', Class0s[2] );
      writeln( g, Class0s[3]);
      writeln( g, 'F', Class0s[3] );
      writeln( g, Class0s[2]);
    end; {if}
  close( g );
end; {PartV}