{ part 8 and 9 }

procedure parseIReportLine( var f : text; var s : TheVoid );
{ parse one line of the sector report }
var
  WhichSector, AdjacentSector : sectorIndex;
begin
  WhichSector := readNumber( f );
  if WhichSector <> 0 then
    begin
      read(f, AdjacentSector );
      if adjacentSector <> 0 then
      with space.sectors[WhichSector] do
          begin
            if number = 0 then
              writeln('New info for sector ', WhichSector );
            number := 1;
            data[1] := AdjacentSector;
            while not eoln( f ) do
              begin
                read( f, AdjacentSector );
                number := number + 1;
                data[number] := AdjacentSector;
              end; {while}
          end; {if}
    end; {if}
  readln( f );
end; {Parse I Report Line}

procedure PartVIII( var data : text; var space : TheVoid );
{ read the sector report from the data file }
begin
  while not eof( data ) do
    parseIReportLine( data,  space );
  SaveData( g, space );
end;

procedure GetPercentage( var f : text; var p : percent );
var
  ch : char;
begin
  p := 0;
  read( f, ch );
  repeat
    if ch in ['0'..'9'] then
      begin
        p := 10 * p + ord(ch) - ord('0');
      end;
    read( f, ch );
  until (ch = '%') or eof( f );
end; {Get Percentage}

procedure ParseRReportLine( var f : text; var space : TheVoid );
{ Given a list of ports, figure out the relevant info }
var
  WhichPort  : PortIndex;
  CurrSector : SectorIndex;
  tmp        : integer;
  temp       : char;
  item       : goods;
begin
  CurrSector := readNumber( f );
  read( f, temp );
  if (CurrSector <> 0) then
    if temp = '0' then
      begin
        WhichPort := PortNumber( CurrSector );
        if WhichPort <> 0 then                           { scanner blocked }
          with space.ports.data[whichport] do
            begin
              if usage[ Equipment ] <> 0 then
                writeln('Scanner newly blocked in sector ', CurrSector);
              for item := Fuel to Equipment do          { assume max values}
                if usage[item] <> 0 then
                  begin
                    tmp := round( amts[ item ]/ usage[ item]) * 100;
                    change[ item ] := tmp - amts[ item ];
                    amts[ item ]:= tmp;
                  end
                else
                  change[item] := 0;
              for item := Fuel to Equipment do          {then flag by with}
                usage[item] := 0;                       { use set to 0  }
            end; {if with}
      end {temp=0}
    else
      begin
        space.sectors[CurrSector].etc := space.sectors[CurrSector].etc
                                                  or IsPort;
        WhichPort := FindPortSlot( space.ports.top, CurrSector );
        if WhichPort = 0 then
          begin
            writeln('Too many ports!  Please recompile with a larger');
            writeln('MAXPORTS value.  Aborting...');
            readln;
            halt;
          end; {if}
        space.ports.data[WhichPort].where := CurrSector;
        for item := Fuel to equipment do
          with space.ports.data[WhichPort] do
            begin
              read( f, tmp );
              if temp = '-' then
                tmp := -tmp;
              change[ item ] := tmp - amts[ item ];
              amts[ item ] := tmp;
              GetPercentage( f, usage[item] );
              read( f, temp );
              if item <> equipment then
                read( f, temp );
            end; {for}
        space.sectors[CurrSector].PortType :=
            ComputePortType( space.ports.data[WhichPort].amts);
      end; {if}
end; {Parse Report}

procedure FindFirstIReportLine( var f : text );
var
  i : integer;
begin
  repeat
    i := ReadNumber( f );
    readln( f );
  until i <> 0;
end;

procedure PartIX( var data : text; var space : TheVoid );
{ read the ports report from the data file }
begin
  FindFirstIReportLine( data );
  while not eof( data ) do
    parseRReportLine( data, space );
  SaveData( g, space );
end;