{

  Turbo Pascal Borland Graphics Interface (BGI) demonstration
  program. This program shows how to use many features of
  the Graph unit.

  Copyright (c) 1985-89 by Borland International, Inc.

}
{
  Modified for use in twview graphics: 10/21/91 by woody
}

var
  GraphDriver : integer;  { The Graphics device driver }
  GraphMode   : integer;  { The Graphics mode value }
  ErrorCode   : integer;  { Reports any graphics errors }
  MaxColor    : word;     { The maximum color value available }


{$F+}
function DetectVGA256 : integer;
{ Detects VGA or MCGA video cards }
var
  DetectedDriver : integer;
  SuggestedMode  : integer;
begin
  DetectGraph(DetectedDriver, SuggestedMode);
  if (DetectedDriver = VGA) or (DetectedDriver = MCGA) then
  begin
    Writeln('Which video mode would you like to use?');
    Writeln('  0) 320x200x256');
    Writeln('  1) 640x400x256');
    Writeln('  2) 640x480x256');
    Writeln('  3) 800x600x256');
    Writeln('  4) 1024x768x256');
    Write('> ');
    Readln(SuggestedMode);
    DetectVGA256 := SuggestedMode;
  end
  else
    DetectVGA256 := grError; { Couldn't detect hardware }
end; { DetectVGA256 }
{$F-}

{$F+}
function DetectTwk256 : integer;
{ Detects VGA or MCGA video cards }
var
  DetectedDriver : integer;
  SuggestedMode  : integer;
begin
  DetectGraph(DetectedDriver, SuggestedMode);
  if (DetectedDriver = VGA) or (DetectedDriver = MCGA) then
  begin
    Writeln('Which video mode would you like to use?');
    Writeln('  0) 320x400x256');
    Writeln('  1) 320x480x256');
    Writeln('  2) 360x480x256');
    Writeln('  3) 376x564x256');
    Writeln('  4) 400x564x256');
    Writeln('  5) 400x600x256');
    Write('> ');
    Readln(SuggestedMode);
    DetectTwk256 := SuggestedMode;
  end
  else
    DetectTwk256 := grError; { Couldn't detect hardware }
end; { DetectVGA256 }
{$F-}


{$F+}
function DetectVGA16 : integer;
{ Detects VGA or MCGA video cards }
var
  DetectedDriver : integer;
  SuggestedMode  : integer;
begin
  DetectGraph(DetectedDriver, SuggestedMode);
  if (DetectedDriver = EGA) or (DetectedDriver = VGA) then
  begin
    Writeln('Which video mode would you like to use?');
    Writeln('  0) 320x200x16');
    Writeln('  1) 640x200x16');
    Writeln('  2) 640x350x16');
    Writeln('  3) 640x480x16');
    Writeln('  4) 800x600x16');
    Writeln('  5) 1024x768x16');
    Write('> ');
    Readln(SuggestedMode);
    DetectVGA16 := SuggestedMode;
  end
  else
    DetectVGA16 := grError; { Couldn't detect hardware }
end; { DetectVGA256 }
{$F-}

{$F+}
function DetectTwk16 : integer;
{ Detects VGA or MCGA video cards }
var
  DetectedDriver : integer;
  SuggestedMode  : integer;
begin
  DetectGraph(DetectedDriver, SuggestedMode);
  if (DetectedDriver = VGA) then
  begin
    Writeln('Which video mode would you like to use?');
    Writeln('  0) 704x528x16');
    Writeln('  1) 720x540x16');
    Writeln('  2) 736x552x16');
    Writeln('  3) 752x564x16');
    Writeln('  4) 768x576x16');
    Writeln('  5) 784x588x16');
    Writeln('  6) 800x600x16');
    Write('> ');
    Readln(SuggestedMode);
    DetectTwk16 := SuggestedMode;
  end
  else
    DetectTwk16 := grError; { Couldn't detect hardware }
end; { DetectVGA256 }
{$F-}

var
  AutoDetectPointer : pointer;

procedure InitializeSpecialGraphics;
{ Initialize graphics and report any errors that may occur }
var
  InGraphicsMode : boolean; { Flags initialization of graphics mode }
  PathToDriver   : string;  { Stores the DOS path to *.BGI & *.CHR }
  UseWhichDriver : integer;
begin
  { when using Crt and graphics, turn off Crt's memory-mapped writes }
  DirectVideo := False;
  PathToDriver := '';
  repeat
    Writeln('Which driver to use?');
    Writeln('  0) Svga256');
    Writeln('  1) Svga16');
    Writeln('  2) Tweak256');
    Writeln('  3) Tweak16');
    Write('>');
    Readln(UseWhichDriver);
    if (UseWhichDriver = 0) then
    begin
      AutoDetectPointer := @DetectVGA256;
      GraphDriver := InstallUserDriver('Svga256',AutoDetectPointer);
    end
    else if (UseWhichDriver=1) then
    begin
      AutoDetectPointer := @DetectVGA16;   { Point to detection routine }
      GraphDriver := InstallUserDriver('SVGA16', AutoDetectPointer);
    end
    else if (UseWhichDriver=2) then
    begin
      AutoDetectPointer := @DetectTwk256;
      GraphDriver := InstallUserDriver('Twk256',AutoDetectPointer);
    end
    else if (UseWhichDriver=3) then
    begin
      AutoDetectPointer := @DetectTwk16;
      GraphDriver := InstallUserDriver('Twk16',AutoDetectPointer);
    end;
    GraphDriver := Detect;
    InitGraph(GraphDriver, GraphMode, PathToDriver);
    ErrorCode := GraphResult;             { preserve error return }
    if ErrorCode <> grOK then             { error? }
    begin
      Writeln('Graphics error: ', GraphErrorMsg(ErrorCode));
      if ErrorCode = grFileNotFound then  { Can't find driver file }
      begin
        Writeln('Enter full path to BGI driver or type <Ctrl-Break> to quit:');
        Readln(PathToDriver);
        Writeln;
      end
      else
        Halt(1);                          { Some other error: terminate }
    end;
  until ErrorCode = grOK;
  Randomize;                { init random number generator }
  MaxColor := GetMaxColor;  { Get the maximum allowable drawing color }
  XMax := GetMaxX;          { Get screen resolution values }
  YMax := GetMaxY;
  SVGA := true;
end; { InitializeSpecialGraphics }