procedure unknownSectors;
{ Are there sectors that are not anchored?  Print out a list. }
var
  display : boolean;
  Aware : array [ sector ] of boolean;
  i     : sector;
  t     : warpindex;
begin
  for i := 1 to MaxSector do
    aware[ i ] := false;
  for i := 1 to MaxSector do
    if space.sectors[i].number <> Unexplored then
      begin
        for t := 1 to space.sectors[i].number do
          aware[ space.sectors[i].data[t] ] := true;
        aware[ i ] := true;
      end; {for if}
  write('Here are the ''unattached'' sectors: ');
  display := false;
  for i := 1 to MaxSector do
    if not aware[ i ] then
      begin
        write( i : 5 );
        display := true;
      end;
  if not display then write(' NONE!');
  writeln;
end;