unit ApiInt;

interface
uses
  types;

{----------------------------------------------------------------------------}
function  apiVersion : String; far;
procedure apiInitDLL(path : String); far; { path = B&BSYS/2-root path }
{----------------------------------------------------------------------------}
function  fioReadMainCfg(var cfg : SysCfgT) : Boolean; far;
procedure fioWriteMainCfg(var cfg : SysCfgT); far;
{----------------------------------------------------------------------------}
function  fioReadNodeCfg(var cfg : ModCfgT; pos : LongInt) : Boolean; far;
procedure fioWriteNodeCfg(var cfg : ModCfgT; var pos : LongInt); far;
procedure fioDelNodeCfg; far;
function  fioGetNodeCnt : LongInt; far;
{----------------------------------------------------------------------------}
function  fioReadAreaCfg(var cfg : Area_Config_Record; pos : LongInt) : Boolean; far;
function  fioFindAreaCode(var cfg : Area_Config_Record; code : String; pos : LongInt) : Boolean; far;
function  fioFindAreaName(var cfg : Area_Config_Record; name : String; pos : LongInt) : Boolean; far;
procedure fioWriteAreaCfg(var cfg : Area_Config_Record; var pos : LongInt); far;
{----------------------------------------------------------------------------}
function  fioReadLocalUsr(var usr : LocUsers; pos : LongInt) : Boolean; far;
function  fioFindLocalUsr(var usr : LocUsers; name : String; var pos : LongInt)
                          : Boolean; far;
{----------------------------------------------------------------------------}
procedure fioWriteLocalUsr(var usr : LocUsers; var pos : LongInt); far;
function  fioGetLocalUsrCnt : LongInt; far;
{----------------------------------------------------------------------------}
function  fioReadUsrAreaReg(var reg : Area_Reg; var area : Area_Config_Record;
                            pos : LongInt) : Boolean; far;
procedure fioWriteUsrAreaReg(var reg : Area_Reg; var area : Area_Config_Record;
                             var pos : LongInt); far;
{----------------------------------------------------------------------------}
function  fioReadMsgHeader(var mhd : Area_Mhd; var area : Area_Config_Record;
                           pos : LongInt) : Boolean; far;
function  fioFindMsgNo(var mhd : Area_Mhd; var area : Area_Config_Record;
                       no : LongInt) : Boolean; far;
function  fioFindNextMsg(var mhd : Area_Mhd; var area : Area_Config_Record)
                         : Boolean; far;
procedure fioReadMsgBuf(var mhd : Area_Mhd; var area : Area_Config_Record;
                        ptr : PMsgBuffer);
procedure fioReadMsgStatus(var area : Area_Config_Record; var reg : Area_Reg;
                           usrpos : LongInt; var last, newall, newyou : LongInt); far;
procedure fioWriteMsgHeader(var mhd : Area_Mhd; var area : Area_Config_Record;
                            var pos : LongInt); far;
procedure fioUpdateMsgHeader(var mhd : Area_Mhd; var area : Area_Config_Record); far;
procedure fioWriteMsg(var mhd : Area_Mhd; var area : Area_Config_Record;
                      ptr : PMsgBuffer); far;
{----------------------------------------------------------------------------}
function  fioReadDirCfg(var cfg : Area_Directory_Record;
                        var area : Area_Config_Record; pos : LongInt) : Boolean; far;
function  fioFindDirNo(var cfg : Area_Directory_Record; no : LongInt;
                       var area : Area_Config_Record; pos : LongInt) : Boolean; far;
function  fioFindDirName(var cfg : Area_Directory_Record; name : String;
                         var area : Area_Config_Record; pos : LongInt) : Boolean; far;
procedure fioWriteDirCfg(var cfg : Area_Directory_Record;
                         var area : Area_Config_Record; var pos : LongInt); far;
{----------------------------------------------------------------------------}
function  strUpCase(S : string) : string; far;
function  strNiceCase(S : string) : string; far;
function  strInsertIdx(org, ins, idx : String) : String; far;
{----------------------------------------------------------------------------}
function  usrHaveAccess(acc : AccessT; var area : Area_Config_Record;
                        var reg : Area_Reg; var usr : LocUsers) : Boolean; far;
{----------------------------------------------------------------------------}

implementation

function  apiVersion;          external 'B&BAPI' index   1;
procedure apiInitDLL;          external 'B&BAPI' index   2;

function  fioReadMainCfg;      external 'B&BAPI' index   3;
procedure fioWriteMainCfg;     external 'B&BAPI' index   4;

function  fioReadNodeCfg;      external 'B&BAPI' index   5;
procedure fioWriteNodeCfg;     external 'B&BAPI' index   6;
procedure fioDelNodeCfg;       external 'B&BAPI' index   7;
function  fioGetNodeCnt;       external 'B&BAPI' index   8;

function  fioReadAreaCfg;      external 'B&BAPI' index   9;
function  fioFindAreaCode;     external 'B&BAPI' index  22;
function  fioFindAreaName;     external 'B&BAPI' index  23;
procedure fioWriteAreaCfg;     external 'B&BAPI' index  10;

function  fioReadLocalUsr;     external 'B&BAPI' index  11;
function  fioFindLocalUsr;     external 'B&BAPI' index  14;
procedure fioWriteLocalUsr;    external 'B&BAPI' index  12;
function  fioGetLocalUsrCnt;   external 'B&BAPI' index  13;

function  fioReadUsrAreaReg;   external 'B&BAPI' index  15;
procedure fioWriteUsrAreaReg;  external 'B&BAPI' index  16;

function  fioReadMsgHeader;    external 'B&BAPI' index  17;
function  fioFindMsgNo;        external 'B&BAPI' index  18;
function  fioFindNextMsg;      external 'B&BAPI' index  19;
procedure fioReadMsgBuf;       external 'B&BAPI' index  20;
procedure fioReadMsgStatus;    external 'B&BAPI' index  21;
procedure fioWriteMsgHeader;   external 'B&BAPI' index  34;
procedure fioUpdateMsgHeader;  external 'B&BAPI' index  29;
procedure fioWriteMsg;         external 'B&BAPI' index  28;

function  fioReadDirCfg;       external 'B&BAPI' index  30;
function  fioFindDirNo;        external 'B&BAPI' index  33;
function  fioFindDirName;      external 'B&BAPI' index  31;
procedure fioWriteDirCfg;      external 'B&BAPI' index  32;

function  strUpCase;           external 'B&BAPI' index  24;
function  strNiceCase;         external 'B&BAPI' index  25;
function  strInsertIdx;        external 'B&BAPI' index  26;
function  usrHaveAccess;       external 'B&BAPI' index  27;

end.