/*********************************************************************/
/* RING.CMD - Make something when it rings                           */
/*                                                                   */
/* This program is called by AM4PM.EXE.                              */
/*                                                                   */
/* Input:  None                                                      */
/*                                                                   */
/* Output: 0  Normal. Only AT+VLS=0 is done before waiting           */
/*         1  Full init. Reinit COM-port and everything.             */
/*         2  Terminate AM4PM.                                       */
/*                                                                   */
/*********************************************************************/

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

CALL AMDPrint 'RING.AM started'
CALL AMSetStateText 'Playing greeting message'

AMSendW('AT+VLS=2')

DLECode=AMPlayFile('GREETING.ZVD')

select
when DLECode='*' then
   return ReadCmd()
when DLECode='c' | DLECode='5' | DLECode='#' then
   return StartFaxOrModem()
when DLECode='b' then
   do
      CALL AMSetLastEventText 'Busy'
      return 0
   end
otherwise
   nop
end

AMSendW('AT+VTS=[800,0,12]')

CALL AMSetStateText 'Recording message'

CrntMFile=AMOpenRecFile()

CALL AMStartRec(1) /* 1 = CELP, 2 = ADPCM2, 3 = ADPCM3 */

DLECode=AMWaitDLECode()

CALL AMEndRec
CALL AMCloseRecFile

select
when DLECode='c' | DLECode='5' | DLECode='#' | DLECode='s' then
   do
      'del' CrntMFile
      return StartFaxOrModem()
   end
when DLECode='b' then
   do
      'del' CrntMFile
      CALL AMSetLastEventText 'Busy'
      return 0
   end
when DLECode='q' then
   do
      CALL AMSetLastEventText 'Message stored'
      return 0 
   end
when DLECode='*' then
   return ReadCmd()
otherwise
   nop
end

Exit 0



ReadCmd:

   CALL AMSetStateText 'Waiting for command'

   AMSendW('AT+VTS=[1600,0,5]')
   CALL AMStartListenDLECode

   UsrCmd=""
   ContProcCmd=1

   do while ContProcCmd
      DLECode=AMWaitDLECode()
      select
      when DLECode='q' | DLECode='s' | DLECode='b' | DLECode='c' then
         do
            ContProcCmd=0
         end
      when DLECode='*' then
         do 
            CALL AMEndListenDLECode
            AMSendW('AT+VTS=[1600,0,5]')
            CALL AMStartListenDLECode
            UsrCmd=""
         end
      when DLECode='#' then
         do
            CALL AMEndListenDLECode
            CALL ProcCmd UsrCmd
            CALL AMStartListenDLECode
            UsrCmd=""
         end
      when DLECode >= 0 & DLECode <= 9 then
         UsrCmd = UsrCmd""DLECode
      otherwise
         nop
      end
   end

   CALL AMEndListenDLECode
return 0



ProcCmd: arg UsrCmd

   CALL AMDPrint 'UsrCmd' UsrCmd

   select
   when UsrCmd='123' then
      CALL PlayAllFiles 
   otherwise
      AMSendW('AT+VTS=[400,0,10]')
   end

return 0


PlayAllFiles:

   CALL AMSetStateText 'Playing back messages'
   CALL AMSetLastEventText 'Playback'
   AMPlayFile('GREET2.ZVD')

   CALL SysFileTree 'M*.ZVD', 'file.', 'FO'
   if file.0 = 0 then
   do
       AMPlayFile('NOMSG.ZVD') /* There are no messages */
       return 0
   end

   AMPlayFile('SOMEMSGS.ZVD') /* Here comes the messages */

   do i=1 to file.0
      DLECode=AMPlayFile(file.i)
      if \ (DLECode='1' | DLECode='2' | DLECode='3') then
      do
         CALL AMStartListenDLECode
         DLECode=AMWaitDLECode()
         CALL AMEndListenDLECode
      end

      /* Interpret user action: 
         1 - next message, 2 - delete message, 3 - replay message 
      */
      select
      when DLECode='2' then
         do
           'del' file.i
           AMPlayFile('DELMSG.ZVD') /* Message deleted */
         end
      when DLECode='3' then
         i=i-1
      otherwise
         nop
      end

   end

   AMPlayFile('ENDMSGS.ZVD') /* That was all messages */

return 0


StartFaxOrModem:

   CALL AMSetStateText 'Looking for fax or modem'
   AMSendW('AT#B1+FCLASS=6')
   AMSendW('AT+FLID=Thomas Olsson')
   AMSendW('AT#P46 31 822239')
   ResCode=AMSendW('ATA')
   select
   when ResCode='CONNECT FAX' then
      do
        CALL AMSetLastEventText 'ReFax2 started'
        HotComm=AMGetHotComm()
        ResCode=AMStartProg('ReFax2' HotComm 'fax\')
        CALL AMDPrint 'Refax returned' ResCode
        CALL AMReleaseHotComm
        return 1
      end
   when ResCode='NO CARRIER' then
      return 1
   otherwise
      do
         CALL AMSetLastEventText 'Modem detected'
         pw=AMSendW('Enter password+(ctrl-j)')
         if pw='secret' then
         do
            CALL AMSetLastEventText 'OS2YOU started'
            HotComm=AMGetHotComm()
            ResCode=AMStartProg('Os2You -l' HotComm '-i 300 -f 100 -e cmd.exe')
            CALL AMDPrint 'Os2You returned' ResCode
            CALL AMReleaseHotComm
            return 1
         end
      end
   end
return 0
