/*********************************************
 * dirread.c : directory reader for unix (BSD)
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 *********************************************/

#include <sys/types.h>
#include <sys/dir.h>
#include <string.h>

#include "system.h"
#include "dirread.h"

static DIR *_dir;

int DirRead(path,buf,nbytes)
char *path, *buf;
int nbytes;
{
  struct direct *sdir;

  if (path != NULL)
    {
      if (_dir != NULL)
	closedir(_dir);
      _dir = opendir(path);
    }

  if (_dir == NULL)
    return(-1);

  sdir = readdir(_dir);
  if (sdir == NULL)
    return(1);

  strncpy(buf,sdir -> d_name,nbytes - 1);
  buf[nbytes - 1] = '\0';

  return(0);
}

void DirDone()
{
  if (_dir != NULL)
    closedir(_dir);
  _dir = NULL;
}
