/************************************************************
 * cttyopen.c : open a pty as the control tty (Solaris)
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 ************************************************************/

#include <sys/types.h>
#include <fcntl.h>
#include <stropts.h>
#include <unistd.h>

#include "system.h"
#include "cttyopen.h"

int CttyOpen(tty)
char *tty;
{
  int fd;

  /*
   * Enter new process group and abadon old
   * control terminal. Opening the tty makes
   * it the control terminal of the new group.
   */

  setsid(); 

  /* open stdin, stdout and stderr */

  fd = open(tty,O_RDWR); 
  if (fd < 0)
    return(-1);
 
  ioctl(fd,I_PUSH,"ptem");
  ioctl(fd,I_PUSH,"ldterm"); /* Solaris perversion .. */     
  
  if (dup2(fd,0) != 0 || dup2(fd,1) != 1 || dup2(fd,2) != 2)
    {
      close(fd);
      return(-1);
    }

  close(fd);

  return(0);
}
