/************************************************
 * utmpmod.c : modify a /etc/utmp entry, SysV (?)
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 ************************************************/

#include <string.h>
#include <sys/types.h>
#include <utmp.h>

#include "system.h"
#include "utmpmod.h"

#define StrCpy(d,s) strncpy(d,s,sizeof(d));d[sizeof(d) - 1] = '\0'

int UtmpSetEntry(line,name,host,time)
char *line, *name, *host;
long time;
{
  struct utmp sutmp;
  int i;

  memset(&sutmp,0,sizeof(sutmp));
  StrCpy(sutmp.ut_line,line);
  strncpy(sutmp.ut_user,name,sizeof(sutmp.ut_user));
  StrCpy(sutmp.ut_host,host);
  sutmp.ut_time = time;
  sutmp.ut_type = name[0] ? USER_PROCESS : DEAD_PROCESS;

  i = strlen(line);
  sutmp.ut_id[0] = line[i - 2];
  sutmp.ut_id[1] = line[i - 1];

  pututline(&sutmp);
  endutent();
  return(0);
}
