/***************************************
 * system.h : system specifics
 *
 * Copyright (C) 1992, Jouni Lepp{j{rvi
 ***************************************/


/***************************************
 * DOS
 ***************************************/

#ifdef SYS_DOS

#ifndef NULL
#define NULL ((void *) 0)
#endif

#define SYS_PROTOS 1        /* use function prototypes */

#define SYS_MAXFILE (12+1)  /* maximum filename + nul length */
#define SYS_MAXPATH (64+1)  /* maximum pathname + nul lenght */
#define SYS_PATHDELIM '\\'  /* path delimiter */

#define gethostname(b,n) strcpy(b,"PC")

#ifdef SYS_INCL_STDLIB      /* stdlib includes  */
#include <stdlib.h>
#endif

#ifdef SYS_INCL_FILEIO      /* includes for open(), read(),  */
#include <io.h>             /* write(), close(), access(),   */
#include <fcntl.h>          /* stat() etc.                   */
#include <sys\stat.h>
#endif

#endif /* #ifdef SYS_DOS */


/***************************************
 * generic (?) Unix
 ***************************************/

#ifdef SYS_UNIX

#ifndef NULL
#define NULL ((void *) 0)
#endif

#define SYS_PROTOS 0        /* use function prototypes */

#define SYS_MAXFILE (255+1) /* maximum filename + nul length */
#define SYS_MAXPATH (1024+1)/* maximum pathname + nul lenght */
#define SYS_PATHDELIM '/'   /* path delimiter */

#ifdef SYS_INCL_STDLIB      /* stdlib includes  */
#include <stdlib.h>
#include <unistd.h>
#endif

#ifdef SYS_INCL_FILEIO      /* includes for open(), read(),  */
#include <fcntl.h>          /* write(), access(), stat() etc */
#include <sys/types.h>
#include <sys/stat.h>
#define O_BINARY 0          /* sigh .. */
#endif

#endif /* #ifdef SYS_UNIX */

