/******************************************
 * usrmsg.c : display messages to the user
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 ******************************************/

#include <stdio.h>
#include <string.h>

#define SYS_PROTOS 0
#include "usrmsg.h"

#define DEBUG 1

/*
 * MsgDisplay() is used to display various messages
 * to the user while the program is running.
 *
 * This function uses MsgRealize() to display
 * the message.
 *
 * void MsgRealize(char *msg), where msg is the
 * string MsgRealize() should forward to the user
 * one way or another.
 *
 * type : message type : MSG_USER  : generic messge
 *                       MSG_ERROR : error message
 *        MSG_DEBUG : debugging message
 *
 * fmt  : printf style format string
 * ...  : optional arguments
 *
 * Varagrs are realized in a brute, but portable
 * (!) way. (va_xxx is not 100 % same in different
 * systems.)
 */

void MsgDisplay(type,fmt,a0,a1,a2,a3,a4,a5,a6,a7)
int type;
char *fmt;
int a0,a1,a2,a3,a4,a5,a6,a7;
{
    static char *msgTypes[3] = {"","Error","Debug"};
    char buf[256];

    if (type < 0 || type >= 3)
        strcpy(buf,"Error : MsgDisplay : invalid message type");
    else
    {
#if !DEBUG

        if (type == MSG_DEBUG)
            return;
#endif

        buf[0] = '\0';
        if (msgTypes[type][0])
        {
            strcat(buf,msgTypes[type]);
            strcat(buf," : ");
        }

        sprintf(&buf[strlen(buf)],fmt,a0,a1,a2,a3,a4,a5,a6,a7);
    }

    MsgRealize(buf);
}


/*
 * MsgError() uses MsgDisplay() to display the most
 * common error messages.
 *
 * where : error location (function)
 * what  : error description
 */

void MsgError(where,what)
char *where, *what;
{
#if DEBUG
    MsgDisplay(MSG_ERROR,"%s : %s",where,what);
#else
    MsgDisplay(MSG_ERROR,"%s",what);
#endif
}

