//
// Finger include holds all shared data & function definitions.
//

//
// Windows Sockets 1.0 versions define inet_addr as returning a struct,
// whereas later version use an unsigned long.  We use the latter
// definition and provide a #define for backwards compatability.
//

#define WSVERSION 0x101                   // Windows Sockets version

#if (WSVERSION == 0x100)
   #define INET_ADDR ul_inet_addr
   u_long ul_inet_addr(char *szIP);

   u_long ul_inet_addr(char *szIP)        // make our own inet_addr
   {
      IN_ADDR in;

      in = inet_addr(szIP);
      return in.s_addr;
   }
#else                               
   #define INET_ADDR inet_addr            // WS DLL has the right inet_addr
#endif

//
// miscellaneous
//

#define APIENTRY  PASCAL
#define WNDPROC   FARPROC

typedef struct                      // associates messages (or menu ids) 
{                                   // with a handler function
   UINT Code;
   LONG (*Fxn)(HWND, UINT, UINT, LONG);
} DECODEWORD;

#define dim(x) (sizeof(x) / sizeof(x[0]))

typedef unsigned long IPA;
typedef IPA FAR *LPIPA;
typedef LPIPA FAR *LPPIPA;

//
// exported from module DSPLIST
//

typedef struct line_item
{
   char *sztext;
   int len;
   struct line_item *next;
} LINEITEM;

VOID PushChars(char *buf, int buflen);
BOOL OpenDisplayList(VOID);
VOID CloseDisplayList(VOID);
VOID FreeLineList(LINEITEM *pLine);
VOID FreeDisplayList(VOID);
VOID GetDisplayList(LINEITEM **ppLine, int *pNLines);

//
// exported from NETWRK_ 
//

#define FE_ERROR     1  // finger operation was not successful
#define FE_NOPORT    2  // failure to resolve finger service to a port 
#define FE_NOHOST    3  // failure to resolve host specifier
#define FE_NOSOCK    4  // failure to obtain socket for connection
#define FE_NOCONN    5  // failure to connect to remote finger server
#define FE_NOSEND    6  // failure to send finger query
#define FE_NORECV    7  // failure to receive finger data

VOID FingerStart(VOID);
VOID InitNetInst(HWND hWnd);
VOID InitNetApp(VOID);

//
// exported from module FINGER
//

#define MAXHOST   40
#define MAXUSER   40

extern char szHostName[];    // name or address of host to finger
extern char szUser[];        // user id for query
extern HINSTANCE hInst;                // this instance of finger

VOID ReportFingerErr(UINT Err);
VOID FingerFinish(UINT Err);

//
// menu & dialog identifiers
//

#define IDM_HOST     1
#define IDM_EXIT     2
#define IDM_ABOUT    3
#define IDC_HOSTNAME 10
#define IDC_USER     11

